/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.net.URI;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ProviderConfiguration {
    private URI bucket;
    private Path storagePath;
    private Duration renewalTime;
    private Class<? extends AWSCredentialsProvider> delegateProvider;
    private Configuration configuration;
    private URI checkpointBucket;

    public ProviderConfiguration(URI uRI, Path path, Duration duration, Class<? extends AWSCredentialsProvider> clazz, Configuration configuration, URI uRI2) {
        this.bucket = uRI;
        this.storagePath = path;
        this.renewalTime = duration;
        this.delegateProvider = clazz;
        this.configuration = configuration;
        this.checkpointBucket = uRI2;
    }

    public URI getBucket() {
        return this.bucket;
    }

    public Path getStoragePath() {
        return this.storagePath;
    }

    public Duration getRenewalTime() {
        return this.renewalTime;
    }

    public Class<? extends AWSCredentialsProvider> getDelegateProvider() {
        return this.delegateProvider;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    AWSCredentialsProvider instantiate() throws Exception {
        return this.delegateProvider.getConstructor(URI.class, Configuration.class).newInstance(this.bucket, this.configuration);
    }

    public URI getCheckpointBucket() {
        return this.checkpointBucket;
    }
}

