/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentialsProvider;
import it.agilelab.bigdata.wasp.aws.auth.v2.ProviderConfiguration;
import java.net.URI;
import java.time.Duration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider;

public class ConfigurationLoader {
    private static final String CONFIGURATION_PREFIX = "it.agilelab.bigdata.wasp.aws.auth";
    private static final String CREDENTIALS_STORAGE_KEY = "storage";
    private static final String CHECKPOINT_BUCKET_KEY = "checkpointbucket";
    private static final String DELEGATE_RENEWER_KEY = "delegate";
    private static final String RENEW_MILLIS_KEY = "renewmillis";

    private static Duration lookupRenewalTime(String string, Configuration configuration, Duration duration) {
        String string2 = "it.agilelab.bigdata.wasp.aws.auth." + string + "." + RENEW_MILLIS_KEY;
        String string3 = "it.agilelab.bigdata.wasp.aws.auth.renewmillis";
        return Duration.ofMillis(configuration.getLong(string2, configuration.getLong(string3, duration.toMillis())));
    }

    private static URI lookupCheckpointBucket(String string, Configuration configuration, String string2) {
        String string3 = "it.agilelab.bigdata.wasp.aws.auth." + string + "." + CHECKPOINT_BUCKET_KEY;
        String string4 = "it.agilelab.bigdata.wasp.aws.auth.checkpointbucket";
        return new Path(configuration.getTrimmed(string3, configuration.getTrimmed(string4, string2))).toUri();
    }

    private static Class<? extends AWSCredentialsProvider> lookupDelegateRenewer(String string, Configuration configuration, Class<? extends AWSCredentialsProvider> clazz) {
        String string2 = "it.agilelab.bigdata.wasp.aws.auth." + string + "." + DELEGATE_RENEWER_KEY;
        String string3 = "it.agilelab.bigdata.wasp.aws.auth.delegate";
        return configuration.getClass(string2, configuration.getClass(string3, clazz, AWSCredentialsProvider.class), AWSCredentialsProvider.class);
    }

    private static Path lookupCredentialsStoragePath(String string, Configuration configuration, String string2) {
        String string3 = "it.agilelab.bigdata.wasp.aws.auth." + string + "." + CREDENTIALS_STORAGE_KEY;
        String string4 = "it.agilelab.bigdata.wasp.aws.auth.storage";
        return new Path(configuration.getTrimmed(string3, configuration.getTrimmed(string4, string2)));
    }

    public static ProviderConfiguration lookupConfig(URI uRI, Configuration configuration) {
        return new ProviderConfiguration(uRI, ConfigurationLoader.lookupCredentialsStoragePath(uRI.getHost(), configuration, "/tmp"), ConfigurationLoader.lookupRenewalTime(uRI.getHost(), configuration, Duration.ofMinutes(30L)), ConfigurationLoader.lookupDelegateRenewer(uRI.getHost(), configuration, SimpleAWSCredentialsProvider.class), configuration, ConfigurationLoader.lookupCheckpointBucket(uRI.getHost(), configuration, "/tmp"));
    }
}

