/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.google.common.base.Strings;
import it.agilelab.bigdata.wasp.aws.auth.v2.CredentialRenewer;
import it.agilelab.bigdata.wasp.aws.auth.v2.CredentialsSerde;
import it.agilelab.bigdata.wasp.aws.auth.v2.ProviderConfiguration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultCredentialRenewer
implements CredentialRenewer {
    private ProviderConfiguration conf;
    Logger log = LoggerFactory.getLogger(DefaultCredentialRenewer.class);
    AWSCredentialsProvider downstream;
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private AWSCredentials currentCredentials = null;

    DefaultCredentialRenewer(ProviderConfiguration providerConfiguration) {
        this.conf = providerConfiguration;
        try {
            this.downstream = providerConfiguration.instantiate();
            this.log.info("Downstream renewer is of type {}", this.downstream.getClass());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.renew();
        scheduler.scheduleAtFixedRate(this::renew, providerConfiguration.getRenewalTime().toMillis(), providerConfiguration.getRenewalTime().toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSCredentials getCredentials() {
        DefaultCredentialRenewer defaultCredentialRenewer = this;
        synchronized (defaultCredentialRenewer) {
            return this.currentCredentials;
        }
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renew() {
        DefaultCredentialRenewer defaultCredentialRenewer = this;
        synchronized (defaultCredentialRenewer) {
            try {
                this.log.info("Renewing credentials");
                this.downstream.refresh();
                this.currentCredentials = this.downstream.getCredentials();
                this.log.info("Credentials renewed");
                Path path = new Path(this.conf.getStoragePath(), this.conf.getBucket().getHost());
                this.log.info("Will write file to {}", (Object)path);
                String string = Long.toString(Long.MAX_VALUE);
                String string2 = Long.toString(Instant.now().toEpochMilli());
                String string3 = Strings.padStart((String)string2, (int)string.length(), (char)'0');
                this.log.info("Writing credentials");
                CredentialsSerde.write(this.conf.getConfiguration(), path, this.currentCredentials, string3);
                this.log.info("Wrote credentials");
                CredentialsSerde.cleanupOldCredentials(this.conf.getConfiguration(), path);
            }
            catch (Exception exception) {
                this.log.error("Failed to renew credentials ", (Throwable)exception);
            }
        }
    }
}

