/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.aws.auth.v2;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import it.agilelab.bigdata.wasp.aws.auth.v2.ConfigurationLoader;
import it.agilelab.bigdata.wasp.aws.auth.v2.CredentialsSerde;
import it.agilelab.bigdata.wasp.aws.auth.v2.ProviderConfiguration;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ExecutorSideAssumeRoleCredentialsProvider
implements AWSCredentialsProvider {
    ProviderConfiguration configuration;

    public ExecutorSideAssumeRoleCredentialsProvider(URI uRI, Configuration configuration) throws IOException {
        this.configuration = ConfigurationLoader.lookupConfig(uRI, configuration);
    }

    public AWSCredentials getCredentials() {
        Path path = new Path(this.configuration.getStoragePath(), this.configuration.getBucket().getHost());
        try {
            FileSystem fileSystem = path.getFileSystem(this.configuration.getConfiguration());
            return CredentialsSerde.read(fileSystem, path);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read credentials", iOException);
        }
    }

    public void refresh() {
    }
}

