/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.batch;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import it.agilelab.bigdata.wasp.consumers.spark.MlModels.MlModelsBroadcastDB;
import it.agilelab.bigdata.wasp.consumers.spark.MlModels.MlModelsBroadcastDB$;
import it.agilelab.bigdata.wasp.consumers.spark.MlModels.MlModelsDB;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.Strategy;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.GdprStrategy;
import it.agilelab.bigdata.wasp.models.BatchETL;
import it.agilelab.bigdata.wasp.models.BatchETLModel;
import it.agilelab.bigdata.wasp.models.BatchGdprETLModel;
import it.agilelab.bigdata.wasp.models.MlModelOnlyInfo;
import it.agilelab.bigdata.wasp.models.StrategyModel;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class BatchJobEtlExecution$ {
    public static BatchJobEtlExecution$ MODULE$;

    static {
        new BatchJobEtlExecution$();
    }

    public Try<Option<Strategy>> stepCreateStrategy(BatchETL etl, Config restConfig, SparkContext sparkContext) {
        Try<Option<Strategy>> try_;
        BatchETL batchETL = etl;
        if (batchETL instanceof BatchETLModel) {
            BatchETLModel batchETLModel = (BatchETLModel)batchETL;
            try_ = this.createStrategy(batchETLModel, restConfig, sparkContext);
        } else if (batchETL instanceof BatchGdprETLModel) {
            BatchGdprETLModel batchGdprETLModel = (BatchGdprETLModel)batchETL;
            try_ = this.createGdprStrategy(batchGdprETLModel, restConfig, sparkContext);
        } else {
            throw new MatchError((Object)batchETL);
        }
        return try_;
    }

    public Try<MlModelsBroadcastDB> stepCreateMlModelsBroadcast(MlModelsDB mlModelsDB, BatchETL batchETL, SparkContext sparkContext) {
        Try try_;
        BatchETL batchETL2 = batchETL;
        if (batchETL2 instanceof BatchETLModel) {
            BatchETLModel batchETLModel = (BatchETLModel)batchETL2;
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> mlModelsDB.createModelsBroadcast((List<MlModelOnlyInfo>)batchETLModel.mlModels(), sparkContext));
        } else if (batchETL2 instanceof BatchGdprETLModel) {
            try_ = new Success((Object)new MlModelsBroadcastDB(MlModelsBroadcastDB$.MODULE$.$lessinit$greater$default$1(), MlModelsBroadcastDB$.MODULE$.$lessinit$greater$default$2()));
        } else {
            throw new MatchError((Object)batchETL2);
        }
        return try_;
    }

    private Try<Option<Strategy>> createStrategy(BatchETLModel batchETLModel, Config restConfig, SparkContext sparkContext) {
        Some some;
        StrategyModel strategyModel;
        Success success;
        Option option = batchETLModel.strategy();
        if (None$.MODULE$.equals(option)) {
            success = new Success((Object)None$.MODULE$);
        } else if (option instanceof Some && (strategyModel = (StrategyModel)(some = (Some)option).value()) != null) {
            StrategyModel strategyModel2 = strategyModel;
            Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Strategy)Class.forName(strategyModel2.className()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            Config configuration = restConfig.withFallback((ConfigMergeable)strategyModel2.configurationConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.empty()));
            result.map((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.configuration_$eq(configuration);
                return BoxedUnit.UNIT;
            });
            result.map((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.sparkContext_$eq((Option<SparkContext>)new Some((Object)sparkContext));
                return BoxedUnit.UNIT;
            });
            success = result.map((Function1 & Serializable & scala.Serializable)x$3 -> new Some(x$3));
        } else {
            throw new MatchError((Object)option);
        }
        return success;
    }

    private Try<Some<GdprStrategy>> createGdprStrategy(BatchGdprETLModel batchETLModel, Config restConfig, SparkContext sparkContext) {
        Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (GdprStrategy)Class.forName(batchETLModel.strategy().className()).getConstructor(List.class).newInstance(batchETLModel.strategy().dataStoresConf()));
        Config configuration = restConfig.withFallback((ConfigMergeable)batchETLModel.strategy().configurationConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.empty()));
        result.map((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.configuration_$eq(configuration);
            return BoxedUnit.UNIT;
        });
        result.map((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.sparkContext_$eq((Option<SparkContext>)new Some((Object)sparkContext));
            return BoxedUnit.UNIT;
        });
        return result.map((Function1 & Serializable & scala.Serializable)x$6 -> new Some(x$6));
    }

    private BatchJobEtlExecution$() {
        MODULE$ = this;
    }
}

