/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark;

import it.agilelab.bigdata.wasp.consumers.spark.utils.SparkUtils$;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.configuration.KafkaConfigModel;
import it.agilelab.bigdata.wasp.models.configuration.SparkConfigModel;
import it.agilelab.bigdata.wasp.models.configuration.SparkStreamingConfigModel;
import it.agilelab.bigdata.wasp.models.configuration.TelemetryConfigModel;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public final class SparkSingletons$
implements Logging {
    public static SparkSingletons$ MODULE$;
    private SparkSession sparkSession;
    private SparkContext sparkContext;
    private SQLContext sqlContext;
    private final WaspLogger logger;

    static {
        new SparkSingletons$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    private SQLContext sqlContext() {
        return this.sqlContext;
    }

    private void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public boolean initializeSpark(SparkConfigModel sparkConfigModel, TelemetryConfigModel telemetryConfig, KafkaConfigModel kafkaConfigModel) throws IllegalStateException {
        boolean bl;
        SparkSingletons$ sparkSingletons$ = this;
        synchronized (sparkSingletons$) {
            boolean bl2;
            if (this.sparkSession() == null) {
                if (SparkSession$.MODULE$.getDefaultSession().isDefined()) {
                    throw new IllegalStateException("Spark was already initialized without using this method!");
                }
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "Initializing Spark...");
                SparkConf sparkConf = SparkUtils$.MODULE$.buildSparkConfFromSparkConfigModel(sparkConfigModel, telemetryConfig, kafkaConfigModel);
                this.liftedTree1$1(sparkConf);
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "Instantiating SparkSession...");
                SparkSession.Builder builder = SparkSession$.MODULE$.builder().config(sparkConf);
                SparkConfigModel sparkConfigModel2 = sparkConfigModel;
                if (sparkConfigModel2 instanceof SparkStreamingConfigModel) {
                    BoxedUnit boxedUnit;
                    SparkStreamingConfigModel sparkStreamingConfigModel = (SparkStreamingConfigModel)sparkConfigModel2;
                    if (sparkStreamingConfigModel.enableHiveSupport()) {
                        builder = builder.enableHiveSupport();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.sparkSession_$eq(builder.getOrCreate());
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "SparkSession successfully instantiated");
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(28).append("SparkContext configuration: ").append(MODULE$.sparkSession().sparkContext().hadoopConfiguration().toString()).toString());
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(31).append("SparkHadoopUtil configuration: ").append(SparkHadoopUtil$.MODULE$.get().conf().toString()).toString());
                this.sparkContext_$eq(this.sparkSession().sparkContext());
                this.sqlContext_$eq(this.sparkSession().sqlContext());
                this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "Spark successfully initialized");
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public SparkContext getSparkContext() throws IllegalStateException {
        SparkContext sparkContext;
        SparkSingletons$ sparkSingletons$ = this;
        synchronized (sparkSingletons$) {
            if (this.sparkContext() == null) {
                throw new IllegalStateException("Spark was not initialized; invoke initializeSpark with a proper configuration before calling this getter");
            }
            sparkContext = this.sparkContext();
        }
        return sparkContext;
    }

    public SparkSession getSparkSession() throws IllegalStateException {
        SparkSession sparkSession;
        SparkSingletons$ sparkSingletons$ = this;
        synchronized (sparkSingletons$) {
            if (this.sparkSession() == null) {
                throw new IllegalStateException("Spark was not initialized; invoke initializeSpark with a proper configuration before calling this getter");
            }
            sparkSession = this.sparkSession();
        }
        return sparkSession;
    }

    public SQLContext getSQLContext() throws IllegalStateException {
        SQLContext sQLContext;
        SparkSingletons$ sparkSingletons$ = this;
        synchronized (sparkSingletons$) {
            if (this.sqlContext() == null) {
                throw new IllegalStateException("Spark was not initialized; invoke initializeSpark with a proper configuration before calling this getter");
            }
            sQLContext = this.sqlContext();
        }
        return sQLContext;
    }

    private final void liftedTree1$1(SparkConf sparkConf$1) {
        try {
            this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "Instantiating SparkContext...");
            new SparkContext(sparkConf$1);
            this.logger().info((Function0 & java.io.Serializable & Serializable)() -> "SparkContext successfully instantiated");
        }
        catch (Throwable throwable) {
            SparkException sparkException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkException && (sparkException = (SparkException)throwable2).getMessage().contains("SPARK-2243")) {
                throw new IllegalStateException("Spark was already initialized without using this method!");
            }
            throw throwable;
        }
    }

    private SparkSingletons$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

