/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.hbase;

import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.DeletionFailure;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.DeletionNotFound$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.DeletionOutput;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.DeletionResult;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.DeletionSuccess$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.HBaseExactRowKeyMatch$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.HBasePrefixRowKeyMatch;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.HBasePrefixWithTimeRowKeyMatch;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.HBaseTableSource;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.KeyMatchType;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.KeyWithCorrelation;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config.HBaseDeletionConfig;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.hbase.MultipleDeletionResult;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.GdprUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hbase.HBaseUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.utils.HBaseConnection;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.ExactKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.KeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.PrefixAndTimeBoundKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.PrefixKeyValueMatchingStrategy;
import it.agilelab.bigdata.wasp.models.configuration.HBaseConfigModel;
import java.io.Serializable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HBaseDeletionHandler$
implements Logging {
    public static HBaseDeletionHandler$ MODULE$;
    private final WaspLogger logger;

    static {
        new HBaseDeletionHandler$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public Try<RDD<DeletionOutput>> delete(HBaseDeletionConfig config, StorageLevel storageLevel) {
        Try output;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Starting HBase deletion handling");
        Try try_ = output = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.delete(config.tableName(), config.hbaseConfigModel(), config.keysWithScan(), config.keyValueMatchingStrategy(), storageLevel, config.dryRun()));
        if (try_ instanceof Failure) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Deletion failed");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Deletion completed successfully");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        return output;
    }

    private RDD<DeletionOutput> delete(String tableName, Option<HBaseConfigModel> hbaseConfig, RDD<Tuple2<KeyWithCorrelation, Scan>> keysWithScanRDD, KeyValueMatchingStrategy keyValueMatchingStrategy, StorageLevel storageLevel, boolean dryRun) {
        RDD persisted = keysWithScanRDD.mapPartitions((Function1 & Serializable & scala.Serializable)keysWithScan -> {
            HBaseConnection hBaseConnection = new HBaseConnection(hbaseConfig);
            TaskContext$.MODULE$.get().addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
                hBaseConnection.closeConnection();
                return BoxedUnit.UNIT;
            });
            return (Iterator)hBaseConnection.withTable(tableName, (Function1 & Serializable & scala.Serializable)table -> {
                Iterator iterator;
                KeyValueMatchingStrategy keyValueMatchingStrategy = keyValueMatchingStrategy;
                if (keyValueMatchingStrategy instanceof ExactKeyValueMatchingStrategy) {
                    iterator = keysWithScan.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        DeletionOutput deletionOutput;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        KeyWithCorrelation keyWithCorrelation = (KeyWithCorrelation)tuple2._1();
                        Scan scan = (Scan)tuple2._2();
                        Try<DeletionResult> try_ = MODULE$.deleteRowKey((Table)table, scan, GdprUtils$.MODULE$.StringToRowKey(keyWithCorrelation.key()).asRowKey(), dryRun);
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            deletionOutput = MODULE$.createOutput((Table)table, keyWithCorrelation, HBaseExactRowKeyMatch$.MODULE$, new DeletionFailure(exception));
                            return deletionOutput;
                        } else {
                            if (!(try_ instanceof Success)) throw new MatchError(try_);
                            Success success = (Success)try_;
                            DeletionResult result = (DeletionResult)success.value();
                            deletionOutput = MODULE$.createOutput((Table)table, keyWithCorrelation, HBaseExactRowKeyMatch$.MODULE$, result);
                        }
                        return deletionOutput;
                    });
                } else if (keyValueMatchingStrategy instanceof PrefixKeyValueMatchingStrategy) {
                    iterator = keysWithScan.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        DeletionOutput deletionOutput;
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        KeyWithCorrelation key = (KeyWithCorrelation)tuple2._1();
                        Scan scan = (Scan)tuple2._2();
                        Try<MultipleDeletionResult> try_ = MODULE$.deleteMultipleRowKeys((Table)table, scan, dryRun);
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            deletionOutput = MODULE$.createOutput((Table)table, key, new HBasePrefixRowKeyMatch((Option<Seq<String>>)None$.MODULE$), new DeletionFailure(exception));
                            return deletionOutput;
                        } else {
                            if (!(try_ instanceof Success)) throw new MatchError(try_);
                            Success success = (Success)try_;
                            MultipleDeletionResult multipleDeletionResult = (MultipleDeletionResult)success.value();
                            if (multipleDeletionResult == null) throw new MatchError(try_);
                            Option<Seq<byte[]>> rowKeysMatched = multipleDeletionResult.rowKeysMatched();
                            DeletionResult result = multipleDeletionResult.result();
                            deletionOutput = MODULE$.createOutput((Table)table, key, new HBasePrefixRowKeyMatch((Option<Seq<String>>)rowKeysMatched.map((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> GdprUtils$.MODULE$.RowKeyToString((byte[])x$3).asString(), Seq$.MODULE$.canBuildFrom()))), result);
                        }
                        return deletionOutput;
                    });
                } else if (keyValueMatchingStrategy instanceof PrefixAndTimeBoundKeyValueMatchingStrategy) {
                    iterator = keysWithScan.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        DeletionOutput deletionOutput;
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        KeyWithCorrelation key = (KeyWithCorrelation)tuple2._1();
                        Scan scan = (Scan)tuple2._2();
                        Try<MultipleDeletionResult> try_ = MODULE$.deleteMultipleRowKeys((Table)table, scan, dryRun);
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            deletionOutput = MODULE$.createOutput((Table)table, key, new HBasePrefixWithTimeRowKeyMatch((Option<Seq<String>>)None$.MODULE$), new DeletionFailure(exception));
                            return deletionOutput;
                        } else {
                            if (!(try_ instanceof Success)) throw new MatchError(try_);
                            Success success = (Success)try_;
                            MultipleDeletionResult multipleDeletionResult = (MultipleDeletionResult)success.value();
                            if (multipleDeletionResult == null) throw new MatchError(try_);
                            Option<Seq<byte[]>> rowKeysMatched = multipleDeletionResult.rowKeysMatched();
                            DeletionResult result = multipleDeletionResult.result();
                            deletionOutput = MODULE$.createOutput((Table)table, key, new HBasePrefixWithTimeRowKeyMatch((Option<Seq<String>>)rowKeysMatched.map((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)x$4.map((Function1 & Serializable & scala.Serializable)x$5 -> GdprUtils$.MODULE$.RowKeyToString((byte[])x$5).asString(), Seq$.MODULE$.canBuildFrom()))), result);
                        }
                        return deletionOutput;
                    });
                } else {
                    throw new MatchError((Object)keyValueMatchingStrategy);
                }
                return iterator;
            });
        }, keysWithScanRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DeletionOutput.class)).persist(storageLevel);
        persisted.foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            HBaseDeletionHandler$.$anonfun$delete$15(x$6);
            return BoxedUnit.UNIT;
        });
        return persisted;
    }

    private Try<Object> searchSingleRowKey(Table table, byte[] keyToMatch, Scan scan) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ResultScanner scanner = table.getScanner(scan);
            try {
                boolean bl;
                java.util.Iterator iter = scanner.iterator();
                if (iter.hasNext()) {
                    byte[] rowKeyMatched = ((Result)iter.next()).getRow();
                    if (!rowKeyMatched.equals(keyToMatch)) throw new IllegalStateException(new StringBuilder(50).append("RowKey found '").append(GdprUtils$.MODULE$.RowKeyToString(rowKeyMatched).asString()).append("' is different from key to delete '").append(GdprUtils$.MODULE$.RowKeyToString(keyToMatch).asString()).append("'").toString());
                    bl = true;
                    return bl;
                } else {
                    bl = false;
                }
                return bl;
            }
            finally {
                MODULE$.closeQuietly((AutoCloseable)scanner);
            }
        });
    }

    private void closeQuietly(AutoCloseable a) {
        try {
            a.close();
        }
        catch (Throwable throwable) {}
    }

    private Try<Seq<byte[]>> searchAndReturnKeys(Table table, Scan scan) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ListBuffer listBuffer;
            ResultScanner scanner = table.getScanner(scan);
            try {
                java.util.Iterator iter = scanner.iterator();
                ListBuffer buf = new ListBuffer();
                while (iter.hasNext()) {
                    buf.$plus$eq((Object)((Result)iter.next()).getRow());
                }
                listBuffer = buf;
            }
            finally {
                MODULE$.closeQuietly((AutoCloseable)scanner);
            }
            return listBuffer;
        });
    }

    private Try<DeletionResult> deleteRowKey(Table table, Scan scan, byte[] keyToMatch, boolean dryRun) {
        return this.searchSingleRowKey(table, keyToMatch, scan).flatMap((Function1 & Serializable & scala.Serializable)rowKeyExists -> HBaseDeletionHandler$.$anonfun$deleteRowKey$1(dryRun, table, keyToMatch, BoxesRunTime.unboxToBoolean((Object)rowKeyExists)));
    }

    private Try<MultipleDeletionResult> deleteMultipleRowKeys(Table table, Scan scan, boolean dryRun) {
        Try tryRowKeysDeleted = this.searchAndReturnKeys(table, scan).flatMap((Function1 & Serializable & scala.Serializable)rowKeysFound -> GdprUtils$.MODULE$.traverseWithTry(rowKeysFound, (Function1 & Serializable & scala.Serializable)row -> !dryRun ? HBaseUtils$.MODULE$.deleteRow(table, (byte[])row).map((Function1 & Serializable & scala.Serializable)x$8 -> row) : new Success(row)).map((Function1 & Serializable & scala.Serializable)rowKeysDeleted -> rowKeysDeleted));
        return tryRowKeysDeleted.map((Function1 & Serializable & scala.Serializable)rowKeysMatched -> rowKeysMatched.isEmpty() ? new MultipleDeletionResult((Option<Seq<byte[]>>)None$.MODULE$, DeletionNotFound$.MODULE$) : new MultipleDeletionResult((Option<Seq<byte[]>>)new Some(rowKeysMatched), DeletionSuccess$.MODULE$));
    }

    private DeletionOutput createOutput(Table table, KeyWithCorrelation keyWithCorrelation, KeyMatchType keyMatchType, DeletionResult result) {
        return new DeletionOutput(keyWithCorrelation.key(), keyMatchType, new HBaseTableSource(table.getName().getNameAsString()), result, keyWithCorrelation.correlationId());
    }

    public static final /* synthetic */ void $anonfun$delete$15(DeletionOutput x$6) {
    }

    public static final /* synthetic */ Try $anonfun$deleteRowKey$1(boolean dryRun$2, Table table$4, byte[] keyToMatch$2, boolean rowKeyExists) {
        return (rowKeyExists ? (!dryRun$2 ? HBaseUtils$.MODULE$.deleteRow(table$4, keyToMatch$2).map((Function1 & Serializable & scala.Serializable)x$7 -> DeletionSuccess$.MODULE$) : new Success((Object)DeletionSuccess$.MODULE$)) : new Success((Object)DeletionNotFound$.MODULE$)).map((Function1 & Serializable & scala.Serializable)deletionResult -> deletionResult);
    }

    private HBaseDeletionHandler$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

