/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.utils;

import it.agilelab.bigdata.wasp.core.logging.GuardedLogging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.models.configuration.HBaseConfigModel;
import it.agilelab.bigdata.wasp.models.configuration.HBaseEntryConfig;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u000e\u001d\u0001-B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\u0006\r\u0002!\ta\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019I\u0006\u0001)A\u0005\u001b\"I!\f\u0001a\u0001\u0002\u0004%Ia\u0017\u0005\nI\u0002\u0001\r\u00111A\u0005\n\u0015D\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u0002/\t\u00111\u0004\u0001R1A\u0005\n5D!\"a\u0001\u0001\u0011\u000b\u0007I\u0011BA\u0003\u0011)\ti\u0001\u0001EC\u0002\u0013%\u0011q\u0002\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?Aq!!\t\u0001A\u0003%a\u000fC\u0004\u0002$\u0001!\t!!\u0002\t\r\u0005\u0015\u0002\u0001\"\u0003\\\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"1\u0011\u0011\u0012\u0001\u0005\nmCq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"Q\u0011q\u0016\u0001\t\u0006\u0004%I!!-\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0002\u0010\u0011\n\u000b7/Z\"p]:,7\r^5p]*\u0011QDH\u0001\u0006kRLGn\u001d\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\u0013\r|gn];nKJ\u001c(BA\u0012%\u0003\u00119\u0018m\u001d9\u000b\u0005\u00152\u0013a\u00022jO\u0012\fG/\u0019\u0006\u0003O!\n\u0001\"Y4jY\u0016d\u0017M\u0019\u0006\u0002S\u0005\u0011\u0011\u000e^\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014a\u00027pO\u001eLgn\u001a\u0006\u0003o\t\nAaY8sK&\u0011\u0011\b\u000e\u0002\u000f\u000fV\f'\u000fZ3e\u0019><w-\u001b8h\u0003-A'-Y:f\u0007>tg-[4\u0011\u00075bd(\u0003\u0002>]\t1q\n\u001d;j_:\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0015\t\u0019%%\u0001\u0004n_\u0012,Gn]\u0005\u0003\u000b\u0002\u0013\u0001\u0003\u0013\"bg\u0016\u001cuN\u001c4jO6{G-\u001a7\u0002\rqJg.\u001b;?)\tA%\n\u0005\u0002J\u00015\tA\u0004C\u0003;\u0005\u0001\u00071(\u0001\u0004d_:4\u0017nZ\u000b\u0002\u001bB\u0011ajV\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0005G>tgM\u0003\u0002S'\u00061\u0001.\u00193p_BT!\u0001V+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gNZ5hA\u0005YqlY8o]\u0016\u001cG/[8o+\u0005a\u0006CA/c\u001b\u0005q&BA0a\u0003\u0019\u0019G.[3oi*\u0011\u0011-U\u0001\u0006Q\n\f7/Z\u0005\u0003Gz\u0013!bQ8o]\u0016\u001cG/[8o\u0003=y6m\u001c8oK\u000e$\u0018n\u001c8`I\u0015\fHC\u00014j!\tis-\u0003\u0002i]\t!QK\\5u\u0011\u001dQg!!AA\u0002q\u000b1\u0001\u001f\u00132\u00031y6m\u001c8oK\u000e$\u0018n\u001c8!\u0003\r)gN^\u000b\u0002]B!q\u000e\u001e<w\u001b\u0005\u0001(BA9s\u0003\u0011)H/\u001b7\u000b\u0003M\fAA[1wC&\u0011Q\u000f\u001d\u0002\u0004\u001b\u0006\u0004\bCA<\u007f\u001d\tAH\u0010\u0005\u0002z]5\t!P\u0003\u0002|U\u00051AH]8pizJ!! \u0018\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ut\u0013aC5t/N+g.\u00192mK\u0012,\"!a\u0002\u0011\u00075\nI!C\u0002\u0002\f9\u0012qAQ8pY\u0016\fg.\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\u0002]\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u000e\u0003+\u0011\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u00031\u0019\b/Z2jC2\u001c\u0005.\u0019:t+\u00051\u0018!D:qK\u000eL\u0017\r\\\"iCJ\u001c\b%\u0001\rjg\u000e{gN\\3di&|gNT;mY>\u00138\t\\8tK\u0012\fQbZ3u\u0007>tg.Z2uS>t\u0017!C<ji\"$\u0016M\u00197f+\u0011\tY#a\r\u0015\t\u00055\u0012Q\u000b\u000b\u0005\u0003_\t)\u0005\u0005\u0003\u00022\u0005MB\u0002\u0001\u0003\b\u0003ky!\u0019AA\u001c\u0005\u0005\t\u0015\u0003BA\u001d\u0003\u007f\u00012!LA\u001e\u0013\r\tiD\f\u0002\b\u001d>$\b.\u001b8h!\ri\u0013\u0011I\u0005\u0004\u0003\u0007r#aA!os\"9\u0011qI\bA\u0002\u0005%\u0013!\u00014\u0011\u000f5\nY%a\u0014\u00020%\u0019\u0011Q\n\u0018\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA/\u0002R%\u0019\u00111\u000b0\u0003\u000bQ\u000b'\r\\3\t\r\u0005]s\u00021\u0001w\u0003%!\u0018M\u00197f\u001d\u0006lW-A\u0006xSRDW*\u001e;bi>\u0014X\u0003BA/\u0003G\"B!a\u0018\u0002pQ!\u0011\u0011MA3!\u0011\t\t$a\u0019\u0005\u000f\u0005U\u0002C1\u0001\u00028!9\u0011q\t\tA\u0002\u0005\u001d\u0004cB\u0017\u0002L\u0005%\u0014\u0011\r\t\u0004;\u0006-\u0014bAA7=\ny!)\u001e4gKJ,G-T;uCR|'\u000f\u0003\u0004\u0002XA\u0001\rA^\u0001\no&$\b.\u00113nS:,B!!\u001e\u0002zQ!\u0011qOA>!\u0011\t\t$!\u001f\u0005\u000f\u0005U\u0012C1\u0001\u00028!9\u0011qI\tA\u0002\u0005u\u0004cB\u0017\u0002L\u0005}\u0014q\u000f\t\u0004;\u0006\u0005\u0015bAAB=\n)\u0011\tZ7j]\u0006y1\r\\8tK\u000e{gN\\3di&|g\u000eF\u0001g\u0003%y\u0016N\\5u\u0007>tg.A\noK^\u001cuN\u001c4XSRD\u0017)\u001e;i\u0017\u0016L8\u000fF\u0004N\u0003\u001f\u000b\t*!&\t\u000bA#\u0002\u0019A'\t\r\u0005ME\u00031\u0001w\u0003%\u0001(/\u001b8dSB\fG\u000e\u0003\u0004\u0002\u0018R\u0001\rA^\u0001\u000fW\u0016LH/\u00192M_\u000e\fG/[8o\u0003AYW-\u001f;bE\u001aKG.Z#ySN$8\u000f\u0006\u0003\u0002\b\u0005u\u0005BBA$+\u0001\u0007a/\u0001\bqe&tG\u000f\u0013\"bg\u0016\u001cuN\u001c4\u0015\t\u0005\r\u0016Q\u0016\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*\u0019\u0011\u0011\u0016:\u0002\t1\fgnZ\u0005\u0004\u007f\u0006\u001d\u0006\"\u0002)\u0017\u0001\u0004i\u0015\u0001\u0005;pW\u0016tGj\\4Sk:t\u0017M\u00197f+\t\t\u0019L\u0005\u0004\u00026\u0006e\u0016q\u0018\u0004\u0007\u0003o;\u0002!a-\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005\u0015\u00161X\u0005\u0005\u0003{\u000b9K\u0001\u0004PE*,7\r\u001e\t\u0005\u0003K\u000b\t-\u0003\u0003\u0002D\u0006\u001d&\u0001\u0003*v]:\f'\r\\3\u0002+\r,(O]3oiR{7.\u001a8t)>\u001cFO]5oOR\ta/\u0001\u0007qe&tGoQ8oM.+\u0017\u0010F\u0003w\u0003\u001b\fy\rC\u0003Q3\u0001\u0007Q\n\u0003\u0004\u0002Rf\u0001\rA^\u0001\u0004W\u0016L\u0018!\u0004;pW\u0016tGk\\*ue&tw\rF\u0002w\u0003/Dq!!7\u001b\u0001\u0004\tY.A\u0003u_.,g\u000e\u0005\u0003\u0002^\u0006\u0015XBAAp\u0015\u0011\tI.!9\u000b\u0007\u0005\r\u0018+\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t9/a8\u0003\u001fQ{7.\u001a8JI\u0016tG/\u001b4jKJ\u0004")
public class HBaseConnection
implements GuardedLogging {
    private Map<String, String> env;
    private boolean isWSenabled;
    private ScheduledExecutorService executor;
    private Runnable tokenLogRunnable;
    private final Configuration config;
    private Connection _connection;
    private final String specialChars;
    private transient WaspLogger log;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public String loggerName() {
        return GuardedLogging.loggerName$((GuardedLogging)this);
    }

    private WaspLogger log$lzycompute() {
        HBaseConnection hBaseConnection = this;
        synchronized (hBaseConnection) {
            if (!this.bitmap$trans$0) {
                this.log = GuardedLogging.log$((GuardedLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public WaspLogger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private Configuration config() {
        return this.config;
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Map<String, String> env$lzycompute() {
        HBaseConnection hBaseConnection = this;
        synchronized (hBaseConnection) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.env = System.getenv();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.env;
    }

    private Map<String, String> env() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.env$lzycompute() : this.env;
    }

    private boolean isWSenabled$lzycompute() {
        HBaseConnection hBaseConnection = this;
        synchronized (hBaseConnection) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isWSenabled = this.env().containsKey("WASP_SECURITY");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isWSenabled;
    }

    private boolean isWSenabled() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isWSenabled$lzycompute() : this.isWSenabled;
    }

    private ScheduledExecutorService executor$lzycompute() {
        HBaseConnection hBaseConnection = this;
        synchronized (hBaseConnection) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.executor = Executors.newSingleThreadScheduledExecutor();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.executor;
    }

    private ScheduledExecutorService executor() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.executor$lzycompute() : this.executor;
    }

    private String specialChars() {
        return this.specialChars;
    }

    public boolean isConnectionNullOrClosed() {
        return this._connection() == null || this._connection().isClosed();
    }

    private Connection getConnection() {
        block0: {
            if (!this.isConnectionNullOrClosed()) break block0;
            this._connection_$eq(this._initConn());
        }
        return this._connection();
    }

    public <A> A withTable(String tableName, Function1<Table, A> f) {
        Object object;
        try (Table table = this.getConnection().getTable(TableName.valueOf((String)tableName));){
            object = f.apply((Object)table);
        }
        catch (Exception e) {
            this.closeConnection();
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append(this.specialChars()).append(" ERROR some error in the HBASE CONNECTION ").append(this.specialChars()).toString(), (Throwable)e);
            throw e;
        }
        return (A)object;
    }

    public <A> A withMutator(String tableName, Function1<BufferedMutator, A> f) {
        Object object;
        try {
            BufferedMutator mutator = this.getConnection().getBufferedMutator(TableName.valueOf((String)tableName));
            try {
                object = f.apply((Object)mutator);
            }
            finally {
                mutator.flush();
                mutator.close();
            }
        }
        catch (Exception e) {
            this.closeConnection();
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append(this.specialChars()).append(" ERROR some error in the HBASE CONNECTION ").append(this.specialChars()).toString(), (Throwable)e);
            throw e;
        }
        return (A)object;
    }

    public <A> A withAdmin(Function1<Admin, A> f) {
        Object object;
        try (Admin admin = this.getConnection().getAdmin();){
            object = f.apply((Object)admin);
        }
        catch (Exception e) {
            this.closeConnection();
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append(this.specialChars()).append(" ERROR some error in the HBASE CONNECTION ").append(this.specialChars()).toString(), (Throwable)e);
            throw e;
        }
        return (A)object;
    }

    public synchronized void closeConnection() {
        try {
            if (this._connection() != null) {
                this._connection().close();
            }
        }
        finally {
            this._connection_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Connection _initConn() {
        void v1;
        try {
            void var1_3;
            Connection connection;
            this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(50).append("Creating HBase connection. WASP_SECURITY is").append((Object)(!this.isWSenabled() ? "not " : " ")).append("enabled").toString());
            if (this.isWSenabled()) {
                Option maybeToken = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(UserGroupInformation.getCurrentUser().getTokens()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HBaseConnection.$anonfun$_initConn$2(x$1)));
                User user = (User)maybeToken.map((Function1 & Serializable & scala.Serializable)token -> {
                    this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Found HBase token: ").append(this.tokenToString(token.decodeIdentifier())).toString());
                    return User.create((UserGroupInformation)UserGroupInformation.getCurrentUser());
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    String principal = System.getenv("PRINCIPAL_NAME");
                    String keytabLocation = System.getenv("KEYTAB_FILE_NAME");
                    this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Creating user in UGI with PRINCIPAL_NAME ").append(principal).append(", KEYTAB_FILE_NAME ").append(keytabLocation).toString());
                    if (!this.keytabFileExists(keytabLocation)) {
                        this.log().warn((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(53).append("Cannot check keytab file existence at ").append(keytabLocation).append("! Continuing...").toString());
                    }
                    Configuration confWithAuthKeys = this.newConfWithAuthKeys(this.config(), principal, keytabLocation);
                    UserGroupInformation.setConfiguration((Configuration)confWithAuthKeys);
                    UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytabLocation);
                    this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(13).append("Logged user: ").append(ugi).toString());
                    UserGroupInformation.setLoginUser((UserGroupInformation)ugi);
                    this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("Setting UGI login user to ").append(ugi).toString());
                    this.executor().scheduleAtFixedRate(new Runnable(this, ugi){
                        private final /* synthetic */ HBaseConnection $outer;
                        private final UserGroupInformation ugi$1;

                        public void run() {
                            try {
                                this.ugi$1.checkTGTAndReloginFromKeytab();
                            }
                            catch (IOException e) {
                                this.$outer.log().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(51).append("Got exception while trying to refresh credentials: ").append(e.getMessage()).toString(), (Throwable)e);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ugi$1 = ugi$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(java.io.IOException )}, serializedLambda);
                        }
                    }, 0L, 30L, TimeUnit.SECONDS);
                    return User.create((UserGroupInformation)ugi);
                });
                connection = ConnectionFactory.createConnection((Configuration)this.config(), (User)user);
            } else {
                connection = ConnectionFactory.createConnection((Configuration)this.config());
            }
            Connection result = connection;
            this.executor().scheduleAtFixedRate(this.tokenLogRunnable(), 0L, 10L, TimeUnit.MINUTES);
            this.log().info((Function0 & Serializable & scala.Serializable)() -> "HBase connection created.");
            v1 = var1_3;
        }
        catch (IOException e) {
            this.log().error((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Unable to connect to Hbase ").append(e.getMessage()).toString());
            throw new RuntimeException(e);
        }
        return v1;
    }

    private Configuration newConfWithAuthKeys(Configuration conf, String principal, String keytabLocation) {
        Configuration z = new Configuration(conf);
        z.set("hbase.client.keytab.file", keytabLocation);
        z.set("hbase.client.kerberos.principal", principal);
        return z;
    }

    private boolean keytabFileExists(String f) {
        File file = new File(f);
        return file.exists();
    }

    private String printHBaseConf(Configuration conf) {
        String string = "hbase.zookeeper.quorum";
        String string2 = "hbase.zookeeper.property.clientPort";
        String string3 = "hbase.master";
        String string4 = "hadoop.security.authentication";
        String string5 = "hbase.security.authentication";
        String string6 = "hbase.cluster.distributed";
        String string7 = "hbase.rpc.protection";
        String string8 = "hbase.master.kerberos.principal";
        String string9 = "hbase.regionserver.kerberos.principal";
        String string10 = "hbase.client.retries.number";
        return new java.lang.StringBuilder(24).append("HBase with properties:\n\t").append(((TraversableOnce)Nil$.MODULE$.$colon$colon((Object)string10).$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string).map((Function1 & Serializable & scala.Serializable)x$12 -> this.printConfKey(conf, (String)x$12), List$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
    }

    private Runnable tokenLogRunnable$lzycompute() {
        HBaseConnection hBaseConnection = this;
        synchronized (hBaseConnection) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.tokenLogRunnable = new Runnable(this){
                    private final /* synthetic */ HBaseConnection $outer;

                    public void run() {
                        this.$outer.log().debug((Function0 & Serializable & scala.Serializable)() -> $this.$outer.currentTokensToString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$2(it.agilelab.bigdata.wasp.consumers.spark.utils.HBaseConnection$$anon$2 )}, serializedLambda);
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.tokenLogRunnable;
    }

    private Runnable tokenLogRunnable() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.tokenLogRunnable$lzycompute() : this.tokenLogRunnable;
    }

    public String currentTokensToString() {
        return new java.lang.StringBuilder(17).append("Current tokens:\n\t").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(UserGroupInformation.getCurrentUser().getCredentials().getAllTokens()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> this.tokenToString(x.decodeIdentifier()), Iterable$.MODULE$.canBuildFrom())).mkString("\n\t")).toString();
    }

    public String printConfKey(Configuration conf, String key) {
        return new java.lang.StringBuilder(2).append(key).append(": ").append(conf.get(key, "")).toString();
    }

    public String tokenToString(TokenIdentifier token) {
        String string;
        TokenIdentifier tokenIdentifier = token;
        if (tokenIdentifier instanceof AbstractDelegationTokenIdentifier) {
            AbstractDelegationTokenIdentifier abstractDelegationTokenIdentifier = (AbstractDelegationTokenIdentifier)tokenIdentifier;
            string = abstractDelegationTokenIdentifier.toString();
        } else if (tokenIdentifier instanceof AuthenticationTokenIdentifier) {
            AuthenticationTokenIdentifier authenticationTokenIdentifier = (AuthenticationTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)authenticationTokenIdentifier.getKind()).append(", keyId=").append(authenticationTokenIdentifier.getKeyId()).append(", user=").append((Object)authenticationTokenIdentifier.getUser()).append(", issueDate=").append(authenticationTokenIdentifier.getIssueDate()).append(", expirationDate=").append(authenticationTokenIdentifier.getExpirationDate()).append(", sequenceNumber=").append(authenticationTokenIdentifier.getSequenceNumber()).append(", username=").append(authenticationTokenIdentifier.getUsername()).toString();
        } else if (tokenIdentifier instanceof AMRMTokenIdentifier) {
            AMRMTokenIdentifier aMRMTokenIdentifier = (AMRMTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)aMRMTokenIdentifier.getKind()).append(", keyId=").append(aMRMTokenIdentifier.getKeyId()).append(", user=").append((Object)aMRMTokenIdentifier.getUser()).toString();
        } else if (tokenIdentifier instanceof BlockTokenIdentifier) {
            BlockTokenIdentifier blockTokenIdentifier = (BlockTokenIdentifier)tokenIdentifier;
            string = blockTokenIdentifier.toString();
        } else if (tokenIdentifier instanceof ContainerTokenIdentifier) {
            ContainerTokenIdentifier containerTokenIdentifier = (ContainerTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)containerTokenIdentifier.getKind()).append(", keyId=").append(containerTokenIdentifier.getMasterKeyId()).append(", user=").append((Object)containerTokenIdentifier.getUser()).append(", applicationSubmitter=").append(containerTokenIdentifier.getApplicationSubmitter()).append(", expiryTimeStamp=").append(containerTokenIdentifier.getExpiryTimeStamp()).append(", containerID=").append((Object)containerTokenIdentifier.getContainerID()).append(", creationTime=").append(containerTokenIdentifier.getCreationTime()).toString();
        } else if (tokenIdentifier instanceof ClientToAMTokenIdentifier) {
            ClientToAMTokenIdentifier clientToAMTokenIdentifier = (ClientToAMTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)clientToAMTokenIdentifier.getKind()).append(", user=").append((Object)clientToAMTokenIdentifier.getUser()).append(", clientName=").append(clientToAMTokenIdentifier.getClientName()).toString();
        } else if (tokenIdentifier instanceof JobTokenIdentifier) {
            JobTokenIdentifier jobTokenIdentifier = (JobTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)jobTokenIdentifier.getKind()).append(", jobId=").append((Object)jobTokenIdentifier.getJobId()).append(", user=").append((Object)jobTokenIdentifier.getUser()).toString();
        } else if (tokenIdentifier instanceof NMTokenIdentifier) {
            NMTokenIdentifier nMTokenIdentifier = (NMTokenIdentifier)tokenIdentifier;
            string = new StringBuilder().append((Object)nMTokenIdentifier.getKind()).append(", keyId=").append(nMTokenIdentifier.getKeyId()).append(", user=").append((Object)nMTokenIdentifier.getUser()).append(", applicationSubmitter=").append(nMTokenIdentifier.getApplicationSubmitter()).toString();
        } else {
            throw new MatchError((Object)tokenIdentifier);
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$config$1(HBaseConnection $this, Configuration conf$1, HBaseEntryConfig opt) {
        $this.log().info((Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(42).append("HBase additional custom option added: ").append(opt.key()).append(" -> ").append(opt.value()).toString());
        conf$1.set(opt.key(), opt.value());
    }

    public static final /* synthetic */ boolean $anonfun$_initConn$2(Token x$1) {
        return x$1.decodeIdentifier() instanceof AuthenticationTokenIdentifier;
    }

    /*
     * WARNING - void declaration
     */
    public HBaseConnection(Option<HBaseConfigModel> hbaseConfig) {
        void var2_2;
        GuardedLogging.$init$((GuardedLogging)this);
        Configuration conf = HBaseConfiguration.create();
        Option<HBaseConfigModel> document = hbaseConfig;
        if (document.isDefined()) {
            HBaseConfigModel hbaseConf = (HBaseConfigModel)document.get();
            String coreSiteXml = hbaseConf.coreSiteXmlPath();
            String hbaseSiteXml = hbaseConf.hbaseSiteXmlPath();
            Seq otherOpts = hbaseConf.others();
            conf.addResource(new Path(coreSiteXml));
            conf.addResource(new Path(hbaseSiteXml));
            otherOpts.foreach((Function1 & Serializable & scala.Serializable)opt -> {
                HBaseConnection.$anonfun$config$1(this, conf, opt);
                return BoxedUnit.UNIT;
            });
            this.log().info((Function0 & Serializable & scala.Serializable)() -> "HBaseConnection instance with explicit config");
        } else {
            this.log().warn((Function0 & Serializable & scala.Serializable)() -> "No hbase config retrieved. HBaseConnection will be initialized with default config");
        }
        this.log().info((Function0 & Serializable & scala.Serializable)() -> this.printHBaseConf(conf));
        this.config = var2_2;
        this.specialChars = "+++++-----";
    }
}

