/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.KeyWithCorrelation;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.config.HdfsDeletionConfig;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.exception.ConfigExceptions;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.exception.ConfigExceptions$RawDataConfigException$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.ConfigUtils$;
import it.agilelab.bigdata.wasp.models.ContainsRawMatchingStrategy;
import it.agilelab.bigdata.wasp.models.ExactRawMatchingStrategy;
import it.agilelab.bigdata.wasp.models.NoPartitionPruningStrategy;
import it.agilelab.bigdata.wasp.models.PartitionPruningStrategy;
import it.agilelab.bigdata.wasp.models.PrefixRawMatchingStrategy;
import it.agilelab.bigdata.wasp.models.RawDataStoreConf;
import it.agilelab.bigdata.wasp.models.RawMatchingStrategy;
import it.agilelab.bigdata.wasp.models.RawModel;
import it.agilelab.bigdata.wasp.models.TimeBasedBetweenPartitionPruningStrategy;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class HdfsDeletionConfig$
implements scala.Serializable {
    public static HdfsDeletionConfig$ MODULE$;
    private final String RAW_CONF_KEY;
    private final String DEFAULT_STAGING;
    private final String STAGING_DIR_KEY;
    private final String BACKUP_DIR_KEY;
    private final String KEYS_TO_DELETE_KEY;
    private final String CORRELATION_ID_KEY;
    private final String START_PERIOD_KEY;
    private final String END_PERIOD_KEY;
    private final String TIMEZONE_PERIOD_KEY;
    private final Column ALWAYS_TRUE_COLUMN;
    private final String dryRun;

    static {
        new HdfsDeletionConfig$();
    }

    public boolean $lessinit$greater$default$8() {
        return false;
    }

    public String RAW_CONF_KEY() {
        return this.RAW_CONF_KEY;
    }

    public String DEFAULT_STAGING() {
        return this.DEFAULT_STAGING;
    }

    public String STAGING_DIR_KEY() {
        return this.STAGING_DIR_KEY;
    }

    public String BACKUP_DIR_KEY() {
        return this.BACKUP_DIR_KEY;
    }

    public String KEYS_TO_DELETE_KEY() {
        return this.KEYS_TO_DELETE_KEY;
    }

    public String CORRELATION_ID_KEY() {
        return this.CORRELATION_ID_KEY;
    }

    public String START_PERIOD_KEY() {
        return this.START_PERIOD_KEY;
    }

    public String END_PERIOD_KEY() {
        return this.END_PERIOD_KEY;
    }

    public String TIMEZONE_PERIOD_KEY() {
        return this.TIMEZONE_PERIOD_KEY;
    }

    public Column ALWAYS_TRUE_COLUMN() {
        return this.ALWAYS_TRUE_COLUMN;
    }

    public String dryRun() {
        return this.dryRun;
    }

    public HdfsDeletionConfig create(Config rootConfig, RawDataStoreConf rawDataStoreConf, Function0<Seq<KeyWithCorrelation>> inputKeys) {
        Option<Config> maybeConfig = ConfigUtils$.MODULE$.getOptionalConfig(rootConfig, this.RAW_CONF_KEY());
        Seq keysToDelete = (Seq)ConfigUtils$.MODULE$.keysToDelete(inputKeys, maybeConfig, this.KEYS_TO_DELETE_KEY(), this.CORRELATION_ID_KEY()).distinct();
        return new HdfsDeletionConfig((Seq<KeyWithCorrelation>)keysToDelete, rawDataStoreConf.rawModel(), rawDataStoreConf.rawMatchingStrategy(), this.rawMatchingCondition((Seq<String>)((Seq)keysToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.key(), Seq$.MODULE$.canBuildFrom())), rawDataStoreConf.rawMatchingStrategy()), this.partitionPruningCondition(maybeConfig, rawDataStoreConf.partitionPruningStrategy()), this.stagingDirUri(maybeConfig, rawDataStoreConf.rawModel()), this.backupDirUri(maybeConfig, rawDataStoreConf.rawModel()), rawDataStoreConf.missingPathFailure(), BoxesRunTime.unboxToBoolean((Object)maybeConfig.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> ConfigUtils$.MODULE$.getOptionalBoolean((Config)x$2, MODULE$.dryRun())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
    }

    private Column rawMatchingCondition(Seq<String> keysToDelete, RawMatchingStrategy rawMatchingStrategy) {
        Column column;
        RawMatchingStrategy rawMatchingStrategy2 = rawMatchingStrategy;
        if (rawMatchingStrategy2 instanceof ExactRawMatchingStrategy) {
            ExactRawMatchingStrategy exactRawMatchingStrategy = (ExactRawMatchingStrategy)rawMatchingStrategy2;
            String dataframeKeyMatchingExpression = exactRawMatchingStrategy.dataframeKeyMatchingExpression();
            column = functions$.MODULE$.expr(dataframeKeyMatchingExpression).isin(keysToDelete);
        } else if (rawMatchingStrategy2 instanceof PrefixRawMatchingStrategy) {
            PrefixRawMatchingStrategy prefixRawMatchingStrategy = (PrefixRawMatchingStrategy)rawMatchingStrategy2;
            String dataframeKeyMatchingExpression = prefixRawMatchingStrategy.dataframeKeyMatchingExpression();
            String regex = keysToDelete.mkString("^", "|^", "");
            column = functions$.MODULE$.expr(dataframeKeyMatchingExpression).rlike(regex);
        } else if (rawMatchingStrategy2 instanceof ContainsRawMatchingStrategy) {
            ContainsRawMatchingStrategy containsRawMatchingStrategy = (ContainsRawMatchingStrategy)rawMatchingStrategy2;
            String dataframeKeyMatchingExpression = containsRawMatchingStrategy.dataframeKeyMatchingExpression();
            Column expression = functions$.MODULE$.expr(dataframeKeyMatchingExpression);
            column = (Column)keysToDelete.foldLeft((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Column acc = (Column)tuple2._1();
                String key = (String)tuple2._2();
                Column column = acc.or(expression.contains((Object)key));
                return column;
            });
        } else {
            throw new MatchError((Object)rawMatchingStrategy2);
        }
        return column;
    }

    private Column partitionPruningCondition(Option<Config> maybeConfig, PartitionPruningStrategy partitionPruningStrategy) {
        Column column;
        PartitionPruningStrategy partitionPruningStrategy2 = partitionPruningStrategy;
        if (partitionPruningStrategy2 instanceof TimeBasedBetweenPartitionPruningStrategy) {
            String string;
            Config x;
            TimeBasedBetweenPartitionPruningStrategy timeBasedBetweenPartitionPruningStrategy = (TimeBasedBetweenPartitionPruningStrategy)partitionPruningStrategy2;
            Option<Config> option = maybeConfig;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ConfigExceptions.RawDataConfigException((ConfigException)((Object)new ConfigException.Missing(this.RAW_CONF_KEY())), ConfigExceptions$RawDataConfigException$.MODULE$.apply$default$2());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            Config config = x = (Config)some.value();
            Config config2 = config;
            try {
                string = config2.getString(this.TIMEZONE_PERIOD_KEY());
            }
            catch (ConfigException.Missing missing) {
                string = "UTC";
            }
            String timeZone = string;
            column = timeBasedBetweenPartitionPruningStrategy.condition(BoxesRunTime.unboxToLong(this.wrapConfigException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> config2.getLong(MODULE$.START_PERIOD_KEY()))), BoxesRunTime.unboxToLong(this.wrapConfigException((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> config2.getLong(MODULE$.END_PERIOD_KEY()))), timeZone);
        } else if (partitionPruningStrategy2 instanceof NoPartitionPruningStrategy) {
            column = this.ALWAYS_TRUE_COLUMN();
        } else {
            throw new MatchError((Object)partitionPruningStrategy2);
        }
        return column;
    }

    private String stagingDirUri(Option<Config> maybeConfig, RawModel rawModel) {
        return (String)maybeConfig.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ConfigUtils$.MODULE$.getOptionalString((Config)x$3, MODULE$.STAGING_DIR_KEY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createDefaultStagingDirUri(rawModel));
    }

    private String backupDirUri(Option<Config> maybeConfig, RawModel rawModel) {
        return (String)maybeConfig.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> ConfigUtils$.MODULE$.getOptionalString((Config)x$4, MODULE$.BACKUP_DIR_KEY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.createDefaultBackupDirUri(rawModel));
    }

    private String createDefaultStagingDirUri(RawModel rawModel) {
        return new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(rawModel.uri())).stripSuffix("/")).append(this.DEFAULT_STAGING()).toString();
    }

    private String createDefaultBackupDirUri(RawModel rawModel) {
        return new Path(rawModel.uri()).getParent().toUri().toString();
    }

    private <T> T wrapConfigException(Function0<T> value) {
        Object object;
        try {
            object = value.apply();
        }
        catch (ConfigException e) {
            throw new ConfigExceptions.RawDataConfigException(e, ConfigExceptions$RawDataConfigException$.MODULE$.apply$default$2());
        }
        return (T)object;
    }

    public HdfsDeletionConfig apply(Seq<KeyWithCorrelation> keysToDeleteWithCorrelation, RawModel rawModel, RawMatchingStrategy rawMatchingStrategy, Column rawMatchingCondition, Column partitionPruningCondition, String stagingDirUri, String backupDirUri, boolean missingPathFailure, boolean dryRun) {
        return new HdfsDeletionConfig(keysToDeleteWithCorrelation, rawModel, rawMatchingStrategy, rawMatchingCondition, partitionPruningCondition, stagingDirUri, backupDirUri, missingPathFailure, dryRun);
    }

    public boolean apply$default$8() {
        return false;
    }

    public Option<Tuple9<Seq<KeyWithCorrelation>, RawModel, RawMatchingStrategy, Column, Column, String, String, Object, Object>> unapply(HdfsDeletionConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple9(x$0.keysToDeleteWithCorrelation(), (Object)x$0.rawModel(), (Object)x$0.rawMatchingStrategy(), (Object)x$0.rawMatchingCondition(), (Object)x$0.partitionPruningCondition(), (Object)x$0.stagingDirUri(), (Object)x$0.backupDirUri(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.missingPathFailure()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dryRun())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HdfsDeletionConfig$() {
        MODULE$ = this;
        this.RAW_CONF_KEY = "hdfs";
        this.DEFAULT_STAGING = "/staging";
        this.STAGING_DIR_KEY = "stagingDir";
        this.BACKUP_DIR_KEY = "backupDir";
        this.KEYS_TO_DELETE_KEY = "keys";
        this.CORRELATION_ID_KEY = "correlationId";
        this.START_PERIOD_KEY = "start";
        this.END_PERIOD_KEY = "end";
        this.TIMEZONE_PERIOD_KEY = "timeZone";
        this.ALWAYS_TRUE_COLUMN = functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)).$eq$eq$eq((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        this.dryRun = "dryRun";
    }
}

