/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.streaming.actor.telemetry;

import it.agilelab.bigdata.wasp.core.SystemPipegraphs$;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import it.agilelab.bigdata.wasp.core.utils.ConfigManager$;
import it.agilelab.bigdata.wasp.models.configuration.KafkaConfigModel;
import it.agilelab.bigdata.wasp.models.configuration.KafkaEntryConfig;
import it.agilelab.bigdata.wasp.models.configuration.TelemetryConfigModel;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.runtime.BoxesRunTime;

public final class TelemetryActorKafkaProducer$
implements Logging {
    public static TelemetryActorKafkaProducer$ MODULE$;
    private KafkaProducer<byte[], byte[]> producer;
    private final WaspLogger logger;
    private volatile boolean bitmap$0;

    static {
        new TelemetryActorKafkaProducer$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer$lzycompute() {
        TelemetryActorKafkaProducer$ telemetryActorKafkaProducer$ = this;
        synchronized (telemetryActorKafkaProducer$) {
            if (!this.bitmap$0) {
                KafkaConfigModel kafkaConfig = ConfigManager$.MODULE$.getKafkaConfig().getDefaultKafka();
                TelemetryConfigModel telemetryConfig = ConfigManager$.MODULE$.getTelemetryConfig();
                String connectionString = ((TraversableOnce)kafkaConfig.connections().map((Function1 & Serializable & scala.Serializable)conn -> new StringBuilder(1).append(conn.host()).append(":").append(conn.port()).toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
                Properties props = new Properties();
                props.put("bootstrap.servers", connectionString);
                props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                Set notOverridableKeys = (Set)JavaConverters$.MODULE$.asScalaSetConverter(props.keySet()).asScala();
                Seq merged = (Seq)kafkaConfig.others().$plus$plus((GenTraversableOnce)telemetryConfig.telemetryTopicConfigModel().kafkaSettings(), Seq$.MODULE$.canBuildFrom());
                Seq resultingConf = (Seq)merged.filterNot((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)notOverridableKeys.contains((Object)x.key())));
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Telemetry configuration\n").append(resultingConf.mkString("\n")).toString());
                resultingConf.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    KafkaEntryConfig kafkaEntryConfig = x0$1;
                    if (kafkaEntryConfig == null) {
                        throw new MatchError((Object)kafkaEntryConfig);
                    }
                    String key = kafkaEntryConfig.key();
                    String value = kafkaEntryConfig.value();
                    Object object = props.put(key, value);
                    return object;
                });
                this.producer = new KafkaProducer(props);
                this.bitmap$0 = true;
            }
        }
        return this.producer;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return !this.bitmap$0 ? this.producer$lzycompute() : this.producer;
    }

    public void send(String key, String message) {
        String topic = SystemPipegraphs$.MODULE$.telemetryTopic().name();
        ProducerRecord record = new ProducerRecord(topic, (Object)key.getBytes(StandardCharsets.UTF_8), (Object)message.getBytes(StandardCharsets.UTF_8));
        this.producer().send(record);
    }

    private TelemetryActorKafkaProducer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

