/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.hdfs;

import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.GdprUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.strategies.gdpr.utils.hdfs.HdfsUtils$;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0003\u0006\u0001;!AA\u0005\u0001B\u0001B\u0003%Q\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!!\u0004A!A!\u0002\u0013\t\u0004\"B\u001b\u0001\t\u00031\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B/\u0001\t\u0013q&!\u0005%eMN\u0014\u0015mY6va\"\u000bg\u000e\u001a7fe*\u00111\u0002D\u0001\u0005Q\u001247O\u0003\u0002\u000e\u001d\u0005!q\r\u001a9s\u0015\ty\u0001#\u0001\u0006tiJ\fG/Z4jKNT!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012!C2p]N,X.\u001a:t\u0015\t)b#\u0001\u0003xCN\u0004(BA\f\u0019\u0003\u001d\u0011\u0017n\u001a3bi\u0006T!!\u0007\u000e\u0002\u0011\u0005<\u0017\u000e\\3mC\nT\u0011aG\u0001\u0003SR\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\f!AZ:\u0011\u0005\u0019rS\"A\u0014\u000b\u0005\u0011B#BA\u0015+\u0003\u0019A\u0017\rZ8pa*\u00111\u0006L\u0001\u0007CB\f7\r[3\u000b\u00035\n1a\u001c:h\u0013\tysE\u0001\u0006GS2,7+_:uK6\f1CY1dWV\u0004\b+\u0019:f]R$\u0015N\u001d)bi\"\u0004\"A\n\u001a\n\u0005M:#\u0001\u0002)bi\"\f\u0001\u0002Z1uCB\u000bG\u000f[\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]J$h\u000f\t\u0003q\u0001i\u0011A\u0003\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006i\u0011\u0001\r!M\u0001\u0007E\u0006\u001c7.\u001e9\u0015\u0005y\"\u0005cA Cc5\t\u0001I\u0003\u0002BA\u0005!Q\u000f^5m\u0013\t\u0019\u0005IA\u0002UefDQ!R\u0003A\u0002\u0019\u000bQBZ5mKN$vNQ1dWV\u0004\bcA$Pc9\u0011\u0001*\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017r\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u00059\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003!F\u00131aU3r\u0015\tq\u0005%A\u0007sKN$xN]3CC\u000e\\W\u000f\u001d\u000b\u0003)b\u00032a\u0010\"V!\tyb+\u0003\u0002XA\t!QK\\5u\u0011\u0015If\u00011\u00012\u0003)\u0011\u0017mY6vaB\u000bG\u000f[\u0001\rI\u0016dW\r^3CC\u000e\\W\u000f\u001d\u000b\u0003)rCQ!W\u0004A\u0002E\n1C]3oC6,\u0017I\u001c3BG\u000e,X.\u001e7bi\u0016$\"a\u00186\u0015\u0007\u0001\u001cW\r\u0005\u0002 C&\u0011!\r\t\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0007\u00021\u0001a\u0003\r\t7m\u0019\u0005\u0006M\"\u0001\raZ\u0001\u0005M&dW\r\u0005\u0002'Q&\u0011\u0011n\n\u0002\u0012\u0019>\u001c\u0017\r^3e\r&dWm\u0015;biV\u001c\b\"B-\t\u0001\u0004\t\u0004")
public class HdfsBackupHandler {
    private final FileSystem fs;
    private final Path backupParentDirPath;
    private final Path dataPath;

    public Try<Path> backup(Seq<Path> filesToBackup) {
        return HdfsUtils$.MODULE$.backupFiles(this.fs, filesToBackup, this.backupParentDirPath, this.dataPath);
    }

    public Try<BoxedUnit> restoreBackup(Path backupPath) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> $this.fs.listFiles(backupPath, true)).flatMap((Function1 & java.io.Serializable & Serializable)iterator -> HdfsUtils$.MODULE$.foldIterator(iterator, new Success((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Function2 & java.io.Serializable & Serializable)(acc, file) -> BoxesRunTime.boxToBoolean((boolean)this.renameAndAccumulate(backupPath, BoxesRunTime.unboxToBoolean((Object)acc), file)), (Function1 & java.io.Serializable & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)HdfsBackupHandler.$anonfun$restoreBackup$4(BoxesRunTime.unboxToBoolean((Object)b)))).flatMap((Function1 & java.io.Serializable & Serializable)renameResult -> HdfsBackupHandler.$anonfun$restoreBackup$5(BoxesRunTime.unboxToBoolean((Object)renameResult))));
    }

    public Try<BoxedUnit> deleteBackup(Path backupPath) {
        return HdfsUtils$.MODULE$.deletePath(this.fs, backupPath);
    }

    private boolean renameAndAccumulate(Path backupPath, boolean acc, LocatedFileStatus file) {
        if (!file.isDirectory()) {
            Path newPath = HdfsUtils$.MODULE$.replacePathPrefix(file.getPath(), backupPath, this.dataPath);
            return this.fs.rename(file.getPath(), newPath) && acc;
        }
        return acc;
    }

    public static final /* synthetic */ boolean $anonfun$restoreBackup$4(boolean b) {
        return !b;
    }

    public static final /* synthetic */ void $anonfun$restoreBackup$6(BoxedUnit _) {
    }

    public static final /* synthetic */ Try $anonfun$restoreBackup$5(boolean renameResult) {
        return GdprUtils$.MODULE$.recoverFsOperation(renameResult, "Error while moving files from backup dir to data dir").map((Function1 & java.io.Serializable & Serializable)_ -> {
            HdfsBackupHandler.$anonfun$restoreBackup$6(_);
            return BoxedUnit.UNIT;
        });
    }

    public HdfsBackupHandler(FileSystem fs, Path backupParentDirPath, Path dataPath) {
        this.fs = fs;
        this.backupParentDirPath = backupParentDirPath;
        this.dataPath = dataPath;
    }
}

