/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import io.delta.tables.DeltaTable;
import io.delta.tables.execution.DeltaConvert$;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;

public final class DeltaTable$ {
    public static DeltaTable$ MODULE$;

    static {
        new DeltaTable$();
    }

    @InterfaceStability.Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier, StructType partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)partitionSchema), (Option<String>)None$.MODULE$);
    }

    @InterfaceStability.Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier, String partitionSchema) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema)), (Option<String>)None$.MODULE$);
    }

    @InterfaceStability.Evolving
    public DeltaTable convertToDelta(SparkSession spark, String identifier) {
        TableIdentifier tableId = spark.sessionState().sqlParser().parseTableIdentifier(identifier);
        return DeltaConvert$.MODULE$.executeConvert(spark, tableId, (Option<StructType>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    @InterfaceStability.Evolving
    public DeltaTable forPath(String path) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Could not find active SparkSession");
        });
        return this.forPath(sparkSession, path);
    }

    @InterfaceStability.Evolving
    public DeltaTable forPath(SparkSession sparkSession, String path) {
        if (!DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, new Path(path))) {
            throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier((Option<String>)new Some((Object)path), DeltaTableIdentifier$.MODULE$.apply$default$2()));
        }
        return new DeltaTable((Dataset<Row>)sparkSession.read().format("delta").load(path), DeltaLog$.MODULE$.forTable(sparkSession, path));
    }

    @InterfaceStability.Evolving
    public boolean isDeltaTable(SparkSession sparkSession, String identifier) {
        return DeltaTableUtils$.MODULE$.isDeltaTable(sparkSession, new Path(identifier));
    }

    @InterfaceStability.Evolving
    public boolean isDeltaTable(String identifier) {
        SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Could not find active SparkSession");
        });
        return this.isDeltaTable(sparkSession, identifier);
    }

    private DeltaTable$() {
        MODULE$ = this;
    }
}

