/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Checkpoints$ {
    public static Checkpoints$ MODULE$;

    static {
        new Checkpoints$();
    }

    public CheckpointMetaData writeCheckpoint(SparkSession spark, DeltaLog deltaLog, Snapshot snapshot) {
        LongAccumulator numOfFiles;
        LongAccumulator checkpointSize;
        block8: {
            ParquetFileFormat format = new ParquetFileFormat();
            Job job = Job.getInstance();
            Tuple2 tuple2 = new Tuple2((Object)format.prepareWrite(spark, job, Predef$.MODULE$.Map().empty(), Action$.MODULE$.logSchema()), (Object)new SerializableConfiguration(job.getConfiguration()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputWriterFactory factory = (OutputWriterFactory)tuple2._1();
            SerializableConfiguration serConf = (SerializableConfiguration)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)factory, (Object)serConf);
            Tuple2 tuple23 = tuple22;
            OutputWriterFactory factory2 = (OutputWriterFactory)tuple23._1();
            SerializableConfiguration serConf2 = (SerializableConfiguration)tuple23._2();
            boolean useRename = deltaLog.store().isPartialWriteVisible(deltaLog.logPath());
            checkpointSize = spark.sparkContext().longAccumulator("checkpointSize");
            numOfFiles = spark.sparkContext().longAccumulator("numOfFiles");
            String path = FileNames$.MODULE$.checkpointFileSingular(snapshot.path(), snapshot.version()).toString();
            RDD qual$1 = snapshot.state().repartition(1).map((Function1 & Serializable & scala.Serializable)action -> {
                block0: {
                    if (action.add() == null) break block0;
                    numOfFiles.add(1L);
                }
                return action;
            }, SingleAction$.MODULE$.encoder()).queryExecution().executedPlan().execute();
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> {
                String string;
                if (useRename) {
                    Path p = new Path(path);
                    Path tempPath = new Path(p.getParent(), new StringBuilder(6).append(".").append(p.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
                    DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(serConf2.value(), tempPath);
                    string = tempPath.toString();
                } else {
                    string = path;
                }
                String writtenPath = string;
                try {
                    OutputWriter writer = factory2.newInstance(writtenPath, Action$.MODULE$.logSchema(), (TaskAttemptContext)new TaskAttemptContextImpl(new JobConf(serConf2.value()), new TaskAttemptID("", 0, TaskType.REDUCE, 0, 0)));
                    iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                        Checkpoints$.$anonfun$writeCheckpoint$3(checkpointSize, writer, row);
                        return BoxedUnit.UNIT;
                    });
                    writer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileAlreadyExistsException) {
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (!useRename) {
                            Path p = new Path(writtenPath);
                            if (!p.getFileSystem(serConf2.value()).exists(p)) {
                                throw fileAlreadyExistsException;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{writtenPath}));
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            String writtenPath = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(String.class)).collect())).head();
            if (useRename) {
                Path src = new Path(writtenPath);
                Path dest = new Path(path);
                FileSystem fs = dest.getFileSystem(spark.sessionState().newHadoopConf());
                boolean renameDone = false;
                try {
                    if (fs.rename(src, dest)) {
                        renameDone = true;
                        break block8;
                    }
                    throw new IllegalStateException(new StringBuilder(18).append("Cannot rename ").append(src).append(" to ").append(dest).toString());
                }
                finally {
                    if (!renameDone) {
                        fs.delete(src, false);
                    }
                }
            }
        }
        if (!BoxesRunTime.equalsNumObject((Number)numOfFiles.value(), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles()))) {
            throw new IllegalStateException("State of the checkpoint doesn't match that of the snapshot.");
        }
        return new CheckpointMetaData(snapshot.version(), Predef$.MODULE$.Long2long(checkpointSize.value()), (Option<Object>)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$writeCheckpoint$3(LongAccumulator checkpointSize$1, OutputWriter writer$1, InternalRow row) {
        checkpointSize$1.add(1L);
        writer$1.write(row);
    }

    private Checkpoints$() {
        MODULE$ = this;
    }
}

