/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rMd\u0001\u0002&L\u0001YC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\")A\u000e\u0001C\u0001[\")\u0001\u000b\u0001C\u0005c\")a\u000f\u0001C\u0005o\")a\u0010\u0001C\u0001\u007f\"1a\u0010\u0001C\u0001\u0003_Aq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0005\u0004Z\u0001\t\n\u0011\"\u0001\u0004\\!91q\f\u0001\u0005\u0002\r\u0005\u0004bBB3\u0001\u0011%1q\r\u0005\b\u0007_\u0002A\u0011BAQ\u0011\u001d\u0019\t\b\u0001C\u0005\u0003C;q!!\u0013L\u0011\u0003\tYE\u0002\u0004K\u0017\"\u0005\u0011Q\n\u0005\u0007Y>!\t!a\u0014\t\u000f\u0005Es\u0002\"\u0003\u0002T!A\u0011QP\b\u0005\u0002-\u000by\b\u0003\u0006\u00036=\t\n\u0011\"\u0001L\u0005oAqAa\u000f\u0010\t\u0013\u0011i\u0004C\u0004\u0003X=!IA!\u0017\t\u000f\tut\u0002\"\u0003\u0003\u0000\u00191\u00111R\bA\u0003\u001bC!\"a\u001f\u0018\u0005+\u0007I\u0011AAQ\u0011)\t\u0019k\u0006B\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003K;\"Q3A\u0005\u0002\u0005\u0005\u0006BCAT/\tE\t\u0015!\u0003\u00026!1An\u0006C\u0001\u0003SCq!a,\u0018\t\u0003\n\t\fC\u0004\u00026^!\t%!)\t\u000f\u0005]v\u0003\"\u0011\u0002\"\"I\u0011\u0011X\f\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0003<\u0012\u0013!C\u0001\u0003\u0007D\u0011\"!7\u0018#\u0003%\t!a1\t\u0013\u0005mw#!A\u0005B\u0005u\u0007\"CAx/\u0005\u0005I\u0011AAy\u0011%\t\u0019pFA\u0001\n\u0003\t)\u0010C\u0005\u0003\u0002]\t\t\u0011\"\u0011\u0003\u0004!I!\u0011C\f\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u0005;9\u0012\u0011!C!\u0005?A\u0011B!\t\u0018\u0003\u0003%\tEa\t\t\u0013\t\u0015r#!A\u0005B\t\u001dr!\u0003BE\u001f\u0005\u0005\t\u0012\u0001BF\r%\tYiDA\u0001\u0012\u0003\u0011i\t\u0003\u0004mY\u0011\u0005!1\u0014\u0005\n\u0005Ca\u0013\u0011!C#\u0005GA\u0011B!(-\u0003\u0003%\tIa(\t\u0013\t\u0015F&!A\u0005\u0002\n\u001d\u0006\"\u0003B[Y\u0005\u0005I\u0011\u0002B\\\r\u0019\u0011yl\u0004\u0001\u0003B\"Q!Q\u001a\u001a\u0003\u0002\u0003\u0006IAa1\t\u0015\t='G!A!\u0002\u0013\t)\u0004\u0003\u0006\u0003RJ\u0012\t\u0011)A\u0005\u0003kA!Ba53\u0005\u0003\u0005\u000b\u0011\u0002Bk\u0011\u0019a'\u0007\"\u0001\u0003\\\"I!q\u001d\u001aC\u0002\u0013%!\u0011\u001e\u0005\t\u0005o\u0014\u0004\u0015!\u0003\u0003l\"I!\u0011 \u001aC\u0002\u0013%!1 \u0005\t\u0007\u0007\u0011\u0004\u0015!\u0003\u0003~\"Y1Q\u0001\u001aA\u0002\u0003\u0007I\u0011BB\u0004\u0011-\u0019IA\ra\u0001\u0002\u0004%Iaa\u0003\t\u0017\rU!\u00071A\u0001B\u0003&!q\u0019\u0005\n\u0007/\u0011\u0004\u0019!C\u0005\u00073A\u0011ba\u00073\u0001\u0004%Ia!\b\t\u0011\r\u0005\"\u0007)Q\u0005\u0005+Aqaa\t3\t\u0013\u0019)\u0003C\u0004\u0004(I\"Ia!\u000b\t\u000f\r=\"\u0007\"\u0003\u00042!91Q\u0007\u001a\u0005\n\r\u0015\u0002bBB\u001ce\u0011%1Q\u0005\u0005\b\u0007s\u0011D\u0011IB\r\u0011\u001d\u0019YD\rC!\u0007{A\u0011ba\u0010\u0010#\u0003%\ta!\u0011\u0003'\u0011+G\u000e^1ISN$xN]=NC:\fw-\u001a:\u000b\u00051k\u0015!\u00023fYR\f'B\u0001(P\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003!F\u000bQa\u001d9be.T!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO\u000e\u00011c\u0001\u0001X;B\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n1\u0011I\\=SK\u001a\u0004\"AX1\u000e\u0003}S!\u0001Y&\u0002\u00115,G/\u001a:j]\u001eL!AY0\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004\"!\u001a4\u000e\u0003-K!aZ&\u0003\u0011\u0011+G\u000e^1M_\u001e\fa\"\\1y\u0017\u0016L8\u000fU3s\u0019&\u001cH\u000f\u0005\u0002YU&\u00111.\u0017\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002o_B\u0004\"!\u001a\u0001\t\u000b\r\u001c\u0001\u0019\u00013\t\u000f!\u001c\u0001\u0013!a\u0001SV\t!\u000f\u0005\u0002ti6\tQ*\u0003\u0002v\u001b\na1\u000b]1sWN+7o]5p]\u0006Ir-\u001a;TKJL\u0017\r\\5{C\ndW\rS1e_>\u00048i\u001c8g+\u0005A\bCA=}\u001b\u0005Q(BA>P\u0003\u0011)H/\u001b7\n\u0005uT(!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\f!bZ3u\u0011&\u001cHo\u001c:z)\u0011\t\t!!\n\u0011\r\u0005\r\u00111CA\r\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003V\u0003\u0019a$o\\8u}%\t!,C\u0002\u0002\u0012e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011C-\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bL\u0003\u001d\t7\r^5p]NLA!a\t\u0002\u001e\tQ1i\\7nSRLeNZ8\t\u000f\u0005\u001db\u00011\u0001\u0002*\u0005AA.[7ji>\u0003H\u000f\u0005\u0003Y\u0003WI\u0017bAA\u00173\n1q\n\u001d;j_:$b!!\u0001\u00022\u0005m\u0002bBA\u001a\u000f\u0001\u0007\u0011QG\u0001\u0006gR\f'\u000f\u001e\t\u00041\u0006]\u0012bAA\u001d3\n!Aj\u001c8h\u0011\u001d\tid\u0002a\u0001\u0003\u007f\t1!\u001a8e!\u0015A\u00161FA\u001b\u0003U9W\r^!di&4XmQ8n[&$\u0018\t\u001e+j[\u0016$\u0002\"!\u0012\u0004F\rE3Q\u000b\t\u0004\u0003\u000f:bBA3\u000f\u0003M!U\r\u001c;b\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s!\t)wbE\u0002\u0010/v#\"!a\u0013\u0002\u001b\u001d,GoQ8n[&$\u0018J\u001c4p)!\tI\"!\u0016\u0002f\u0005e\u0004bBA,#\u0001\u0007\u0011\u0011L\u0001\tY><7\u000b^8sKB!\u00111LA1\u001b\t\tiFC\u0002\u0002`-\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0002d\u0005u#\u0001\u0003'pON#xN]3\t\u000f\u0005\u001d\u0014\u00031\u0001\u0002j\u0005A!-Y:f!\u0006$\b\u000e\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0005\u0019\u001c(bAA:#\u00061\u0001.\u00193p_BLA!a\u001e\u0002n\t!\u0001+\u0019;i\u0011\u001d\tY(\u0005a\u0001\u0003k\tqA^3sg&|g.\u0001\u0006hKR\u001cu.\\7jiN$\"\"!!\u0003,\t5\"\u0011\u0007B\u001a!\u0015A\u00161QAD\u0013\r\t))\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0003\u0013;R\"A\b\u0003\r\r{W.\\5u'!9r+a$\u0002\u0016\u0006m\u0005\u0003BA\u000e\u0003#KA!a%\u0002\u001e\ta1i\\7nSRl\u0015M]6feB\u0019\u0001,a&\n\u0007\u0005e\u0015LA\u0004Qe>$Wo\u0019;\u0011\u0007a\u000bi*C\u0002\u0002 f\u0013AbU3sS\u0006d\u0017N_1cY\u0016,\"!!\u000e\u0002\u0011Y,'o]5p]\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b\u0005\u0006\u0004\u0002\b\u0006-\u0016Q\u0016\u0005\b\u0003wb\u0002\u0019AA\u001b\u0011\u001d\t)\u000b\ba\u0001\u0003k\tQb^5uQRKW.Z:uC6\u0004H\u0003BAD\u0003gCq!!*\u001e\u0001\u0004\t)$\u0001\u0007hKR$\u0016.\\3ti\u0006l\u0007/\u0001\u0006hKR4VM]:j_:\fAaY8qsR1\u0011qQA_\u0003\u007fC\u0011\"a\u001f!!\u0003\u0005\r!!\u000e\t\u0013\u0005\u0015\u0006\u0005%AA\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bTC!!\u000e\u0002H.\u0012\u0011\u0011\u001a\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003%)hn\u00195fG.,GMC\u0002\u0002Tf\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9.!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t1\fgn\u001a\u0006\u0003\u0003S\fAA[1wC&!\u0011Q^Ar\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t\u0011.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0018Q \t\u00041\u0006e\u0018bAA~3\n\u0019\u0011I\\=\t\u0011\u0005}X%!AA\u0002%\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0003!\u0019\u00119A!\u0004\u0002x6\u0011!\u0011\u0002\u0006\u0004\u0005\u0017I\u0016AC2pY2,7\r^5p]&!!q\u0002B\u0005\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tU!1\u0004\t\u00041\n]\u0011b\u0001B\r3\n9!i\\8mK\u0006t\u0007\"CA\u0000O\u0005\u0005\t\u0019AA|\u0003!A\u0017m\u001d5D_\u0012,G#A5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a8\u0002\r\u0015\fX/\u00197t)\u0011\u0011)B!\u000b\t\u0013\u0005}(&!AA\u0002\u0005]\bbBA,%\u0001\u0007\u0011\u0011\f\u0005\b\u0005_\u0011\u0002\u0019AA5\u0003\u001dawn\u001a)bi\"Dq!a\r\u0013\u0001\u0004\t)\u0004C\u0005\u0002>I\u0001\n\u00111\u0001\u0002@\u0005!r-\u001a;D_6l\u0017\u000e^:%I\u00164\u0017-\u001e7uIQ*\"A!\u000f+\t\u0005}\u0012qY\u0001\u001b[>tw\u000e^8oSj,7i\\7nSR$\u0016.\\3ti\u0006l\u0007o]\u000b\u0005\u0005\u007f\u00119\u0005\u0006\u0003\u0003B\tM\u0003#\u0002-\u0002\u0004\n\r\u0003\u0003\u0002B#\u0005\u000fb\u0001\u0001B\u0004\u0003JQ\u0011\rAa\u0013\u0003\u0003Q\u000bBA!\u0014\u0002\u0010B\u0019\u0001La\u0014\n\u0007\tE\u0013LA\u0004O_RD\u0017N\\4\t\u000f\tUC\u00031\u0001\u0003B\u000591m\\7nSR\u001c\u0018a\u00049be\u0006dG.\u001a7TK\u0006\u00148\r\u001b\u0019\u0015!\u0005\u001d%1\fB/\u0005C\u0012\tH!\u001e\u0003x\te\u0004\"\u0002)\u0016\u0001\u0004\u0011\bB\u0002B0+\u0001\u0007\u00010\u0001\u0003d_:4\u0007b\u0002B\u0018+\u0001\u0007!1\r\t\u0005\u0005K\u0012iG\u0004\u0003\u0003h\t%\u0004cAA\u00043&\u0019!1N-\u0002\rA\u0013X\rZ3g\u0013\u0011\tiOa\u001c\u000b\u0007\t-\u0014\fC\u0004\u0003tU\u0001\r!!\u000e\u0002\tQLW.\u001a\u0005\b\u0003g)\u0002\u0019AA\u001b\u0011\u001d\ti$\u0006a\u0001\u0003kAqAa\u001f\u0016\u0001\u0004\t)$\u0001\u0003ti\u0016\u0004\u0018!\u00077bgR\u001cu.\\7ji\n+gm\u001c:f)&lWm\u001d;b[B$bA!!\u0003\u0004\n\u001d\u0005#\u0002-\u0002,\u0005\u001d\u0005b\u0002B+-\u0001\u0007!Q\u0011\t\u0007\u0003\u0007\t\u0019\"a\"\t\u000f\tMd\u00031\u0001\u00026\u000511i\\7nSR\u00042!!#-'\u0015a#qRAN!)\u0011\tJa&\u00026\u0005U\u0012qQ\u0007\u0003\u0005'S1A!&Z\u0003\u001d\u0011XO\u001c;j[\u0016LAA!'\u0003\u0014\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\t-\u0015!B1qa2LHCBAD\u0005C\u0013\u0019\u000bC\u0004\u0002|=\u0002\r!!\u000e\t\u000f\u0005\u0015v\u00061\u0001\u00026\u00059QO\\1qa2LH\u0003\u0002BU\u0005c\u0003R\u0001WA\u0016\u0005W\u0003r\u0001\u0017BW\u0003k\t)$C\u0002\u00030f\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003BZa\u0005\u0005\t\u0019AAD\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003:B!\u0011\u0011\u001dB^\u0013\u0011\u0011i,a9\u0003\r=\u0013'.Z2u\u0005q\u0011UO\u001a4fe&tw\rT8h\t\u0016dW\r^5p]&#XM]1u_J\u001cBAM,\u0003DB1\u00111\u0001Bc\u0005\u000fLAAa\u0004\u0002\u0018A!\u00111\u000eBe\u0013\u0011\u0011Y-!\u001c\u0003\u0015\u0019KG.Z*uCR,8/\u0001\u0006v]\u0012,'\u000f\\=j]\u001e\fA\"\\1y)&lWm\u001d;b[B\f!\"\\1y-\u0016\u00148/[8o\u000351XM]:j_:<U\r\u001e;feB9\u0001La6\u0002j\u0005U\u0012b\u0001Bm3\nIa)\u001e8di&|g.\r\u000b\u000b\u0005;\u0014yN!9\u0003d\n\u0015\bcAAEe!9!QZ\u001cA\u0002\t\r\u0007b\u0002Bho\u0001\u0007\u0011Q\u0007\u0005\b\u0005#<\u0004\u0019AA\u001b\u0011\u001d\u0011\u0019n\u000ea\u0001\u0005+\fQBZ5mKN$v\u000eR3mKR,WC\u0001Bv!\u0019\u0011iOa=\u0003H6\u0011!q\u001e\u0006\u0005\u0005c\u0014I!A\u0004nkR\f'\r\\3\n\t\tU(q\u001e\u0002\u0006#V,W/Z\u0001\u000fM&dWm\u001d+p\t\u0016dW\r^3!\u0003Ai\u0017-\u001f2f\t\u0016dW\r^3GS2,7/\u0006\u0002\u0003~B1!Q\u001eB\u0000\u0005\u000fLAa!\u0001\u0003p\nY\u0011I\u001d:bs\n+hMZ3s\u0003Ei\u0017-\u001f2f\t\u0016dW\r^3GS2,7\u000fI\u0001\tY\u0006\u001cHOR5mKV\u0011!qY\u0001\rY\u0006\u001cHOR5mK~#S-\u001d\u000b\u0005\u0007\u001b\u0019\u0019\u0002E\u0002Y\u0007\u001fI1a!\u0005Z\u0005\u0011)f.\u001b;\t\u0013\u0005}X(!AA\u0002\t\u001d\u0017!\u00037bgR4\u0015\u000e\\3!\u00035A\u0017m\u001d(fqR\u001c\u0015\r\u001c7fIV\u0011!QC\u0001\u0012Q\u0006\u001ch*\u001a=u\u0007\u0006dG.\u001a3`I\u0015\fH\u0003BB\u0007\u0007?A\u0011\"a@A\u0003\u0003\u0005\rA!\u0006\u0002\u001d!\f7OT3yi\u000e\u000bG\u000e\\3eA\u0005!\u0011N\\5u)\t\u0019i!\u0001\ttQ>,H\u000e\u001a#fY\u0016$XMR5mKR!!QCB\u0016\u0011\u001d\u0019ic\u0011a\u0001\u0005\u000f\fAAZ5mK\u0006\u0019b.Z3egRKW.Z!eUV\u001cH/\\3oiR!!QCB\u001a\u0011\u001d\u0019i\u0003\u0012a\u0001\u0005\u000f\f1B\u001a7vg\"\u0014UO\u001a4fe\u0006\u0011\u0012/^3vK\u001aKG.Z:J]\n+hMZ3s\u0003\u001dA\u0017m\u001d(fqR\fAA\\3yiR\u0011!qY\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r#fA5\u0002H\"9\u0011Q\u0015\u0005A\u0002\r\u001d\u0003\u0003BB%\u0007\u001bj!aa\u0013\u000b\u00079\u000b9/\u0003\u0003\u0004P\r-#!\u0003+j[\u0016\u001cH/Y7q\u0011\u001d\u0019\u0019\u0006\u0003a\u0001\u0005+\t1cY1o%\u0016$XO\u001d8MCN$8i\\7nSRD\u0011ba\u0016\t!\u0003\u0005\rA!\u0006\u0002#5,8\u000f\u001e\"f%\u0016\u001c'/Z1uC\ndW-A\u0010hKR\f5\r^5wK\u000e{W.\\5u\u0003R$\u0016.\\3%I\u00164\u0017-\u001e7uIM*\"a!\u0018+\t\tU\u0011qY\u0001\u0013G\",7m\u001b,feNLwN\\#ySN$8\u000f\u0006\u0003\u0004\u000e\r\r\u0004bBA>\u0015\u0001\u0007\u0011QG\u0001\u000fa\u0006\u0014\u0018\r\u001c7fYN+\u0017M]2i)!\t)e!\u001b\u0004l\r5\u0004b\u0002B:\u0017\u0001\u0007\u0011Q\u0007\u0005\b\u0003gY\u0001\u0019AA\u001b\u0011\u001d\tid\u0003a\u0001\u0003k\tAcZ3u\u000b\u0006\u0014H.[3ti\u0012+G\u000e^1GS2,\u0017!H4fi\u0016\u000b'\u000f\\5fgR\u0014V\r\u001d:pIV\u001c\u0017N\u00197f\u0007>lW.\u001b;")
public class DeltaHistoryManager
implements DeltaLogging {
    private final DeltaLog deltaLog;
    private final int maxKeysPerList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$2() {
        return DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private SerializableConfiguration getSerializableHadoopConf() {
        return new SerializableConfiguration(this.spark().sessionState().newHadoopConf());
    }

    public Seq<CommitInfo> getHistory(Option<Object> limitOpt) {
        long listStart = BoxesRunTime.unboxToLong((Object)limitOpt.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)limit -> scala.math.package$.MODULE$.max($this.deltaLog.update($this.deltaLog.update$default$1()).version() - (long)limit + 1L, 0L)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.getEarliestDeltaFile()));
        return this.getHistory(listStart, (Option<Object>)None$.MODULE$);
    }

    public Seq<CommitInfo> getHistory(long start, Option<Object> end) {
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.actions.CommitInfo").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(DeltaHistoryManager $outer) {
            }
        }
        SparkSession _spark = this.spark();
        SerializableConfiguration conf = this.getSerializableHadoopConf();
        String logPath = this.deltaLog.logPath().toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeltaHistoryManager.class.getClassLoader());
        Dataset info = this.spark().range(start, BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.deltaLog.update($this.deltaLog.update$default$1()).version())) + 1L).mapPartitions((Function1 & Serializable & scala.Serializable)versions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            Path basePath = new Path(logPath);
            FileSystem fs = basePath.getFileSystem(conf.value());
            return versions.flatMap((Function1 & Serializable & scala.Serializable)commit -> {
                Iterable iterable;
                try {
                    CommitInfo ci = DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(logStore, basePath, Predef$.MODULE$.Long2long(commit));
                    FileStatus metadata = fs.getFileStatus(FileNames$.MODULE$.deltaFile(basePath, Predef$.MODULE$.Long2long(commit)));
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ci.withTimestamp(metadata.getModificationTime())));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            });
        }, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(null))));
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])info.collect()))).reverse());
    }

    public Commit getActiveCommitAtTime(Timestamp timestamp, boolean canReturnLastCommit, boolean mustBeRecreatable) {
        Commit commit;
        long time = timestamp.getTime();
        long earliest = mustBeRecreatable ? this.getEarliestReproducibleCommit() : this.getEarliestDeltaFile();
        long latestVersion = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (latestVersion - earliest > (long)(2 * this.maxKeysPerList)) {
            commit = this.parallelSearch(time, earliest, latestVersion + 1L);
        } else {
            Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.deltaLog.store(), this.deltaLog.logPath(), earliest, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(latestVersion + 1L))));
            commit = (Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).head());
        }
        Commit commit2 = commit;
        Timestamp commitTs = new Timestamp(commit2.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        if (commit2.timestamp() > time) {
            throw DeltaErrors$.MODULE$.timestampEarlierThanCommitRetention(timestamp, commitTs, tsString);
        }
        if (commit2.version() == latestVersion && !canReturnLastCommit && commit2.timestamp() < time) {
            throw DeltaErrors$.MODULE$.temporallyUnstableInput(timestamp, commitTs, tsString, commit2.version());
        }
        return commit2;
    }

    public boolean getActiveCommitAtTime$default$3() {
        return true;
    }

    public void checkVersionExists(long version) {
        long earliest = this.getEarliestReproducibleCommit();
        long latest = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (version < earliest || version > latest) {
            throw DeltaErrors$.MODULE$.versionNotExistException(version, earliest, latest);
        }
    }

    private Commit parallelSearch(long time, long start, long end) {
        return DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(this.spark(), this.getSerializableHadoopConf(), this.deltaLog.logPath().toString(), time, start, end, this.maxKeysPerList);
    }

    private long getEarliestDeltaFile() {
        Option earliestVersionOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deltaLog.store().listFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileNames$.MODULE$.isDeltaFile(f.getPath()))).take(1).toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).headOption();
        if (earliestVersionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
        }
        return FileNames$.MODULE$.deltaVersion(((FileStatus)earliestVersionOpt.get()).getPath());
    }

    private long getEarliestReproducibleCommit() {
        Iterator files = this.deltaLog.store().listFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager.$anonfun$getEarliestReproducibleCommit$1(f)));
        HashMap checkpointMap = new HashMap();
        LongRef smallestDeltaVersion = LongRef.create((long)Long.MAX_VALUE);
        None$ lastCompleteCheckpoint = None$.MODULE$;
        while (files.hasNext()) {
            BoxedUnit boxedUnit;
            Path nextFilePath = ((FileStatus)files.next()).getPath();
            if (FileNames$.MODULE$.isDeltaFile(nextFilePath)) {
                long version = FileNames$.MODULE$.deltaVersion(nextFilePath);
                if (version == 0L) {
                    return version;
                }
                smallestDeltaVersion.elem = scala.math.package$.MODULE$.min(version, smallestDeltaVersion.elem);
                if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 >= smallestDeltaVersion$1.elem)) {
                    return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (FileNames$.MODULE$.isCheckpointFile(nextFilePath)) {
                int preCount;
                long checkpointVersion = FileNames$.MODULE$.checkpointVersion(nextFilePath);
                Option<Object> parts = FileNames$.MODULE$.numCheckpointParts(nextFilePath);
                if (parts.isEmpty()) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                int numParts = BoxesRunTime.unboxToInt((Object)parts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                if (numParts == (preCount = BoxesRunTime.unboxToInt((Object)checkpointMap.getOrElse((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) + 1 && smallestDeltaVersion.elem <= checkpointVersion) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                }
                boxedUnit = checkpointMap.put((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Object)BoxesRunTime.boxToInteger((int)(preCount + 1)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= smallestDeltaVersion$1.elem)) {
            return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
        }
        if (smallestDeltaVersion.elem < Long.MAX_VALUE) {
            throw DeltaErrors$.MODULE$.noReproducibleHistoryFound(this.deltaLog.logPath());
        }
        throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
    }

    public static final /* synthetic */ boolean $anonfun$getEarliestReproducibleCommit$1(FileStatus f) {
        return FileNames$.MODULE$.isDeltaFile(f.getPath()) || FileNames$.MODULE$.isCheckpointFile(f.getPath());
    }

    public DeltaHistoryManager(DeltaLog deltaLog, int maxKeysPerList) {
        this.deltaLog = deltaLog;
        this.maxKeysPerList = maxKeysPerList;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }

    public static class BufferingLogDeletionIterator
    implements Iterator<FileStatus> {
        private final Iterator<FileStatus> underlying;
        private final long maxTimestamp;
        private final long maxVersion;
        private final Function1<Path, Object> versionGetter;
        private final Queue<FileStatus> filesToDelete;
        private final ArrayBuffer<FileStatus> maybeDeleteFiles;
        private FileStatus lastFile;
        private boolean hasNextCalled;

        public Iterator<FileStatus> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<FileStatus> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<FileStatus> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<FileStatus, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<FileStatus, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<FileStatus, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<FileStatus, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, FileStatus, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<FileStatus, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<FileStatus, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<FileStatus, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<FileStatus, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<FileStatus, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<FileStatus> find(Function1<FileStatus, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<FileStatus> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<FileStatus> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<FileStatus> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<FileStatus> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<FileStatus> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<FileStatus, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<FileStatus, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, FileStatus, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<FileStatus> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<FileStatus> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<FileStatus> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<FileStatus> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<FileStatus> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, FileStatus, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<FileStatus, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Queue<FileStatus> filesToDelete() {
            return this.filesToDelete;
        }

        private ArrayBuffer<FileStatus> maybeDeleteFiles() {
            return this.maybeDeleteFiles;
        }

        private FileStatus lastFile() {
            return this.lastFile;
        }

        private void lastFile_$eq(FileStatus x$1) {
            this.lastFile = x$1;
        }

        private boolean hasNextCalled() {
            return this.hasNextCalled;
        }

        private void hasNextCalled_$eq(boolean x$1) {
            this.hasNextCalled = x$1;
        }

        private void init() {
            block0: {
                if (!this.underlying.hasNext()) break block0;
                this.lastFile_$eq((FileStatus)this.underlying.next());
                this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{this.lastFile()}));
            }
        }

        private boolean shouldDeleteFile(FileStatus file) {
            return file.getModificationTime() <= this.maxTimestamp && BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) <= this.maxVersion;
        }

        private boolean needsTimeAdjustment(FileStatus file) {
            return BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)this.lastFile().getPath())) < BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) && this.lastFile().getModificationTime() >= file.getModificationTime();
        }

        private void flushBuffer() {
            if (this.maybeDeleteFiles().lastOption().exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.shouldDeleteFile(file)))) {
                this.filesToDelete().enqueue(this.maybeDeleteFiles());
            }
            this.maybeDeleteFiles().clear();
        }

        private void queueFilesInBuffer() {
            boolean continueBuffering = true;
            while (continueBuffering) {
                if (!this.underlying.hasNext()) {
                    this.flushBuffer();
                    return;
                }
                FileStatus currentFile = (FileStatus)this.underlying.next();
                Predef$.MODULE$.require(currentFile != null, (Function0 & Serializable & scala.Serializable)() -> "FileStatus iterator returned null");
                if (this.needsTimeAdjustment(currentFile)) {
                    currentFile = new FileStatus(currentFile.getLen(), currentFile.isDirectory(), (int)currentFile.getReplication(), currentFile.getBlockSize(), this.lastFile().getModificationTime() + 1L, currentFile.getPath());
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                } else {
                    this.flushBuffer();
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                    continueBuffering = false;
                }
                this.lastFile_$eq(currentFile);
            }
        }

        public boolean hasNext() {
            block0: {
                this.hasNextCalled_$eq(true);
                if (!this.filesToDelete().isEmpty()) break block0;
                this.queueFilesInBuffer();
            }
            return this.filesToDelete().nonEmpty();
        }

        public FileStatus next() {
            if (!this.hasNextCalled()) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled_$eq(false);
            return (FileStatus)this.filesToDelete().dequeue();
        }

        public BufferingLogDeletionIterator(Iterator<FileStatus> underlying, long maxTimestamp, long maxVersion, Function1<Path, Object> versionGetter) {
            this.underlying = underlying;
            this.maxTimestamp = maxTimestamp;
            this.maxVersion = maxVersion;
            this.versionGetter = versionGetter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.filesToDelete = new Queue();
            this.maybeDeleteFiles = new ArrayBuffer();
            this.hasNextCalled = false;
            this.init();
        }
    }

    public static class Commit
    implements CommitMarker,
    Product,
    scala.Serializable {
        private final long version;
        private final long timestamp;

        public long version() {
            return this.version;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public Commit withTimestamp(long timestamp) {
            long x$1 = timestamp;
            long x$2 = this.copy$default$1();
            return this.copy(x$2, x$1);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp();
        }

        @Override
        public long getVersion() {
            return this.version();
        }

        public Commit copy(long version, long timestamp) {
            return new Commit(version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.version());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.version() != commit.version()) return false;
            if (this.timestamp() != commit.timestamp()) return false;
            if (!commit.canEqual(this)) return false;
            return true;
        }

        public Commit(long version, long timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            Product.$init$((Product)this);
        }
    }
}

