/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.commands.DeltaGenerateCommand$;
import org.apache.spark.sql.delta.commands.DeltaGenerateCommandBase;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0001\"AA\n\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005S\u0001\tE\t\u0015!\u0003O\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u001da\u0007!!A\u0005\u00025Dq\u0001\u001d\u0001\u0012\u0002\u0013\u0005\u0011\u000fC\u0004}\u0001E\u0005I\u0011A?\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0015\u0001\u0005\u0005I\u0011IA\u0016\u0011%\tI\u0004AA\u0001\n\u0003\tY\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H\u001d9\u00111J\r\t\u0002\u00055cA\u0002\r\u001a\u0011\u0003\ty\u0005\u0003\u0004T#\u0011\u0005\u0011q\u000b\u0005\n\u00033\n\"\u0019!C\u0001\u00037B\u0001\"! \u0012A\u0003%\u0011Q\f\u0005\n\u0003\u007f\n\u0012\u0011!CA\u0003\u0003C\u0011\"a\"\u0012\u0003\u0003%\t)!#\t\u0013\u0005m\u0015#!A\u0005\n\u0005u%\u0001\u0006#fYR\fw)\u001a8fe\u0006$XmQ8n[\u0006tGM\u0003\u0002\u001b7\u0005A1m\\7nC:$7O\u0003\u0002\u001d;\u0005)A-\u001a7uC*\u0011adH\u0001\u0004gFd'B\u0001\u0011\"\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00113%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002I\u0005\u0019qN]4\u0004\u0001M)\u0001aJ\u00196wA\u0011\u0001fL\u0007\u0002S)\u0011!fK\u0001\bY><\u0017nY1m\u0015\taS&A\u0003qY\u0006t7O\u0003\u0002/;\u0005A1-\u0019;bYf\u001cH/\u0003\u00021S\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t\u00114'D\u0001\u001a\u0013\t!\u0014D\u0001\rEK2$\u0018mR3oKJ\fG/Z\"p[6\fg\u000e\u001a\"bg\u0016\u0004\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00027y%\u0011Qh\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\t[>$WMT1nKV\t\u0001\t\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007^j\u0011\u0001\u0012\u0006\u0003\u000b\u0016\na\u0001\u0010:p_Rt\u0014BA$8\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d;\u0014!C7pI\u0016t\u0015-\\3!\u0003\u001d!\u0018M\u00197f\u0013\u0012,\u0012A\u0014\t\u0003\u001fBk\u0011!L\u0005\u0003#6\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\ti\u0006\u0014G.Z%eA\u00051A(\u001b8jiz\"2!\u0016,X!\t\u0011\u0004\u0001C\u0003?\u000b\u0001\u0007\u0001\tC\u0003M\u000b\u0001\u0007a*A\u0002sk:$\"AW4\u0011\u0007m\u00037M\u0004\u0002]=:\u00111)X\u0005\u0002q%\u0011qlN\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'MA\u0002TKFT!aX\u001c\u0011\u0005\u0011,W\"A\u000f\n\u0005\u0019l\"a\u0001*po\")\u0001N\u0002a\u0001S\u0006a1\u000f]1sWN+7o]5p]B\u0011AM[\u0005\u0003Wv\u0011Ab\u00159be.\u001cVm]:j_:\fAaY8qsR\u0019QK\\8\t\u000fy:\u0001\u0013!a\u0001\u0001\"9Aj\u0002I\u0001\u0002\u0004q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002e*\u0012\u0001i]\u0016\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\nk:\u001c\u0007.Z2lK\u0012T!!_\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002|m\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\taP\u000b\u0002Og\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!A.\u00198h\u0015\t\ti!\u0001\u0003kCZ\f\u0017bA%\u0002\b\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0003\t\u0004m\u0005]\u0011bAA\ro\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qDA\u0013!\r1\u0014\u0011E\u0005\u0004\u0003G9$aA!os\"I\u0011q\u0005\u0007\u0002\u0002\u0003\u0007\u0011QC\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\u0002CBA\u0018\u0003k\ty\"\u0004\u0002\u00022)\u0019\u00111G\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00028\u0005E\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0010\u0002DA\u0019a'a\u0010\n\u0007\u0005\u0005sGA\u0004C_>dW-\u00198\t\u0013\u0005\u001db\"!AA\u0002\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002>\u0005%\u0003\"CA\u0014\u001f\u0005\u0005\t\u0019AA\u0010\u0003Q!U\r\u001c;b\u000f\u0016tWM]1uK\u000e{W.\\1oIB\u0011!'E\n\u0005#\u0005E3\bE\u00027\u0003'J1!!\u00168\u0005\u0019\te.\u001f*fMR\u0011\u0011QJ\u0001\u0019[>$WMT1nKR{w)\u001a8fe\u0006$\u0018n\u001c8Gk:\u001cWCAA/!\u0019\ty&!\u001a\u0002j5\u0011\u0011\u0011\r\u0006\u0004\u0003Gj\u0013\u0001B;uS2LA!a\u001a\u0002b\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q!!1\u00141N5\u0002p\u0005]\u0014bAA7o\tIa)\u001e8di&|gN\r\t\u0005\u0003c\n\u0019(D\u0001\u001c\u0013\r\t)h\u0007\u0002\t\t\u0016dG/\u0019'pOB\u0019a'!\u001f\n\u0007\u0005mtG\u0001\u0003V]&$\u0018!G7pI\u0016t\u0015-\\3U_\u001e+g.\u001a:bi&|gNR;oG\u0002\nQ!\u00199qYf$R!VAB\u0003\u000bCQAP\u000bA\u0002\u0001CQ\u0001T\u000bA\u00029\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\f\u0006]\u0005#\u0002\u001c\u0002\u000e\u0006E\u0015bAAHo\t1q\n\u001d;j_:\u0004RANAJ\u0001:K1!!&8\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0014\f\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0014\t\u0005\u0003\u000b\t\t+\u0003\u0003\u0002$\u0006\u001d!AB(cU\u0016\u001cG\u000f")
public class DeltaGenerateCommand
extends LogicalPlan
implements DeltaGenerateCommandBase,
Serializable {
    private final String modeName;
    private final TableIdentifier tableId;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<String, TableIdentifier>> unapply(DeltaGenerateCommand deltaGenerateCommand) {
        return DeltaGenerateCommand$.MODULE$.unapply(deltaGenerateCommand);
    }

    public static CaseInsensitiveMap<Function2<SparkSession, DeltaLog, BoxedUnit>> modeNameToGenerationFunc() {
        return DeltaGenerateCommand$.MODULE$.modeNameToGenerationFunc();
    }

    @Override
    public Path getPath(SparkSession spark, TableIdentifier tableId) {
        return DeltaGenerateCommandBase.getPath$(this, spark, tableId);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeltaGenerateCommand deltaGenerateCommand = this;
        synchronized (deltaGenerateCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public String modeName() {
        return this.modeName;
    }

    public TableIdentifier tableId() {
        return this.tableId;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        if (!DeltaGenerateCommand$.MODULE$.modeNameToGenerationFunc().contains(this.modeName())) {
            throw DeltaErrors$.MODULE$.unsupportedGenerateModeException(this.modeName());
        }
        Path tablePath = this.getPath(sparkSession, this.tableId());
        DeltaLog deltaLog = DeltaLog$.MODULE$.forTable(sparkSession, tablePath);
        if (deltaLog.snapshot().version() < 0L) {
            throw new AnalysisException(new StringBuilder(26).append("Delta table not found at ").append(tablePath).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Function2 generationFunc = (Function2)DeltaGenerateCommand$.MODULE$.modeNameToGenerationFunc().apply((Object)this.modeName());
        generationFunc.apply((Object)sparkSession, (Object)deltaLog);
        return (Seq)Seq$.MODULE$.empty();
    }

    public DeltaGenerateCommand copy(String modeName, TableIdentifier tableId) {
        return new DeltaGenerateCommand(modeName, tableId);
    }

    public String copy$default$1() {
        return this.modeName();
    }

    public TableIdentifier copy$default$2() {
        return this.tableId();
    }

    public String productPrefix() {
        return "DeltaGenerateCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = this.modeName();
                break;
            }
            case 1: {
                string = this.tableId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return string;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeltaGenerateCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeltaGenerateCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeltaGenerateCommand deltaGenerateCommand = (DeltaGenerateCommand)x$1;
        String string = this.modeName();
        String string2 = deltaGenerateCommand.modeName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        TableIdentifier tableIdentifier = this.tableId();
        TableIdentifier tableIdentifier2 = deltaGenerateCommand.tableId();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (!deltaGenerateCommand.canEqual(this)) return false;
        return true;
    }

    public DeltaGenerateCommand(String modeName, TableIdentifier tableId) {
        this.modeName = modeName;
        this.tableId = tableId;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaGenerateCommandBase.$init$(this);
    }
}

