/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTable$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.sources.DeltaDataSource;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DeltaDataSource$
implements DatabricksLogging {
    public static DeltaDataSource$ MODULE$;
    private final Formats formats;

    static {
        new DeltaDataSource$();
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    private Formats formats() {
        return this.formats;
    }

    public final String TIME_TRAVEL_SOURCE_KEY() {
        return "__time_travel_source__";
    }

    public final String TIME_TRAVEL_TIMESTAMP_KEY() {
        return "timestampAsOf";
    }

    public final String TIME_TRAVEL_VERSION_KEY() {
        return "versionAsOf";
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public Option<String> extractDeltaPath(Dataset<?> dataset) {
        None$ none$;
        if (dataset.isStreaming()) {
            None$ none$2;
            LogicalPlan logicalPlan = dataset.queryExecution().logical();
            if (logicalPlan instanceof StreamingRelation) {
                StreamingRelation streamingRelation = (StreamingRelation)logicalPlan;
                Class clazz = streamingRelation.dataSource().providingClass();
                Class<DeltaDataSource> clazz2 = DeltaDataSource.class;
                none$2 = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? CaseInsensitiveMap$.MODULE$.apply(streamingRelation.dataSource().options()).get("path") : None$.MODULE$;
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            LogicalRelation logicalRelation;
            Option<TahoeFileIndex> option;
            SubqueryAlias subqueryAlias;
            LogicalPlan logicalPlan;
            None$ none$3;
            LogicalRelation logicalRelation2;
            Option<TahoeFileIndex> option2;
            LogicalPlan logicalPlan2 = dataset.queryExecution().analyzed();
            if (logicalPlan2 instanceof LogicalRelation && !(option2 = DeltaTable$.MODULE$.unapply(logicalRelation2 = (LogicalRelation)logicalPlan2)).isEmpty()) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option2.get();
                none$3 = new Some((Object)tahoeFileIndex.path().toString());
            } else if (logicalPlan2 instanceof SubqueryAlias && (logicalPlan = (subqueryAlias = (SubqueryAlias)logicalPlan2).child()) instanceof LogicalRelation && !(option = DeltaTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan)).isEmpty()) {
                TahoeFileIndex tahoeFileIndex = (TahoeFileIndex)option.get();
                none$3 = new Some((Object)tahoeFileIndex.path().toString());
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        }
        return none$;
    }

    public Tuple3<Path, Seq<Tuple2<String, String>>, Option<DeltaTimeTravelSpec>> parsePathIdentifier(SparkSession spark, String userPath) {
        Seq<Tuple2<String, String>> seq;
        Path rootPath;
        Tuple2<String, Option<DeltaTimeTravelSpec>> tuple2 = DeltaTableUtils$.MODULE$.extractIfPathContainsTimeTravel(spark, userPath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String path = (String)tuple2._1();
        Option timeTravelByPath = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)path, (Object)timeTravelByPath);
        Tuple2 tuple23 = tuple22;
        String path2 = (String)tuple23._1();
        Option timeTravelByPath2 = (Option)tuple23._2();
        Path hadoopPath = new Path(path2);
        Path path3 = rootPath = (Path)DeltaTableUtils$.MODULE$.findDeltaTableRoot(spark, hadoopPath, DeltaTableUtils$.MODULE$.findDeltaTableRoot$default$3()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            FileSystem fs = hadoopPath.getFileSystem(spark.sessionState().newHadoopConf());
            if (!fs.exists(hadoopPath)) {
                throw DeltaErrors$.MODULE$.pathNotExistsException(path2);
            }
            return hadoopPath;
        });
        Path path4 = hadoopPath;
        if (path3 == null ? path4 != null : !path3.equals(path4)) {
            this.logConsole(new StringOps(Predef$.MODULE$.augmentString("\n                   |WARNING: loading partitions directly with delta is not recommended.\n                   |If you are trying to read a specific partition, use a where predicate.\n                   |\n                   |CORRECT: spark.read.format(\"delta\").load(\"/data\").where(\"part=1\")\n                   |INCORRECT: spark.read.format(\"delta\").load(\"/data/part=1\")\n        ")).stripMargin());
            String fragment = hadoopPath.toString().substring(rootPath.toString().length() + 1);
            try {
                seq = PartitionUtils$.MODULE$.parsePathFragmentAsSeq(fragment);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw DeltaErrors$.MODULE$.partitionPathParseException(fragment);
            }
        } else {
            seq = Nil$.MODULE$;
        }
        Seq<Tuple2<String, String>> partitionFilters = seq;
        return new Tuple3((Object)rootPath, (Object)partitionFilters, (Object)timeTravelByPath2);
    }

    public Seq<Expression> verifyAndCreatePartitionFilters(String userPath, DeltaLog deltaLog, Seq<Tuple2<String, String>> partitionFilters) {
        Nil$ nil$;
        if (partitionFilters.nonEmpty()) {
            Snapshot snapshot = deltaLog.update(deltaLog.update$default$1());
            Metadata metadata = snapshot.metadata();
            Seq badColumns = (Seq)((TraversableLike)partitionFilters.map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._1(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DeltaDataSource$.$anonfun$verifyAndCreatePartitionFilters$2(metadata, elem)));
            if (badColumns.nonEmpty()) {
                String fragment = ((TraversableOnce)partitionFilters.map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(f._1()).append("=").append(f._2()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("/");
                throw DeltaErrors$.MODULE$.partitionPathInvolvesNonPartitionColumnException((Seq<String>)badColumns, fragment);
            }
            Seq filters = (Seq)partitionFilters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                EqualTo equalTo = new EqualTo((Expression)new UnresolvedAttribute((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key}))), (Expression)Literal$.MODULE$.apply((Object)value));
                return equalTo;
            }, Seq$.MODULE$.canBuildFrom());
            Dataset<Row> files = DeltaLog$.MODULE$.filterFileList(metadata.partitionSchema(), (Dataset<Row>)snapshot.allFiles().toDF(), (Seq<Expression>)filters, DeltaLog$.MODULE$.filterFileList$default$4());
            if (files.count() == 0L) {
                throw DeltaErrors$.MODULE$.pathNotExistsException(userPath);
            }
            nil$ = filters;
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Option<DeltaTimeTravelSpec> getTimeTravelVersion(Map<String, String> parameters) {
        Some some;
        CaseInsensitiveMap caseInsensitive = CaseInsensitiveMap$.MODULE$.apply(parameters);
        Option tsOpt = caseInsensitive.get("timestampAsOf");
        Option versionOpt = caseInsensitive.get("versionAsOf");
        Option sourceOpt = caseInsensitive.get("__time_travel_source__");
        if (tsOpt.isDefined() && versionOpt.isDefined()) {
            throw DeltaErrors$.MODULE$.provideOneOfInTimeTravel();
        }
        if (tsOpt.isDefined()) {
            some = new Some((Object)new DeltaTimeTravelSpec((Option<Expression>)new Some((Object)Literal$.MODULE$.apply(tsOpt.get())), (Option<Object>)None$.MODULE$, (Option<String>)sourceOpt.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"dfReader"))));
        } else if (versionOpt.isDefined()) {
            long v;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)versionOpt.get())).toLong());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    throw new IllegalArgumentException(new StringBuilder(45).append("versionAsOf").append(" needs to be a valid bigint value.").toString(), t);
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            long l = v = BoxesRunTime.unboxToLong((Object)success.value());
            long version = l;
            some = new Some((Object)new DeltaTimeTravelSpec((Option<Expression>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)), (Option<String>)sourceOpt.orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)"dfReader"))));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$verifyAndCreatePartitionFilters$2(Metadata metadata$1, Object elem) {
        return metadata$1.partitionColumns().contains(elem);
    }

    private DeltaDataSource$() {
        MODULE$ = this;
        DatabricksLogging.$init$(this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

