/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.util.concurrent.TimeUnit;
import org.apache.spark.internal.config.ConfigBuilder;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DeltaSQLConf$ {
    public static DeltaSQLConf$ MODULE$;
    private final ConfigEntry<Object> RESOLVE_TIME_TRAVEL_ON_IDENTIFIER;
    private final ConfigEntry<Object> DELTA_COMMIT_INFO_ENABLED;
    private final OptionalConfigEntry<Object> DELTA_SNAPSHOT_PARTITIONS;
    private final ConfigEntry<Object> DELTA_PARTITION_COLUMN_CHECK_ENABLED;
    private final ConfigEntry<Object> DELTA_SCHEMA_ON_READ_CHECK_ENABLED;
    private final ConfigEntry<Object> DELTA_COLLECT_STATS;
    private final ConfigEntry<Object> DELTA_IMPORT_BATCH_SIZE_STATS_COLLECTION;
    private final ConfigEntry<Object> DELTA_IMPORT_BATCH_SIZE_SCHEMA_INFERENCE;
    private final ConfigEntry<Object> DELTA_SAMPLE_ESTIMATOR_ENABLED;
    private final ConfigEntry<Object> DELTA_STATS_SKIPPING;
    private final ConfigEntry<Object> DELTA_LIMIT_PUSHDOWN_ENABLED;
    private final ConfigEntry<Object> DELTA_STATS_SKIPPING_LOCAL_CACHE_MAX_NUM_FILES;
    private final ConfigEntry<Object> DELTA_SNAPSHOT_ISOLATION;
    private final ConfigEntry<Object> DELTA_MAX_SNAPSHOT_LINEAGE_LENGTH;
    private final ConfigEntry<Object> DELTA_HISTORY_PAR_SEARCH_THRESHOLD;
    private final ConfigEntry<Object> DELTA_HISTORY_METRICS_ENABLED;
    private final ConfigEntry<Object> DELTA_VACUUM_RETENTION_CHECK_ENABLED;
    private final ConfigEntry<Object> DELTA_CHECKPOINT_PART_SIZE;
    private final ConfigEntry<Object> DELTA_SCHEMA_AUTO_MIGRATE;
    private final ConfigEntry<Object> DELTA_STATE_CORRUPTION_IS_FATAL;
    private final ConfigEntry<Object> DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT;
    private final ConfigEntry<Object> DELTA_ALTER_LOCATION_BYPASS_SCHEMA_CHECK;
    private final ConfigEntry<Object> DUMMY_FILE_MANAGER_NUM_OF_FILES;
    private final ConfigEntry<String> DUMMY_FILE_MANAGER_PREFIX;
    private final ConfigEntry<Object> MERGE_MAX_INSERT_COUNT;
    private final ConfigEntry<Object> MERGE_INSERT_ONLY_ENABLED;
    private final ConfigEntry<Object> MERGE_REPARTITION_BEFORE_WRITE;
    private final ConfigEntry<Object> MERGE_MATCHED_ONLY_ENABLED;

    static {
        new DeltaSQLConf$();
    }

    public ConfigBuilder buildConf(String key) {
        return SQLConf$.MODULE$.buildConf(new StringBuilder(23).append("spark.databricks.delta.").append(key).toString());
    }

    public ConfigBuilder buildStaticConf(String key) {
        return SQLConf$.MODULE$.buildStaticConf(new StringBuilder(23).append("spark.databricks.delta.").append(key).toString());
    }

    public ConfigEntry<Object> RESOLVE_TIME_TRAVEL_ON_IDENTIFIER() {
        return this.RESOLVE_TIME_TRAVEL_ON_IDENTIFIER;
    }

    public ConfigEntry<Object> DELTA_COMMIT_INFO_ENABLED() {
        return this.DELTA_COMMIT_INFO_ENABLED;
    }

    public OptionalConfigEntry<Object> DELTA_SNAPSHOT_PARTITIONS() {
        return this.DELTA_SNAPSHOT_PARTITIONS;
    }

    public ConfigEntry<Object> DELTA_PARTITION_COLUMN_CHECK_ENABLED() {
        return this.DELTA_PARTITION_COLUMN_CHECK_ENABLED;
    }

    public ConfigEntry<Object> DELTA_SCHEMA_ON_READ_CHECK_ENABLED() {
        return this.DELTA_SCHEMA_ON_READ_CHECK_ENABLED;
    }

    public ConfigEntry<Object> DELTA_COLLECT_STATS() {
        return this.DELTA_COLLECT_STATS;
    }

    public ConfigEntry<Object> DELTA_IMPORT_BATCH_SIZE_STATS_COLLECTION() {
        return this.DELTA_IMPORT_BATCH_SIZE_STATS_COLLECTION;
    }

    public ConfigEntry<Object> DELTA_IMPORT_BATCH_SIZE_SCHEMA_INFERENCE() {
        return this.DELTA_IMPORT_BATCH_SIZE_SCHEMA_INFERENCE;
    }

    public ConfigEntry<Object> DELTA_SAMPLE_ESTIMATOR_ENABLED() {
        return this.DELTA_SAMPLE_ESTIMATOR_ENABLED;
    }

    public ConfigEntry<Object> DELTA_STATS_SKIPPING() {
        return this.DELTA_STATS_SKIPPING;
    }

    public ConfigEntry<Object> DELTA_LIMIT_PUSHDOWN_ENABLED() {
        return this.DELTA_LIMIT_PUSHDOWN_ENABLED;
    }

    public ConfigEntry<Object> DELTA_STATS_SKIPPING_LOCAL_CACHE_MAX_NUM_FILES() {
        return this.DELTA_STATS_SKIPPING_LOCAL_CACHE_MAX_NUM_FILES;
    }

    public ConfigEntry<Object> DELTA_SNAPSHOT_ISOLATION() {
        return this.DELTA_SNAPSHOT_ISOLATION;
    }

    public ConfigEntry<Object> DELTA_MAX_SNAPSHOT_LINEAGE_LENGTH() {
        return this.DELTA_MAX_SNAPSHOT_LINEAGE_LENGTH;
    }

    public ConfigEntry<Object> DELTA_HISTORY_PAR_SEARCH_THRESHOLD() {
        return this.DELTA_HISTORY_PAR_SEARCH_THRESHOLD;
    }

    public ConfigEntry<Object> DELTA_HISTORY_METRICS_ENABLED() {
        return this.DELTA_HISTORY_METRICS_ENABLED;
    }

    public ConfigEntry<Object> DELTA_VACUUM_RETENTION_CHECK_ENABLED() {
        return this.DELTA_VACUUM_RETENTION_CHECK_ENABLED;
    }

    public ConfigEntry<Object> DELTA_CHECKPOINT_PART_SIZE() {
        return this.DELTA_CHECKPOINT_PART_SIZE;
    }

    public ConfigEntry<Object> DELTA_SCHEMA_AUTO_MIGRATE() {
        return this.DELTA_SCHEMA_AUTO_MIGRATE;
    }

    public ConfigEntry<Object> DELTA_STATE_CORRUPTION_IS_FATAL() {
        return this.DELTA_STATE_CORRUPTION_IS_FATAL;
    }

    public ConfigEntry<Object> DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT() {
        return this.DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT;
    }

    public ConfigEntry<Object> DELTA_ALTER_LOCATION_BYPASS_SCHEMA_CHECK() {
        return this.DELTA_ALTER_LOCATION_BYPASS_SCHEMA_CHECK;
    }

    public ConfigEntry<Object> DUMMY_FILE_MANAGER_NUM_OF_FILES() {
        return this.DUMMY_FILE_MANAGER_NUM_OF_FILES;
    }

    public ConfigEntry<String> DUMMY_FILE_MANAGER_PREFIX() {
        return this.DUMMY_FILE_MANAGER_PREFIX;
    }

    public ConfigEntry<Object> MERGE_MAX_INSERT_COUNT() {
        return this.MERGE_MAX_INSERT_COUNT;
    }

    public ConfigEntry<Object> MERGE_INSERT_ONLY_ENABLED() {
        return this.MERGE_INSERT_ONLY_ENABLED;
    }

    public ConfigEntry<Object> MERGE_REPARTITION_BEFORE_WRITE() {
        return this.MERGE_REPARTITION_BEFORE_WRITE;
    }

    public ConfigEntry<Object> MERGE_MATCHED_ONLY_ENABLED() {
        return this.MERGE_MATCHED_ONLY_ENABLED;
    }

    private DeltaSQLConf$() {
        MODULE$ = this;
        this.RESOLVE_TIME_TRAVEL_ON_IDENTIFIER = this.buildConf("timeTravel.resolveOnIdentifier.enabled").internal().doc("When true, we will try to resolve patterns as `@v123` in identifiers as time travel nodes.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_COMMIT_INFO_ENABLED = this.buildConf("commitInfo.enabled").doc("Whether to log commit information into the Delta log.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_SNAPSHOT_PARTITIONS = this.buildConf("snapshotPartitions").internal().doc("Number of partitions to use when building a Delta Lake snapshot.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)n -> n > 0, "Delta snapshot partition number must be positive.").createOptional();
        this.DELTA_PARTITION_COLUMN_CHECK_ENABLED = this.buildConf("partitionColumnValidity.enabled").internal().doc("Whether to check whether the partition column names have valid names, just like the data columns.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_SCHEMA_ON_READ_CHECK_ENABLED = this.buildConf("checkLatestSchemaOnRead").doc("In Delta, we always try to give users the latest version of their data without having to call REFRESH TABLE or redefine their DataFrames when used in the context of streaming. There is a possibility that the schema of the latest version of the table may be incompatible with the schema at the time of DataFrame creation. This flag enables a check that ensures that users won't read corrupt data if the source schema changes in an incompatible way.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_COLLECT_STATS = this.buildConf("stats.collect").internal().doc("When true, statistics are collected while writing files into a Delta table.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_IMPORT_BATCH_SIZE_STATS_COLLECTION = this.buildConf("import.batchSize.statsCollection").internal().doc("The number of files per batch for stats collection during import.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)50000));
        this.DELTA_IMPORT_BATCH_SIZE_SCHEMA_INFERENCE = this.buildConf("import.batchSize.schemaInference").internal().doc("The number of files per batch for schema inference during import.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000000));
        this.DELTA_SAMPLE_ESTIMATOR_ENABLED = this.buildConf("sampling.enabled").internal().doc("Enable sample based estimation.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DELTA_STATS_SKIPPING = this.buildConf("stats.skipping").internal().doc("When true, statistics are used for skipping").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_LIMIT_PUSHDOWN_ENABLED = this.buildConf("stats.limitPushdown.enabled").internal().doc("If true, use the limit clause and file statistics to prune files before they are collected to the driver. ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_STATS_SKIPPING_LOCAL_CACHE_MAX_NUM_FILES = this.buildConf("stats.localCache.maxNumFiles").internal().doc("The maximum number of files for a table to be considered a 'delta small table'.Some metadata operations (such as using data skipping) are optimized for small tables using driver local caching and local execution.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)2000));
        this.DELTA_SNAPSHOT_ISOLATION = this.buildConf("snapshotIsolation.enabled").internal().doc("Controls whether queries on Delta tables are guaranteed to have snapshot isolation.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_MAX_SNAPSHOT_LINEAGE_LENGTH = this.buildConf("maxSnapshotLineageLength").internal().doc("The max lineage length of a Snapshot before Delta forces to build a Snapshot from scratch.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$1 -> x$1 > 0, "maxSnapshotLineageLength must be positive.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)50));
        this.DELTA_HISTORY_PAR_SEARCH_THRESHOLD = this.buildConf("history.maxKeysPerList").internal().doc("How many commits to list when performing a parallel search. Currently set to 1000, which is the maximum keys returned by S3 per list call. Azure can return 5000, therefore we choose 1000.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.DELTA_HISTORY_METRICS_ENABLED = this.buildConf("history.metricsEnabled").doc("Enables Metrics reporting in Describe History. CommitInfo will now record the Operation Metrics.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_VACUUM_RETENTION_CHECK_ENABLED = this.buildConf("retentionDurationCheck.enabled").doc("Adds a check preventing users from running vacuum with a very short retention period, which may end up corrupting the Delta Log.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_CHECKPOINT_PART_SIZE = this.buildConf("checkpoint.partSize").internal().doc(new StringOps(Predef$.MODULE$.augmentString("The limit at which we will start parallelizing the checkpoint. We will attempt to write\n             |maximum of this many actions per checkpoint.\n        ")).stripMargin()).longConf().checkValue((Function1)(JFunction1.mcZJ.sp & java.io.Serializable & Serializable)x$2 -> x$2 > 0L, "The checkpoint part size needs to be a positive integer.").createWithDefault((Object)BoxesRunTime.boxToLong((long)5000000L));
        this.DELTA_SCHEMA_AUTO_MIGRATE = this.buildConf("schema.autoMerge.enabled").doc("If true, enables schema merging on appends and on overwrites.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DELTA_STATE_CORRUPTION_IS_FATAL = this.buildConf("state.corruptionIsFatal").internal().doc("If true, throws a fatal error when the recreated Delta State doesn't\n          |match committed checksum file.\n        ").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT = this.buildConf("stalenessLimit").doc(new StringOps(Predef$.MODULE$.augmentString("Setting a non-zero time limit will allow you to query the last loaded state of the Delta\n             |table without blocking on a table update. You can use this configuration to reduce the\n             |latency on queries when up-to-date results are not a requirement. Table updates will be\n             |scheduled on a separate scheduler pool in a FIFO queue, and will share cluster resources\n             |fairly with your query. If a table hasn't updated past this time limit, we will block\n             |on a synchronous state update before running the query.\n        ")).stripMargin()).timeConf(TimeUnit.MILLISECONDS).createWithDefault((Object)BoxesRunTime.boxToLong((long)0L));
        this.DELTA_ALTER_LOCATION_BYPASS_SCHEMA_CHECK = this.buildConf("alterLocation.bypassSchemaCheck").doc("If true, Alter Table Set Location on Delta will go through even if the Delta table in the new location has a different schema from the original Delta table.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DUMMY_FILE_MANAGER_NUM_OF_FILES = this.buildConf("dummyFileManager.numOfFiles").internal().doc("How many dummy files to write in DummyFileManager").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$3 -> x$3 >= 0, "numOfFiles can not be negative.").createWithDefault((Object)BoxesRunTime.boxToInteger((int)3));
        this.DUMMY_FILE_MANAGER_PREFIX = this.buildConf("dummyFileManager.prefix").internal().doc("The file prefix to use in DummyFileManager").stringConf().createWithDefault((Object)".s3-optimization-");
        this.MERGE_MAX_INSERT_COUNT = this.buildConf("merge.maxInsertCount").internal().doc("Max row count of inserts in each MERGE execution.").longConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)10000L));
        this.MERGE_INSERT_ONLY_ENABLED = this.buildConf("merge.optimizeInsertOnlyMerge.enabled").internal().doc(new StringOps(Predef$.MODULE$.augmentString("\n             |If enabled, merge without any matched clause (i.e., insert-only merge) will be optimized\n             |by avoiding rewriting old files and just inserting new files.\n        ")).stripMargin()).booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.MERGE_REPARTITION_BEFORE_WRITE = this.buildConf("merge.repartitionBeforeWrite.enabled").internal().doc(new StringOps(Predef$.MODULE$.augmentString("\n             |When enabled, merge will repartition the output by the table's partition columns before\n             |writing the files.\n        ")).stripMargin()).booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.MERGE_MATCHED_ONLY_ENABLED = this.buildConf("merge.optimizeMatchedOnlyMerge.enabled").internal().doc(new StringOps(Predef$.MODULE$.augmentString("If enabled, merge without 'when not matched' clause will be optimized to use a\n             |right outer join instead of a full outer join.\n        ")).stripMargin()).booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

