/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.master.web.controllers;

import it.agilelab.bigdata.wasp.core.SolrLoggerIndex$;
import it.agilelab.bigdata.wasp.core.SolrTelemetryIndexModel$;
import it.agilelab.bigdata.wasp.core.eventengine.eventproducers.SolrEventIndex$;
import it.agilelab.bigdata.wasp.master.web.controllers.CountSort$;
import it.agilelab.bigdata.wasp.master.web.controllers.PivotField;
import it.agilelab.bigdata.wasp.master.web.controllers.SolrClient;
import it.agilelab.bigdata.wasp.master.web.controllers.StatsService;
import it.agilelab.bigdata.wasp.models.CountEntry;
import it.agilelab.bigdata.wasp.models.Counts;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RangeFacet;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0007\u000f\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0006[!)1\u0007\u0001C\u0001i!9\u0011\b\u0001b\u0001\n\u0013Q\u0004BB\"\u0001A\u0003%1\bC\u0004E\u0001\t\u0007I\u0011\u0002\u001e\t\r\u0015\u0003\u0001\u0015!\u0003<\u0011\u00151\u0005\u0001\"\u0003H\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013Aq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002\u001c\u0001!\t%!\b\u0003/\u0011+g-Y;miN{GN]*uCR\u001c8+\u001a:wS\u000e,'BA\b\u0011\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u0005E\u0011\u0012aA<fE*\u00111\u0003F\u0001\u0007[\u0006\u001cH/\u001a:\u000b\u0005U1\u0012\u0001B<bgBT!a\u0006\r\u0002\u000f\tLw\rZ1uC*\u0011\u0011DG\u0001\tC\u001eLG.\u001a7bE*\t1$\u0001\u0002ji\u000e\u00011c\u0001\u0001\u001fIA\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\u0004\"!\n\u0014\u000e\u00039I!a\n\b\u0003\u0019M#\u0018\r^:TKJ4\u0018nY3\u0002\r\rd\u0017.\u001a8u!\t)#&\u0003\u0002,\u001d\tQ1k\u001c7s\u00072LWM\u001c;\u0002\u0005\u0015\u001c\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003e=\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\t)\u0004\b\u0006\u00027oA\u0011Q\u0005\u0001\u0005\u0006Y\r\u0001\u001d!\f\u0005\u0006Q\r\u0001\r!K\u0001\u0010)&kUi\u0015+B\u001bB{f)S#M\tV\t1\b\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005!A.\u00198h\u0015\u0005\u0001\u0015\u0001\u00026bm\u0006L!AQ\u001f\u0003\rM#(/\u001b8h\u0003A!\u0016*T#T)\u0006k\u0005k\u0018$J\u000b2#\u0005%A\u0002H\u0003B\u000bAaR!QA\u0005AQ.\u00199QSZ|G\u000fF\u0002I5*\u00042!S)U\u001d\tQuJ\u0004\u0002L\u001d6\tAJ\u0003\u0002N9\u00051AH]8pizJ\u0011!I\u0005\u0003!\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002S'\n\u00191+Z9\u000b\u0005A\u0003\u0003CA+Y\u001b\u00051&BA,\u0015\u0003\u0019iw\u000eZ3mg&\u0011\u0011L\u0016\u0002\u000b\u0007>,h\u000e^#oiJL\b\"B.\t\u0001\u0004a\u0016\u0001\u0003:fgB|gn]3\u0011\u0005uCW\"\u00010\u000b\u0005m{&B\u00011b\u0003\u0015\u0019x\u000e\u001c:k\u0015\tA#M\u0003\u0002dI\u0006!1o\u001c7s\u0015\t)g-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0006\u0019qN]4\n\u0005%t&!D)vKJL(+Z:q_:\u001cX\rC\u0003l\u0011\u0001\u0007A.\u0001\u0006gS\u0016dG\rU5w_R\u0004\"!J7\n\u00059t!A\u0003)jm>$h)[3mI\u0006yA/\u001a7f[\u0016$(/_\"pk:$8\u000f\u0006\u0003rirt\bc\u0001\u0018s\u0011&\u00111o\f\u0002\u0007\rV$XO]3\t\u000bUL\u0001\u0019\u0001<\u0002\u0013M$\u0018M\u001d;US6,\u0007CA<{\u001b\u0005A(BA=@\u0003\u0011!\u0018.\\3\n\u0005mD(aB%ogR\fg\u000e\u001e\u0005\u0006{&\u0001\rA^\u0001\bK:$G+[7f\u0011\u0019y\u0018\u00021\u0001\u0002\u0002\u0005)A.[7jiB\u0019q$a\u0001\n\u0007\u0005\u0015\u0001EA\u0002J]R\f1\"\u001a<f]R\u001cu.\u001e8ugR9\u0011/a\u0003\u0002\u000e\u0005=\u0001\"B;\u000b\u0001\u00041\b\"B?\u000b\u0001\u00041\bBB@\u000b\u0001\u0004\t\t!A\u0005m_\u001e\u001cu.\u001e8ugR9\u0011/!\u0006\u0002\u0018\u0005e\u0001\"B;\f\u0001\u00041\b\"B?\f\u0001\u00041\bBB@\f\u0001\u0004\t\t!\u0001\u0004d_VtGo\u001d\u000b\t\u0003?\t9#a\u000b\u00020A!aF]A\u0011!\r)\u00161E\u0005\u0004\u0003K1&AB\"pk:$8\u000f\u0003\u0004\u0002*1\u0001\rA^\u0001\u000fgR\f'\u000f\u001e+j[\u0016\u001cH/Y7q\u0011\u0019\ti\u0003\u0004a\u0001m\u0006aQM\u001c3US6,7\u000f^1na\"1q\u0010\u0004a\u0001\u0003\u0003\u0001")
public class DefaultSolrStatsService
implements StatsService {
    private final SolrClient client;
    private final ExecutionContext ec;
    private final String TIMESTAMP_FIELD;
    private final String GAP;

    private String TIMESTAMP_FIELD() {
        return this.TIMESTAMP_FIELD;
    }

    private String GAP() {
        return this.GAP;
    }

    private Seq<CountEntry> mapPivot(QueryResponse response, PivotField fieldPivot) {
        Map globalRange = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((RangeFacet)response.getFacetRanges().get(0)).getCounts()).asScala()).map((Function1 & Serializable & scala.Serializable)countEntry -> {
            Instant timestamp = Instant.parse(countEntry.getValue());
            int count = countEntry.getCount();
            return new Tuple2((Object)timestamp, (Object)BoxesRunTime.boxToInteger((int)count));
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map x = ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)response.getFacetPivot().get(fieldPivot.field())).asScala()).flatMap((Function1 & Serializable & scala.Serializable)fieldPivotEntry -> {
            RangeFacet range = (RangeFacet)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fieldPivotEntry.getFacetRanges()).asScala()).head();
            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(range.getCounts()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                Instant timestamp = Instant.parse(entry.getValue());
                int count = entry.getCount();
                String facetValue = (String)fieldPivotEntry.getValue();
                return new Tuple3((Object)facetValue, (Object)timestamp, (Object)BoxesRunTime.boxToInteger((int)count));
            }, Buffer$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Instant timestamp;
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Instant instant = timestamp = (Instant)tuple3._2();
            return instant;
        });
        Seq res = (Seq)x.mapValues((Function1 & Serializable & scala.Serializable)y -> ((TraversableOnce)y.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String facetValue = (String)tuple3._1();
            int count = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple2 tuple2 = new Tuple2((Object)facetValue, (Object)BoxesRunTime.boxToInteger((int)count));
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).toSeq().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Instant timestamp = (Instant)tuple2._1();
            Map data = (Map)tuple2._2();
            int others = BoxesRunTime.unboxToInt((Object)globalRange.apply((Object)timestamp)) - BoxesRunTime.unboxToInt((Object)data.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            CountEntry countEntry = new CountEntry(timestamp, data.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"_others_"), (Object)BoxesRunTime.boxToInteger((int)others))));
            return countEntry;
        }, Seq$.MODULE$.canBuildFrom());
        return res;
    }

    private Future<Seq<CountEntry>> telemetryCounts(Instant startTime, Instant endTime, int limit) {
        PivotField pivotField = new PivotField("sourceId", CountSort$.MODULE$, limit);
        return this.client.runRangeFacet(SolrTelemetryIndexModel$.MODULE$.apply().name(), this.TIMESTAMP_FIELD(), (Seq<PivotField>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PivotField[]{pivotField}))), startTime, endTime, this.GAP()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.mapPivot((QueryResponse)x$1, pivotField), this.ec);
    }

    private Future<Seq<CountEntry>> eventCounts(Instant startTime, Instant endTime, int limit) {
        PivotField pivotField = new PivotField("severity", CountSort$.MODULE$, limit);
        return this.client.runRangeFacet(SolrEventIndex$.MODULE$.apply().name(), this.TIMESTAMP_FIELD(), (Seq<PivotField>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PivotField[]{pivotField}))), startTime, endTime, this.GAP()).map((Function1 & Serializable & scala.Serializable)x$2 -> this.mapPivot((QueryResponse)x$2, pivotField), this.ec);
    }

    private Future<Seq<CountEntry>> logCounts(Instant startTime, Instant endTime, int limit) {
        PivotField pivotField = new PivotField("log_level", CountSort$.MODULE$, limit);
        return this.client.runRangeFacet(SolrLoggerIndex$.MODULE$.apply().name(), this.TIMESTAMP_FIELD(), (Seq<PivotField>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PivotField[]{pivotField}))), startTime, endTime, this.GAP()).map((Function1 & Serializable & scala.Serializable)x$3 -> this.mapPivot((QueryResponse)x$3, pivotField), this.ec);
    }

    @Override
    public Future<Counts> counts(Instant startTimestamp, Instant endTimestamp, int limit) {
        Future<Seq<CountEntry>> eventuallyTelemetry = this.telemetryCounts(startTimestamp, endTimestamp, limit);
        Future<Seq<CountEntry>> eventuallyLogs = this.logCounts(startTimestamp, endTimestamp, limit);
        Future<Seq<CountEntry>> eventuallyEvents = this.eventCounts(startTimestamp, endTimestamp, limit);
        return eventuallyTelemetry.flatMap((Function1 & Serializable & scala.Serializable)telemetry -> eventuallyLogs.flatMap((Function1 & Serializable & scala.Serializable)logs -> eventuallyEvents.map((Function1 & Serializable & scala.Serializable)events -> new Counts(logs, telemetry, events), $this.ec), $this.ec), this.ec);
    }

    public DefaultSolrStatsService(SolrClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
        this.TIMESTAMP_FIELD = "timestamp";
        this.GAP = "+1MINUTE";
    }
}

