/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.master.web.controllers;

import it.agilelab.bigdata.wasp.core.SolrTelemetryIndexModel$;
import it.agilelab.bigdata.wasp.master.web.controllers.SolrClient;
import it.agilelab.bigdata.wasp.master.web.controllers.TelemetryService;
import it.agilelab.bigdata.wasp.models.MetricEntry;
import it.agilelab.bigdata.wasp.models.Metrics;
import it.agilelab.bigdata.wasp.models.SourceEntry;
import it.agilelab.bigdata.wasp.models.Sources;
import it.agilelab.bigdata.wasp.models.TelemetryPoint;
import it.agilelab.bigdata.wasp.models.TelemetrySeries;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.util.NamedList;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0004\t\u0001]A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tM\u0001\u0011\t\u0011)A\u0006O!)Q\u0006\u0001C\u0001]!)1\u0007\u0001C!i!)\u0001\u000b\u0001C!#\")Q\f\u0001C!=\nYB)\u001a4bk2$8k\u001c7s)\u0016dW-\\3uef\u001cVM\u001d<jG\u0016T!!\u0003\u0006\u0002\u0017\r|g\u000e\u001e:pY2,'o\u001d\u0006\u0003\u00171\t1a^3c\u0015\tia\"\u0001\u0004nCN$XM\u001d\u0006\u0003\u001fA\tAa^1ta*\u0011\u0011CE\u0001\bE&<G-\u0019;b\u0015\t\u0019B#\u0001\u0005bO&dW\r\\1c\u0015\u0005)\u0012AA5u\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002\u0011%\u0011\u0011\u0005\u0003\u0002\u0011)\u0016dW-\\3uef\u001cVM\u001d<jG\u0016\f!b]8me\u000ec\u0017.\u001a8u!\tyB%\u0003\u0002&\u0011\tQ1k\u001c7s\u00072LWM\u001c;\u0002\u0005\u0015\u001c\u0007C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Y%\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\ty#\u0007\u0006\u00021cA\u0011q\u0004\u0001\u0005\u0006M\r\u0001\u001da\n\u0005\u0006E\r\u0001\raI\u0001\bg>,(oY3t)\r)dh\u0013\t\u0004QYB\u0014BA\u001c*\u0005\u00191U\u000f^;sKB\u0011\u0011\bP\u0007\u0002u)\u00111HD\u0001\u0007[>$W\r\\:\n\u0005uR$aB*pkJ\u001cWm\u001d\u0005\u0006\u007f\u0011\u0001\r\u0001Q\u0001\u0007g\u0016\f'o\u00195\u0011\u0005\u0005CeB\u0001\"G!\t\u0019%$D\u0001E\u0015\t)e#\u0001\u0004=e>|GOP\u0005\u0003\u000fj\ta\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011qI\u0007\u0005\u0006\u0019\u0012\u0001\r!T\u0001\u0005g&TX\r\u0005\u0002\u001a\u001d&\u0011qJ\u0007\u0002\u0004\u0013:$\u0018aB7fiJL7m\u001d\u000b\u0005%Z[F\fE\u0002)mM\u0003\"!\u000f+\n\u0005US$aB'fiJL7m\u001d\u0005\u0006/\u0016\u0001\r\u0001W\u0001\u0007g>,(oY3\u0011\u0005eJ\u0016B\u0001.;\u0005-\u0019v.\u001e:dK\u0016sGO]=\t\u000b}*\u0001\u0019\u0001!\t\u000b1+\u0001\u0019A'\u0002\rY\fG.^3t)\u001dy6-\u001a6um~\u00042\u0001\u000b\u001ca!\tI\u0014-\u0003\u0002cu\tyA+\u001a7f[\u0016$(/_*fe&,7\u000fC\u0003e\r\u0001\u0007\u0001,A\u0006t_V\u00148-Z#oiJL\b\"\u00024\u0007\u0001\u00049\u0017aC7fiJL7-\u00128uef\u0004\"!\u000f5\n\u0005%T$aC'fiJL7-\u00128uefDQa\u001b\u0004A\u00021\fab\u001d;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u0002ne6\taN\u0003\u0002pa\u0006!A/[7f\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d8\u0003\u000f%s7\u000f^1oi\")QO\u0002a\u0001Y\u0006aQM\u001c3US6,7\u000f^1na\")qO\u0002a\u0001q\u0006I\u0011mZ4sK\u001e\fG/\u001a\t\u0003srt!!\u000f>\n\u0005mT\u0014!C!hOJ,w-\u0019;f\u0013\tihPA\u0005BO\u001e\u0014XmZ1uK*\u00111P\u000f\u0005\u0006\u0019\u001a\u0001\r!\u0014")
public class DefaultSolrTelemetryService
implements TelemetryService {
    private final SolrClient solrClient;
    private final ExecutionContext ec;

    @Override
    public Future<Sources> sources(String search, int size) {
        return this.solrClient.runTermQuery(SolrTelemetryIndexModel$.MODULE$.apply().name(), "sourceId", "", search, size).map((Function1 & Serializable & scala.Serializable)response -> {
            java.util.List terms = response.getTermsResponse().getTerms("sourceId");
            return new Sources((long)terms.size(), (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(terms).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getTerm(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new SourceEntry(x), Buffer$.MODULE$.canBuildFrom()));
        }, this.ec);
    }

    @Override
    public Future<Metrics> metrics(SourceEntry source, String search, int size) {
        String regex = new StringBuilder(1).append(source.name()).append("|").append(search).toString();
        return this.solrClient.runTermQuery(SolrTelemetryIndexModel$.MODULE$.apply().name(), "metricSearchKey", source.name(), regex, size).map((Function1 & Serializable & scala.Serializable)response -> {
            java.util.List terms = response.getTermsResponse().getTerms("metricSearchKey");
            return new Metrics((long)terms.size(), (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(terms).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTerm().replaceAll(Pattern.quote(new StringBuilder(1).append(source.name()).append("|").toString()), ""), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new MetricEntry(source, x), Buffer$.MODULE$.canBuildFrom()));
        }, this.ec);
    }

    @Override
    public Future<TelemetrySeries> values(SourceEntry sourceEntry, MetricEntry metricEntry, Instant startTimestamp, Instant endTimestamp, Enumeration.Value aggregate, int size) {
        Duration increment = Duration.between(startTimestamp, endTimestamp).dividedBy(size);
        String metricKey = ClientUtils.escapeQueryChars((String)new StringBuilder(1).append(sourceEntry.name()).append("|").append(metricEntry.name()).toString());
        String predicate = new StringBuilder(16).append("metricSearchKey:").append(metricKey).toString();
        return this.solrClient.runBucketAggregation(SolrTelemetryIndexModel$.MODULE$.apply().name(), predicate, "timestamp", "value", aggregate.toString(), startTimestamp, endTimestamp, increment).map((Function1 & Serializable & scala.Serializable)response -> {
            Option maybeMaxValue = Option$.MODULE$.apply((Object)((NamedList)((NamedList)response.getResponse().get("facets")).get(new StringBuilder(6).append(aggregate.toString()).append("_value").toString())));
            Option maybeBucket = maybeMaxValue.map((Function1 & Serializable & scala.Serializable)x$3 -> (ArrayList)x$3.get("buckets"));
            List points = (List)maybeBucket.map((Function1 & Serializable & scala.Serializable)bucket -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)bucket).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                Instant timestamp = ((Date)entry.get("val")).toInstant();
                Double result = (Double)Option$.MODULE$.apply((Object)((Double)entry.get(aggregate.toString()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.double2Double(Double.NaN));
                return new TelemetryPoint(timestamp, Predef$.MODULE$.Double2double(result));
            }, Buffer$.MODULE$.canBuildFrom())).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
            return new TelemetrySeries(sourceEntry, metricEntry, (Seq)points);
        }, this.ec);
    }

    public DefaultSolrTelemetryService(SolrClient solrClient, ExecutionContext ec) {
        this.solrClient = solrClient;
        this.ec = ec;
    }
}

