/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.master.web.controllers;

import it.agilelab.bigdata.wasp.core.eventengine.eventproducers.SolrEventIndex$;
import it.agilelab.bigdata.wasp.master.web.controllers.EventsService;
import it.agilelab.bigdata.wasp.master.web.controllers.SolrClient;
import it.agilelab.bigdata.wasp.models.EventEntry;
import it.agilelab.bigdata.wasp.models.Events;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.util.ClientUtils;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0002\u0004\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015a\u0003&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\t\u0004\u0001\"\u00113\u0005a!UMZ1vYR\u001cv\u000e\u001c:Fm\u0016tGo]*feZL7-\u001a\u0006\u0003\u000f!\t1bY8oiJ|G\u000e\\3sg*\u0011\u0011BC\u0001\u0004o\u0016\u0014'BA\u0006\r\u0003\u0019i\u0017m\u001d;fe*\u0011QBD\u0001\u0005o\u0006\u001c\bO\u0003\u0002\u0010!\u00059!-[4eCR\f'BA\t\u0013\u0003!\tw-\u001b7fY\u0006\u0014'\"A\n\u0002\u0005%$8\u0001A\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001e=5\ta!\u0003\u0002 \r\tiQI^3oiN\u001cVM\u001d<jG\u0016\faa\u00197jK:$\bCA\u000f#\u0013\t\u0019cA\u0001\u0006T_2\u00148\t\\5f]R\f!!Z2\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!B\u0012AC2p]\u000e,(O]3oi&\u0011!f\n\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDCA\u00171)\tqs\u0006\u0005\u0002\u001e\u0001!)Ae\u0001a\u0002K!)\u0001e\u0001a\u0001C\u00051QM^3oiN$ba\r\u001fJ'VS\u0006c\u0001\u00145m%\u0011Qg\n\u0002\u0007\rV$XO]3\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0011AB7pI\u0016d7/\u0003\u0002<q\t1QI^3oiNDQ!\u0010\u0003A\u0002y\naa]3be\u000eD\u0007CA G\u001d\t\u0001E\t\u0005\u0002B15\t!I\u0003\u0002D)\u00051AH]8pizJ!!\u0012\r\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bbAQA\u0013\u0003A\u0002-\u000bab\u001d;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u0006!A/[7f\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\u000f%s7\u000f^1oi\")A\u000b\u0002a\u0001\u0017\u0006aQM\u001c3US6,7\u000f^1na\")a\u000b\u0002a\u0001/\u0006!\u0001/Y4f!\t9\u0002,\u0003\u0002Z1\t\u0019\u0011J\u001c;\t\u000bm#\u0001\u0019A,\u0002\tML'0\u001a")
public class DefaultSolrEventsService
implements EventsService {
    private final SolrClient client;
    private final ExecutionContext ec;

    @Override
    public Future<Events> events(String search, Instant startTimestamp, Instant endTimestamp, int page, int size) {
        String stringQuery = search.trim().isEmpty() ? "*" : ClientUtils.escapeQueryChars((String)search);
        String query = new StringBuilder(25).append("timestamp:[").append(startTimestamp.toString()).append(" TO ").append(endTimestamp.toString()).append("]").append(" AND all:").append(stringQuery).toString();
        return this.client.runPredicate(SolrEventIndex$.MODULE$.apply().name(), query, size, page).map((Function1 & java.io.Serializable & Serializable)response -> {
            long found = response.getResults().getNumFound();
            return new Events(found, (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)response.getResults()).asScala()).toList().map((Function1 & java.io.Serializable & Serializable)document -> new EventEntry((String)document.getFieldValue("eventType"), (String)document.getFieldValue("eventId"), (String)document.getFieldValue("severity"), (String)document.getFieldValue("payload"), ((Date)document.getFieldValue("timestamp")).toInstant(), (String)document.getFieldValue("source"), (String)document.getFieldValue("sourceId"), (String)document.getFieldValue("eventRuleName")), List$.MODULE$.canBuildFrom()));
        }, this.ec);
    }

    public DefaultSolrEventsService(SolrClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
    }
}

