/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.master.web.controllers;

import it.agilelab.bigdata.wasp.core.SolrLoggerIndex$;
import it.agilelab.bigdata.wasp.master.web.controllers.LogsService;
import it.agilelab.bigdata.wasp.master.web.controllers.SolrClient;
import it.agilelab.bigdata.wasp.models.LogEntry;
import it.agilelab.bigdata.wasp.models.Logs;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.util.ClientUtils;
import scala.Function1;
import scala.Option$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0002\u0004\u0001+!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015a\u0003&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015\t\u0004\u0001\"\u00113\u0005Y!UMZ1vYR\u001cv\u000e\u001c:M_\u001e\u001c8+\u001a:wS\u000e,'BA\u0004\t\u0003-\u0019wN\u001c;s_2dWM]:\u000b\u0005%Q\u0011aA<fE*\u00111\u0002D\u0001\u0007[\u0006\u001cH/\u001a:\u000b\u00055q\u0011\u0001B<bgBT!a\u0004\t\u0002\u000f\tLw\rZ1uC*\u0011\u0011CE\u0001\tC\u001eLG.\u001a7bE*\t1#\u0001\u0002ji\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0010\u000e\u0003\u0019I!a\b\u0004\u0003\u00171{wm]*feZL7-Z\u0001\u0007G2LWM\u001c;\u0011\u0005u\u0011\u0013BA\u0012\u0007\u0005)\u0019v\u000e\u001c:DY&,g\u000e^\u0001\u0003K\u000e\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\r\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002+O\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055\u0002DC\u0001\u00180!\ti\u0002\u0001C\u0003%\u0007\u0001\u000fQ\u0005C\u0003!\u0007\u0001\u0007\u0011%\u0001\u0003m_\u001e\u001cHCB\u001a=\u0013N+&\fE\u0002'iYJ!!N\u0014\u0003\r\u0019+H/\u001e:f!\t9$(D\u00019\u0015\tID\"\u0001\u0004n_\u0012,Gn]\u0005\u0003wa\u0012A\u0001T8hg\")Q\b\u0002a\u0001}\u000511/Z1sG\"\u0004\"a\u0010$\u000f\u0005\u0001#\u0005CA!\u0019\u001b\u0005\u0011%BA\"\u0015\u0003\u0019a$o\\8u}%\u0011Q\tG\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F1!)!\n\u0002a\u0001\u0017\u0006q1\u000f^1siRKW.Z:uC6\u0004\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011!\u0018.\\3\u000b\u0003A\u000bAA[1wC&\u0011!+\u0014\u0002\b\u0013:\u001cH/\u00198u\u0011\u0015!F\u00011\u0001L\u00031)g\u000e\u001a+j[\u0016\u001cH/Y7q\u0011\u00151F\u00011\u0001X\u0003\u0011\u0001\u0018mZ3\u0011\u0005]A\u0016BA-\u0019\u0005\rIe\u000e\u001e\u0005\u00067\u0012\u0001\raV\u0001\u0005g&TX\r")
public class DefaultSolrLogsService
implements LogsService {
    private final SolrClient client;
    private final ExecutionContext ec;

    @Override
    public Future<Logs> logs(String search, Instant startTimestamp, Instant endTimestamp, int page, int size) {
        String stringQuery = search.trim().isEmpty() ? "*" : ClientUtils.escapeQueryChars((String)search);
        String query = new StringBuilder(25).append("timestamp:[").append(startTimestamp.toString()).append(" TO ").append(endTimestamp.toString()).append("]").append(" AND all:").append(stringQuery).toString();
        return this.client.runPredicate(SolrLoggerIndex$.MODULE$.apply().name(), query, size, page).map((Function1 & Serializable & scala.Serializable)response -> {
            long found = response.getResults().getNumFound();
            return new Logs(found, (Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)response.getResults()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)document -> new LogEntry((String)document.getFieldValue("log_source"), (String)document.getFieldValue("log_level"), (String)document.getFieldValue("message"), ((Date)document.getFieldValue("timestamp")).toInstant(), (String)document.getFieldValue("thread"), Option$.MODULE$.apply((Object)((String)document.getFieldValue("cause"))), Option$.MODULE$.apply((Object)((String)document.getFieldValue("stack_trace")))), List$.MODULE$.canBuildFrom()));
        }, this.ec);
    }

    public DefaultSolrLogsService(SolrClient client, ExecutionContext ec) {
        this.client = client;
        this.ec = ec;
    }
}

