package it.agilelab.bigdata.wasp.models.configuration

import it.agilelab.bigdata.wasp.models.Model
import it.agilelab.bigdata.wasp.models.configuration.KafkaConfigProxy.MainKafkaClusterName

case class KafkaConfigModel(connections: Seq[ConnectionConfig],
														ingest_rate: String,
														zookeeperConnections: Option[ZookeeperConnectionsConfig],
														broker_id: String,
														partitioner_fqcn: String,
														default_encoder: String,
														key_encoder_fqcn: String,
														encoder_fqcn: String,
														decoder_fqcn: String,
														batch_send_size: Int,
														acks: String,
														others: Seq[KafkaEntryConfig],
														name: String
                           ) extends Model {

	def toTinyConfig() = TinyKafkaConfig(connections, batch_send_size, acks, default_encoder, encoder_fqcn, partitioner_fqcn, others)

	def ingestRateToMills() = {
		val defaultIngestRate = 1000
		try {
			this.ingest_rate.replace("s", "").toInt * defaultIngestRate
		} catch {
			case _ : Throwable => defaultIngestRate
		}
	}
}

case class TinyKafkaConfig(
														connections: Seq[ConnectionConfig],
														batch_send_size: Int,
														acks: String,
														default_encoder: String,
														encoder_fqcn: String,
														partitioner_fqcn: String,
														others: Seq[KafkaEntryConfig])

case class KafkaEntryConfig(
														 key: String,
														 value: String
													 ) {
	def toTupla = (key, value)
}


case class AdditionalKafkaClustersConfig(name: String, clusters: Map[String, KafkaConfigModel]) extends Model

class KafkaConfigProxy(kafkaConfigModel: KafkaConfigModel, additionalClusters: Map[String, KafkaConfigModel]) {
  def getDefaultKafka: KafkaConfigModel = kafkaConfigModel

  def getByName(name: String): Option[KafkaConfigModel] = {
    if (name == MainKafkaClusterName)
      Some(getDefaultKafka)
    else
      additionalClusters.get(name)
  }

  def resolve(clusterAlias: Option[String]): KafkaConfigModel = clusterAlias match {
    case Some(alias) => additionalClusters.getOrElse(alias,
      throw new Exception(s"Could not found cluster alias $alias in list of known clusters: ${additionalClusters.keys.mkString(",")}")
    )
    case None => getDefaultKafka
  }

  def getAll: Seq[KafkaConfigModel] = Seq(getDefaultKafka) ++ additionalClusters.values

  def getMap: Map[String, KafkaConfigModel] = Map(MainKafkaClusterName -> getDefaultKafka) ++ additionalClusters
}

object KafkaConfigProxy {
  val MainKafkaClusterName = "main_kafka_cluster"

  def apply(kafkaConfigModel: KafkaConfigModel, additionalClusters: Map[String, KafkaConfigModel]) = new KafkaConfigProxy(kafkaConfigModel, additionalClusters)
}