/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{BulletinEntity, ClusterEntity, ControllerConfigurationEntity, ControllerServiceEntity, HistoryEntity, NodeEntity, RegistryClientEntity, RegistryClientsEntity, ReportingTaskEntity}
import sttp.client._
import sttp.model.Method

object ControllerApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ControllerApi(baseUrl)
}

class ControllerApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Expected answers:
   *   code 200 : BulletinEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The reporting task configuration details.
   */
  def createBulletin(body: BulletinEntity): ApiRequestT[BulletinEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/controller/bulletin")
      .contentType("application/json")
      .body(body)
      .response(asJson[BulletinEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The controller service configuration details.
   */
  def createControllerService(body: ControllerServiceEntity): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/controller/controller-services")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerServiceEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The registry configuration details.
   */
  def createRegistryClient(body: RegistryClientEntity): ApiRequestT[RegistryClientEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/controller/registry-clients")
      .contentType("application/json")
      .body(body)
      .response(asJson[RegistryClientEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTaskEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The reporting task configuration details.
   */
  def createReportingTask(body: ReportingTaskEntity): ApiRequestT[ReportingTaskEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/controller/reporting-tasks")
      .contentType("application/json")
      .body(body)
      .response(asJson[ReportingTaskEntity])

  /**
   * Expected answers:
   *   code 200 : HistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param endDate Purge actions before this date/time.
   */
  def deleteHistory(endDate: String): ApiRequestT[HistoryEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/controller/history?endDate=$endDate")
      .contentType("application/json")
      .response(asJson[HistoryEntity])

  /**
   * Expected answers:
   *   code 200 : NodeEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The node id.
   */
  def deleteNode(id: String): ApiRequestT[NodeEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/controller/cluster/nodes/${id}")
      .contentType("application/json")
      .response(asJson[NodeEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The registry id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteRegistryClient(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[RegistryClientEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/controller/registry-clients/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[RegistryClientEntity])

  /**
   * Returns the contents of the cluster including all nodes and their status.
   * 
   * Expected answers:
   *   code 200 : ClusterEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getCluster(): ApiRequestT[ClusterEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller/cluster")
      .contentType("application/json")
      .response(asJson[ClusterEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerConfigurationEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getControllerConfig(): ApiRequestT[ControllerConfigurationEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller/config")
      .contentType("application/json")
      .response(asJson[ControllerConfigurationEntity])

  /**
   * Expected answers:
   *   code 200 : NodeEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The node id.
   */
  def getNode(id: String): ApiRequestT[NodeEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller/cluster/nodes/${id}")
      .contentType("application/json")
      .response(asJson[NodeEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The registry id.
   */
  def getRegistryClient(id: String): ApiRequestT[RegistryClientEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller/registry-clients/${id}")
      .contentType("application/json")
      .response(asJson[RegistryClientEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getRegistryClients(): ApiRequestT[RegistryClientsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller/registry-clients")
      .contentType("application/json")
      .response(asJson[RegistryClientsEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerConfigurationEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The controller configuration.
   */
  def updateControllerConfig(body: ControllerConfigurationEntity): ApiRequestT[ControllerConfigurationEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller/config")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerConfigurationEntity])

  /**
   * Expected answers:
   *   code 200 : NodeEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The node id.
   * @param body The node configuration. The only configuration that will be honored at this endpoint is the status.
   */
  def updateNode(id: String, body: NodeEntity): ApiRequestT[NodeEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller/cluster/nodes/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[NodeEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The registry id.
   * @param body The registry configuration details.
   */
  def updateRegistryClient(id: String, body: RegistryClientEntity): ApiRequestT[RegistryClientEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller/registry-clients/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[RegistryClientEntity])

}

