/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{DropRequestEntity, FlowFileEntity, ListingRequestEntity}
import sttp.client._
import sttp.model.Method

object FlowfileQueuesApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new FlowfileQueuesApi(baseUrl)
}

class FlowfileQueuesApi(baseUrl: String)(implicit serializer: SttpSerializer) {
  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : DropRequestEntity (successful operation)
   *   code 202 :  (The request has been accepted. A HTTP response header will contain the URI where the response can be polled.)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   */
  def createDropRequest(id: String): ApiRequestT[DropRequestEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/flowfile-queues/${id}/drop-requests")
      .contentType("application/json")
      .response(asJson[DropRequestEntity])

  /**
   * Expected answers:
   *   code 200 : ListingRequestEntity (successful operation)
   *   code 202 :  (The request has been accepted. A HTTP response header will contain the URI where the response can be polled.)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   */
  def createFlowFileListing(id: String): ApiRequestT[ListingRequestEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/flowfile-queues/${id}/listing-requests")
      .contentType("application/json")
      .response(asJson[ListingRequestEntity])

  /**
   * Expected answers:
   *   code 200 : ListingRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param listingRequestId The listing request id.
   */
  def deleteListingRequest(id: String, listingRequestId: String): ApiRequestT[ListingRequestEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/flowfile-queues/${id}/listing-requests/${listingRequestId}")
      .contentType("application/json")
      .response(asJson[ListingRequestEntity])

  /**
   * Expected answers:
   *   code 200 : Any (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param flowfileUuid The flowfile uuid.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param clusterNodeId The id of the node where the content exists if clustered.
   */
  def downloadFlowFileContent(id: String, flowfileUuid: String, clientId: Option[String] = None, clusterNodeId: Option[String] = None): ApiRequestT[Any] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flowfile-queues/${id}/flowfiles/${flowfileUuid}/content?clientId=$clientId&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[Any])

  /**
   * Expected answers:
   *   code 200 : DropRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param dropRequestId The drop request id.
   */
  def getDropRequest(id: String, dropRequestId: String): ApiRequestT[DropRequestEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flowfile-queues/${id}/drop-requests/${dropRequestId}")
      .contentType("application/json")
      .response(asJson[DropRequestEntity])

  /**
   * Expected answers:
   *   code 200 : FlowFileEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param flowfileUuid The flowfile uuid.
   * @param clusterNodeId The id of the node where the content exists if clustered.
   */
  def getFlowFile(id: String, flowfileUuid: String, clusterNodeId: Option[String] = None): ApiRequestT[FlowFileEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flowfile-queues/${id}/flowfiles/${flowfileUuid}?clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[FlowFileEntity])

  /**
   * Expected answers:
   *   code 200 : ListingRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param listingRequestId The listing request id.
   */
  def getListingRequest(id: String, listingRequestId: String): ApiRequestT[ListingRequestEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flowfile-queues/${id}/listing-requests/${listingRequestId}")
      .contentType("application/json")
      .response(asJson[ListingRequestEntity])

  /**
   * Expected answers:
   *   code 200 : DropRequestEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param dropRequestId The drop request id.
   */
  def removeDropRequest(id: String, dropRequestId: String): ApiRequestT[DropRequestEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/flowfile-queues/${id}/drop-requests/${dropRequestId}")
      .contentType("application/json")
      .response(asJson[DropRequestEntity])

}

