/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{ProvenanceEventEntity, SubmitReplayRequestEntity}
import sttp.client._
import sttp.model.Method

object ProvenanceEventsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ProvenanceEventsApi(baseUrl)
}

class ProvenanceEventsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : Any (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The provenance event id.
   * @param clusterNodeId The id of the node where the content exists if clustered.
   */
  def getInputContent(id: String, clusterNodeId: Option[String] = None): ApiRequestT[Any] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/provenance-events/${id}/content/input?clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[Any])

  /**
   * Expected answers:
   *   code 200 : Any (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The provenance event id.
   * @param clusterNodeId The id of the node where the content exists if clustered.
   */
  def getOutputContent(id: String, clusterNodeId: Option[String] = None): ApiRequestT[Any] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/provenance-events/${id}/content/output?clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[Any])

  /**
   * Expected answers:
   *   code 200 : ProvenanceEventEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The provenance event id.
   * @param clusterNodeId The id of the node where this event exists if clustered.
   */
  def getProvenanceEvent(id: String, clusterNodeId: Option[String] = None): ApiRequestT[ProvenanceEventEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/provenance-events/${id}?clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[ProvenanceEventEntity])

  /**
   * Expected answers:
   *   code 200 : ProvenanceEventEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The replay request.
   */
  def submitReplay(body: SubmitReplayRequestEntity): ApiRequestT[ProvenanceEventEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/provenance-events/replays")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProvenanceEventEntity])

}

