/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.SnippetEntity
import sttp.client._
import sttp.model.Method

object SnippetsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new SnippetsApi(baseUrl)
}

class SnippetsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Expected answers:
   *   code 200 : SnippetEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The snippet configuration details.
   */
  def createSnippet(body: SnippetEntity): ApiRequestT[SnippetEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/snippets")
      .contentType("application/json")
      .body(body)
      .response(asJson[SnippetEntity])

  /**
   * Expected answers:
   *   code 200 : SnippetEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The snippet id.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def deleteSnippet(id: String, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[SnippetEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/snippets/${id}?disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[SnippetEntity])

  /**
   * Expected answers:
   *   code 200 : SnippetEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The snippet id.
   * @param body The snippet configuration details.
   */
  def updateSnippet(id: String, body: SnippetEntity): ApiRequestT[SnippetEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/snippets/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[SnippetEntity])

}

