/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ComponentValidationResultDTO(
  /* The UUID of the Process Group that this component is in */
  processGroupId: Option[String] = None,
  /* The UUID of this component */
  id: Option[String] = None,
  /* The type of this component */
  referenceType: Option[ComponentValidationResultDTOEnums.ReferenceType] = None,
  /* The name of this component. */
  name: Option[String] = None,
  /* The scheduled state of a processor or reporting task referencing a controller service. If this component is another controller service, this field represents the controller service state. */
  state: Option[String] = None,
  /* The number of active threads for the referencing component. */
  activeThreadCount: Option[Int] = None,
  /* The validation errors for the component. */
  validationErrors: Option[Seq[String]] = None,
  /* Whether or not the component is currently valid */
  currentlyValid: Option[Boolean] = None,
  /* Whether or not the component will be valid if the Parameter Context is changed */
  resultsValid: Option[Boolean] = None,
  /* The validation errors that will apply to the component if the Parameter Context is changed */
  resultantValidationErrors: Option[Seq[String]] = None
) extends ApiModel

object ComponentValidationResultDTOEnums {

  type ReferenceType = ReferenceType.Value
  object ReferenceType extends Enumeration {
    val PROCESSOR = Value("PROCESSOR")
    val CONTROLLERSERVICE = Value("CONTROLLER_SERVICE")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
  }

}

