/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ConnectionEntity(
  revision: Option[RevisionDTO] = None,
  /* The id of the component. */
  id: Option[String] = None,
  /* The URI for futures requests to the component. */
  uri: Option[String] = None,
  position: Option[PositionDTO] = None,
  permissions: Option[PermissionsDTO] = None,
  /* The bulletins for this component. */
  bulletins: Option[Seq[BulletinEntity]] = None,
  /* Acknowledges that this node is disconnected to allow for mutable requests to proceed. */
  disconnectedNodeAcknowledged: Option[Boolean] = None,
  component: Option[ConnectionDTO] = None,
  status: Option[ConnectionStatusDTO] = None,
  /* The bend points on the connection. */
  bends: Option[Seq[PositionDTO]] = None,
  /* The index of the bend point where to place the connection label. */
  labelIndex: Option[Int] = None,
  /* The z index of the connection. */
  getzIndex: Option[Long] = None,
  /* The identifier of the source of this connection. */
  sourceId: Option[String] = None,
  /* The identifier of the group of the source of this connection. */
  sourceGroupId: Option[String] = None,
  /* The type of component the source connectable is. */
  sourceType: ConnectionEntityEnums.SourceType,
  /* The identifier of the destination of this connection. */
  destinationId: Option[String] = None,
  /* The identifier of the group of the destination of this connection. */
  destinationGroupId: Option[String] = None,
  /* The type of component the destination connectable is. */
  destinationType: ConnectionEntityEnums.DestinationType
) extends ApiModel

object ConnectionEntityEnums {

  type SourceType = SourceType.Value
  type DestinationType = DestinationType.Value
  object SourceType extends Enumeration {
    val PROCESSOR = Value("PROCESSOR")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
  }

  object DestinationType extends Enumeration {
    val PROCESSOR = Value("PROCESSOR")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
  }

}

