/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ConnectionStatusSnapshotDTO(
  /* The id of the connection. */
  id: Option[String] = None,
  /* The id of the process group the connection belongs to. */
  groupId: Option[String] = None,
  /* The name of the connection. */
  name: Option[String] = None,
  /* The id of the source of the connection. */
  sourceId: Option[String] = None,
  /* The name of the source of the connection. */
  sourceName: Option[String] = None,
  /* The id of the destination of the connection. */
  destinationId: Option[String] = None,
  /* The name of the destination of the connection. */
  destinationName: Option[String] = None,
  predictions: Option[ConnectionStatusPredictionsSnapshotDTO] = None,
  /* The number of FlowFiles that have come into the connection in the last 5 minutes. */
  flowFilesIn: Option[Int] = None,
  /* The size of the FlowFiles that have come into the connection in the last 5 minutes. */
  bytesIn: Option[Long] = None,
  /* The input count/size for the connection in the last 5 minutes, pretty printed. */
  input: Option[String] = None,
  /* The number of FlowFiles that have left the connection in the last 5 minutes. */
  flowFilesOut: Option[Int] = None,
  /* The number of bytes that have left the connection in the last 5 minutes. */
  bytesOut: Option[Long] = None,
  /* The output count/sie for the connection in the last 5 minutes, pretty printed. */
  output: Option[String] = None,
  /* The number of FlowFiles that are currently queued in the connection. */
  flowFilesQueued: Option[Int] = None,
  /* The size of the FlowFiles that are currently queued in the connection. */
  bytesQueued: Option[Long] = None,
  /* The total count and size of queued flowfiles formatted. */
  queued: Option[String] = None,
  /* The total size of flowfiles that are queued formatted. */
  queuedSize: Option[String] = None,
  /* The number of flowfiles that are queued, pretty printed. */
  queuedCount: Option[String] = None,
  /* Connection percent use regarding queued flow files count and backpressure threshold if configured. */
  percentUseCount: Option[Int] = None,
  /* Connection percent use regarding queued flow files size and backpressure threshold if configured. */
  percentUseBytes: Option[Int] = None
) extends ApiModel


