/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class FlowFileDTO(
  /* The URI that can be used to access this FlowFile. */
  uri: Option[String] = None,
  /* The FlowFile UUID. */
  uuid: Option[String] = None,
  /* The FlowFile filename. */
  filename: Option[String] = None,
  /* The FlowFile's position in the queue. */
  position: Option[Int] = None,
  /* The FlowFile file size. */
  size: Option[Long] = None,
  /* How long this FlowFile has been enqueued. */
  queuedDuration: Option[Long] = None,
  /* Duration since the FlowFile's greatest ancestor entered the flow. */
  lineageDuration: Option[Long] = None,
  /* How long in milliseconds until the FlowFile penalty expires. */
  penaltyExpiresIn: Option[Long] = None,
  /* The id of the node where this FlowFile resides. */
  clusterNodeId: Option[String] = None,
  /* The label for the node where this FlowFile resides. */
  clusterNodeAddress: Option[String] = None,
  /* The FlowFile attributes. */
  attributes: Option[Map[String, String]] = None,
  /* The section in which the content claim lives. */
  contentClaimSection: Option[String] = None,
  /* The container in which the content claim lives. */
  contentClaimContainer: Option[String] = None,
  /* The identifier of the content claim. */
  contentClaimIdentifier: Option[String] = None,
  /* The offset into the content claim where the flowfile's content begins. */
  contentClaimOffset: Option[Long] = None,
  /* The file size of the content claim formatted. */
  contentClaimFileSize: Option[String] = None,
  /* The file size of the content claim in bytes. */
  contentClaimFileSizeBytes: Option[Long] = None,
  /* If the FlowFile is penalized. */
  penalized: Option[Boolean] = None
) extends ApiModel


