/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class PortStatusSnapshotDTO(
  /* The id of the port. */
  id: Option[String] = None,
  /* The id of the parent process group of the port. */
  groupId: Option[String] = None,
  /* The name of the port. */
  name: Option[String] = None,
  /* The active thread count for the port. */
  activeThreadCount: Option[Int] = None,
  /* The number of FlowFiles that have been accepted in the last 5 minutes. */
  flowFilesIn: Option[Int] = None,
  /* The size of hte FlowFiles that have been accepted in the last 5 minutes. */
  bytesIn: Option[Long] = None,
  /* The count/size of flowfiles that have been accepted in the last 5 minutes. */
  input: Option[String] = None,
  /* The number of FlowFiles that have been processed in the last 5 minutes. */
  flowFilesOut: Option[Int] = None,
  /* The number of bytes that have been processed in the last 5 minutes. */
  bytesOut: Option[Long] = None,
  /* The count/size of flowfiles that have been processed in the last 5 minutes. */
  output: Option[String] = None,
  /* Whether the port has incoming or outgoing connections to a remote NiFi. */
  transmitting: Option[Boolean] = None,
  /* The run status of the port. */
  runStatus: Option[PortStatusSnapshotDTOEnums.RunStatus] = None
) extends ApiModel

object PortStatusSnapshotDTOEnums {

  type RunStatus = RunStatus.Value
  object RunStatus extends Enumeration {
    val Running = Value("Running")
    val Stopped = Value("Stopped")
    val Validating = Value("Validating")
    val Disabled = Value("Disabled")
    val Invalid = Value("Invalid")
  }

}

