/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessorStatusDTO(
  /* The unique ID of the process group that the Processor belongs to */
  groupId: Option[String] = None,
  /* The unique ID of the Processor */
  id: Option[String] = None,
  /* The name of the Processor */
  name: Option[String] = None,
  /* The type of the Processor */
  `type`: Option[String] = None,
  /* The run status of the Processor */
  runStatus: Option[ProcessorStatusDTOEnums.RunStatus] = None,
  /* The timestamp of when the stats were last refreshed */
  statsLastRefreshed: Option[String] = None,
  aggregateSnapshot: Option[ProcessorStatusSnapshotDTO] = None,
  /* A status snapshot for each node in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this may be null. */
  nodeSnapshots: Option[Seq[NodeProcessorStatusSnapshotDTO]] = None
) extends ApiModel

object ProcessorStatusDTOEnums {

  type RunStatus = RunStatus.Value
  object RunStatus extends Enumeration {
    val Running = Value("Running")
    val Stopped = Value("Stopped")
    val Validating = Value("Validating")
    val Disabled = Value("Disabled")
    val Invalid = Value("Invalid")
  }

}

