/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ProcessorStatusSnapshotDTO(
  /* The id of the processor. */
  id: Option[String] = None,
  /* The id of the parent process group to which the processor belongs. */
  groupId: Option[String] = None,
  /* The name of the prcessor. */
  name: Option[String] = None,
  /* The type of the processor. */
  `type`: Option[String] = None,
  /* The state of the processor. */
  runStatus: Option[ProcessorStatusSnapshotDTOEnums.RunStatus] = None,
  /* Indicates the node where the process will execute. */
  executionNode: Option[ProcessorStatusSnapshotDTOEnums.ExecutionNode] = None,
  /* The number of bytes read by this Processor in the last 5 mintues */
  bytesRead: Option[Long] = None,
  /* The number of bytes written by this Processor in the last 5 minutes */
  bytesWritten: Option[Long] = None,
  /* The number of bytes read in the last 5 minutes. */
  read: Option[String] = None,
  /* The number of bytes written in the last 5 minutes. */
  written: Option[String] = None,
  /* The number of FlowFiles that have been accepted in the last 5 minutes */
  flowFilesIn: Option[Int] = None,
  /* The size of the FlowFiles that have been accepted in the last 5 minutes */
  bytesIn: Option[Long] = None,
  /* The count/size of flowfiles that have been accepted in the last 5 minutes. */
  input: Option[String] = None,
  /* The number of FlowFiles transferred to a Connection in the last 5 minutes */
  flowFilesOut: Option[Int] = None,
  /* The size of the FlowFiles transferred to a Connection in the last 5 minutes */
  bytesOut: Option[Long] = None,
  /* The count/size of flowfiles that have been processed in the last 5 minutes. */
  output: Option[String] = None,
  /* The number of times this Processor has run in the last 5 minutes */
  taskCount: Option[Int] = None,
  /* The number of nanoseconds that this Processor has spent running in the last 5 minutes */
  tasksDurationNanos: Option[Long] = None,
  /* The total number of task this connectable has completed over the last 5 minutes. */
  tasks: Option[String] = None,
  /* The total duration of all tasks for this connectable over the last 5 minutes. */
  tasksDuration: Option[String] = None,
  /* The number of threads currently executing in the processor. */
  activeThreadCount: Option[Int] = None,
  /* The number of threads currently terminated for the processor. */
  terminatedThreadCount: Option[Int] = None
) extends ApiModel

object ProcessorStatusSnapshotDTOEnums {

  type RunStatus = RunStatus.Value
  type ExecutionNode = ExecutionNode.Value
  object RunStatus extends Enumeration {
    val Running = Value("Running")
    val Stopped = Value("Stopped")
    val Validating = Value("Validating")
    val Disabled = Value("Disabled")
    val Invalid = Value("Invalid")
  }

  object ExecutionNode extends Enumeration {
    val ALL = Value("ALL")
    val PRIMARY = Value("PRIMARY")
  }

}

