/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class RemoteProcessGroupStatusDTO(
  /* The unique ID of the process group that the Processor belongs to */
  groupId: Option[String] = None,
  /* The unique ID of the Processor */
  id: Option[String] = None,
  /* The name of the remote process group. */
  name: Option[String] = None,
  /* The URI of the target system. */
  targetUri: Option[String] = None,
  /* The transmission status of the remote process group. */
  transmissionStatus: Option[String] = None,
  /* The time the status for the process group was last refreshed. */
  statsLastRefreshed: Option[String] = None,
  /* Indicates whether the component is valid, invalid, or still in the process of validating (i.e., it is unknown whether or not the component is valid) */
  validationStatus: Option[RemoteProcessGroupStatusDTOEnums.ValidationStatus] = None,
  aggregateSnapshot: Option[RemoteProcessGroupStatusSnapshotDTO] = None,
  /* A status snapshot for each node in the cluster. If the NiFi instance is a standalone instance, rather than a cluster, this may be null. */
  nodeSnapshots: Option[Seq[NodeRemoteProcessGroupStatusSnapshotDTO]] = None
) extends ApiModel

object RemoteProcessGroupStatusDTOEnums {

  type ValidationStatus = ValidationStatus.Value
  object ValidationStatus extends Enumeration {
    val VALID = Value("VALID")
    val INVALID = Value("INVALID")
    val VALIDATING = Value("VALIDATING")
  }

}

