/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class SystemDiagnosticsSnapshotDTO(
  /* Total size of non heap. */
  totalNonHeap: Option[String] = None,
  /* Total number of bytes allocated to the JVM not used for heap */
  totalNonHeapBytes: Option[Long] = None,
  /* Amount of use non heap. */
  usedNonHeap: Option[String] = None,
  /* Total number of bytes used by the JVM not in the heap space */
  usedNonHeapBytes: Option[Long] = None,
  /* Amount of free non heap. */
  freeNonHeap: Option[String] = None,
  /* Total number of free non-heap bytes available to the JVM */
  freeNonHeapBytes: Option[Long] = None,
  /* Maximum size of non heap. */
  maxNonHeap: Option[String] = None,
  /* The maximum number of bytes that the JVM can use for non-heap purposes */
  maxNonHeapBytes: Option[Long] = None,
  /* Utilization of non heap. */
  nonHeapUtilization: Option[String] = None,
  /* Total size of heap. */
  totalHeap: Option[String] = None,
  /* The total number of bytes that are available for the JVM heap to use */
  totalHeapBytes: Option[Long] = None,
  /* Amount of used heap. */
  usedHeap: Option[String] = None,
  /* The number of bytes of JVM heap that are currently being used */
  usedHeapBytes: Option[Long] = None,
  /* Amount of free heap. */
  freeHeap: Option[String] = None,
  /* The number of bytes that are allocated to the JVM heap but not currently being used */
  freeHeapBytes: Option[Long] = None,
  /* Maximum size of heap. */
  maxHeap: Option[String] = None,
  /* The maximum number of bytes that can be used by the JVM */
  maxHeapBytes: Option[Long] = None,
  /* Utilization of heap. */
  heapUtilization: Option[String] = None,
  /* Number of available processors if supported by the underlying system. */
  availableProcessors: Option[Int] = None,
  /* The processor load average if supported by the underlying system. */
  processorLoadAverage: Option[Double] = None,
  /* Total number of threads. */
  totalThreads: Option[Int] = None,
  /* Number of daemon threads. */
  daemonThreads: Option[Int] = None,
  /* The uptime of the Java virtual machine */
  uptime: Option[String] = None,
  flowFileRepositoryStorageUsage: Option[StorageUsageDTO] = None,
  /* The content repository storage usage. */
  contentRepositoryStorageUsage: Option[Set[StorageUsageDTO]] = None,
  /* The provenance repository storage usage. */
  provenanceRepositoryStorageUsage: Option[Set[StorageUsageDTO]] = None,
  /* The garbage collection details. */
  garbageCollection: Option[Set[GarbageCollectionDTO]] = None,
  /* When the diagnostics were generated. */
  statsLastRefreshed: Option[String] = None,
  versionInfo: Option[VersionInfoDTO] = None
) extends ApiModel


