/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class VersionedRemoteGroupPort(
  /* The component's unique identifier */
  identifier: Option[String] = None,
  /* The component's name */
  name: Option[String] = None,
  /* The user-supplied comments for the component */
  comments: Option[String] = None,
  position: Option[Position] = None,
  /* The id of the remote process group that the port resides in. */
  remoteGroupId: Option[String] = None,
  /* The number of task that may transmit flowfiles to the target port concurrently. */
  concurrentlySchedulableTaskCount: Option[Int] = None,
  /* Whether the flowfiles are compressed when sent to the target port. */
  useCompression: Option[Boolean] = None,
  batchSize: Option[BatchSize] = None,
  componentType: Option[VersionedRemoteGroupPortEnums.ComponentType] = None,
  /* The ID of the port on the target NiFi instance */
  targetId: Option[String] = None,
  /* The scheduled state of the component */
  scheduledState: Option[VersionedRemoteGroupPortEnums.ScheduledState] = None,
  /* The ID of the Process Group that this component belongs to */
  groupIdentifier: Option[String] = None
) extends ApiModel

object VersionedRemoteGroupPortEnums {

  type ComponentType = ComponentType.Value
  type ScheduledState = ScheduledState.Value
  object ComponentType extends Enumeration {
    val CONNECTION = Value("CONNECTION")
    val PROCESSOR = Value("PROCESSOR")
    val PROCESSGROUP = Value("PROCESS_GROUP")
    val REMOTEPROCESSGROUP = Value("REMOTE_PROCESS_GROUP")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
    val LABEL = Value("LABEL")
    val CONTROLLERSERVICE = Value("CONTROLLER_SERVICE")
  }

  object ScheduledState extends Enumeration {
    val ENABLED = Value("ENABLED")
    val DISABLED = Value("DISABLED")
  }

}

