/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class VersionedRemoteProcessGroup(
  /* The component's unique identifier */
  identifier: Option[String] = None,
  /* The component's name */
  name: Option[String] = None,
  /* The user-supplied comments for the component */
  comments: Option[String] = None,
  position: Option[Position] = None,
  /* [DEPRECATED] The target URI of the remote process group. If target uri is not set, but uris are set, then returns the first uri in the uris. If neither target uri nor uris are set, then returns null. */
  targetUri: Option[String] = None,
  /* The target URIs of the remote process group. If target uris is not set but target uri is set, then returns the single target uri. If neither target uris nor target uri is set, then returns null. */
  targetUris: Option[String] = None,
  /* The time period used for the timeout when communicating with the target. */
  communicationsTimeout: Option[String] = None,
  /* When yielding, this amount of time must elapse before the remote process group is scheduled again. */
  yieldDuration: Option[String] = None,
  /* The Transport Protocol that is used for Site-to-Site communications */
  transportProtocol: Option[VersionedRemoteProcessGroupEnums.TransportProtocol] = None,
  /* The local network interface to send/receive data. If not specified, any local address is used. If clustered, all nodes must have an interface with this identifier. */
  localNetworkInterface: Option[String] = None,
  proxyHost: Option[String] = None,
  proxyPort: Option[Int] = None,
  proxyUser: Option[String] = None,
  /* A Set of Input Ports that can be connected to, in order to send data to the remote NiFi instance */
  inputPorts: Option[Set[VersionedRemoteGroupPort]] = None,
  /* A Set of Output Ports that can be connected to, in order to pull data from the remote NiFi instance */
  outputPorts: Option[Set[VersionedRemoteGroupPort]] = None,
  componentType: Option[VersionedRemoteProcessGroupEnums.ComponentType] = None,
  /* The ID of the Process Group that this component belongs to */
  groupIdentifier: Option[String] = None
) extends ApiModel

object VersionedRemoteProcessGroupEnums {

  type TransportProtocol = TransportProtocol.Value
  type ComponentType = ComponentType.Value
  object TransportProtocol extends Enumeration {
    val RAW = Value("RAW")
    val HTTP = Value("HTTP")
  }

  object ComponentType extends Enumeration {
    val CONNECTION = Value("CONNECTION")
    val PROCESSOR = Value("PROCESSOR")
    val PROCESSGROUP = Value("PROCESS_GROUP")
    val REMOTEPROCESSGROUP = Value("REMOTE_PROCESS_GROUP")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
    val LABEL = Value("LABEL")
    val CONTROLLERSERVICE = Value("CONTROLLER_SERVICE")
  }

}

