/**
  * NiFi Rest Api
  * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
  *
  * The version of the OpenAPI document: 1.11.4
  * Contact: dev@nifi.apache.org
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech
  * Do not edit the class manually.
  */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{AccessConfigurationEntity, AccessStatusEntity}
import sttp.client._
import sttp.model.Method

object AccessApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new AccessApi(baseUrl)
}

class AccessApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
    * The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.
    *
    * Expected answers:
    *   code 200 : String (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (Unable to create access token because NiFi is not in the appropriate state. (i.e. may not be configured to support username/password login.)
    *   code 500 :  (Unable to create access token because an unexpected error occurred.)
    *
    * @param username
    * @param password
    */
  def createAccessToken(username: Option[String] = None, password: Option[String] = None): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/access/token")
      .contentType("application/x-www-form-urlencoded")
      .body(
        Map(
          "username" -> username,
          "password" -> password
        )
      )
      .response(asJson[String])

  /**
    * The token returned is formatted as a JSON Web Token (JWT). The token is base64 encoded and comprised of three parts. The header, the body, and the signature. The expiration of the token is a contained within the body. The token can be used in the Authorization header in the format 'Authorization: Bearer <token>'.
    *
    * Expected answers:
    *   code 200 : String (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (NiFi was unable to complete the request because it did not contain a valid Kerberos ticket in the Authorization header. Retry this request after initializing a ticket with kinit and ensuring your browser is configured to support SPNEGO.)
    *   code 409 :  (Unable to create access token because NiFi is not in the appropriate state. (i.e. may not be configured to support Kerberos login.)
    *   code 500 :  (Unable to create access token because an unexpected error occurred.)
    */
  def createAccessTokenFromTicket(): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/access/kerberos")
      .contentType("application/json")
      .response(asJson[String])

  /**
    * The token returned is a base64 encoded string. It is valid for a single request up to five minutes from being issued. It is used as a query parameter name 'access_token'.
    *
    * Expected answers:
    *   code 200 : String (successful operation)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (Unable to create the download token because NiFi is not in the appropriate state. (i.e. may not have any tokens to grant or be configured to support username/password login))
    *   code 500 :  (Unable to create download token because an unexpected error occurred.)
    */
  def createDownloadToken(): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/access/download-token")
      .contentType("application/json")
      .response(asJson[String])

  /**
    * The token returned is a base64 encoded string. It is valid for a single request up to five minutes from being issued. It is used as a query parameter name 'access_token'.
    *
    * Expected answers:
    *   code 200 : String (successful operation)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (Unable to create the download token because NiFi is not in the appropriate state. (i.e. may not have any tokens to grant or be configured to support username/password login))
    *   code 500 :  (Unable to create download token because an unexpected error occurred.)
    */
  def createUiExtensionToken(): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/access/ui-extension-token")
      .contentType("application/json")
      .response(asJson[String])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : AccessStatusEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Unable to determine access status because the client could not be authenticated.)
    *   code 403 :  (Unable to determine access status because the client is not authorized to make this request.)
    *   code 409 :  (Unable to determine access status because NiFi is not in the appropriate state.)
    *   code 500 :  (Unable to determine access status because an unexpected error occurred.)
    */
  def getAccessStatus(): ApiRequestT[AccessStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access")
      .contentType("application/json")
      .response(asJson[AccessStatusEntity])

  /**
    * Expected answers:
    *   code 200 : AccessConfigurationEntity (successful operation)
    */
  def getLoginConfig(): ApiRequestT[AccessConfigurationEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/config")
      .contentType("application/json")
      .response(asJson[AccessConfigurationEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def knoxCallback(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/knox/callback")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def knoxLogout(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/knox/logout")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def knoxRequest(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/knox/request")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 :  (User was logged out successfully.)
    *   code 401 :  (Authentication token provided was empty or not in the correct JWT format.)
    *   code 500 :  (Client failed to log out.)
    */
  def logOut(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/access/logout")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def oidcCallback(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/oidc/callback")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : String (successful operation)
    */
  def oidcExchange(): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/access/oidc/exchange")
      .contentType("application/json")
      .response(asJson[String])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def oidcLogout(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/oidc/logout")
      .contentType("application/json")
      .response(asJson[Unit])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 0 :  (successful operation)
    */
  def oidcRequest(): ApiRequestT[Unit] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/access/oidc/request")
      .contentType("application/json")
      .response(asJson[Unit])

}
