/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{ComponentStateEntity, ControllerServiceEntity, ControllerServiceReferencingComponentsEntity, ControllerServiceRunStatusEntity, PropertyDescriptorEntity, UpdateControllerServiceReferenceRequestEntity}
import sttp.client._
import sttp.model.Method

object ControllerServicesApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new ControllerServicesApi(baseUrl)
}

class ControllerServicesApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   */
  def clearState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/controller-services/${id}/state/clear-requests")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   */
  def getControllerService(id: String): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller-services/${id}")
      .contentType("application/json")
      .response(asJson[ControllerServiceEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceReferencingComponentsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   */
  def getControllerServiceReferences(id: String): ApiRequestT[ControllerServiceReferencingComponentsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller-services/${id}/references")
      .contentType("application/json")
      .response(asJson[ControllerServiceReferencingComponentsEntity])

  /**
   * Expected answers:
   *   code 200 : PropertyDescriptorEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   * @param propertyName The property name to return the descriptor for.
   */
  def getPropertyDescriptor(id: String, propertyName: String): ApiRequestT[PropertyDescriptorEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller-services/${id}/descriptors?propertyName=$propertyName")
      .contentType("application/json")
      .response(asJson[PropertyDescriptorEntity])

  /**
   * Expected answers:
   *   code 200 : ComponentStateEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   */
  def getState(id: String): ApiRequestT[ComponentStateEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/controller-services/${id}/state")
      .contentType("application/json")
      .response(asJson[ComponentStateEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def removeControllerService(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/controller-services/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[ControllerServiceEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   * @param body The controller service configuration details.
   */
  def updateControllerService(id: String, body: ControllerServiceEntity): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller-services/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerServiceEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceReferencingComponentsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   * @param body The controller service request update request.
   */
  def updateControllerServiceReferences(id: String, body: UpdateControllerServiceReferenceRequestEntity): ApiRequestT[ControllerServiceReferencingComponentsEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller-services/${id}/references")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerServiceReferencingComponentsEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServiceEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The controller service id.
   * @param body The controller service run status.
   */
  def updateRunStatus(id: String, body: ControllerServiceRunStatusEntity): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/controller-services/${id}/run-status")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerServiceEntity])

}

