/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{CounterEntity, CountersEntity}
import sttp.client._
import sttp.model.Method

object CountersApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new CountersApi(baseUrl)
}

class CountersApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : CountersEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getCounters(nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[CountersEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/counters?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[CountersEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : CounterEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The id of the counter.
   */
  def updateCounter(id: String): ApiRequestT[CounterEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/counters/${id}")
      .contentType("application/json")
      .response(asJson[CounterEntity])

}

