/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.TransactionResultEntity
import sttp.client._
import sttp.model.Method

object DataTransferApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new DataTransferApi(baseUrl)
}

class DataTransferApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Expected answers:
   *   code 200 : TransactionResultEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param responseCode The response code. Available values are BAD_CHECKSUM(19), CONFIRM_TRANSACTION(12) or CANCEL_TRANSACTION(15).
   * @param portId The input port id.
   * @param transactionId The transaction id.
   */
  def commitInputPortTransaction(responseCode: Int, portId: String, transactionId: String): ApiRequestT[TransactionResultEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/data-transfer/input-ports/${portId}/transactions/${transactionId}?responseCode=$responseCode")
      .contentType("application/json")
      .response(asJson[TransactionResultEntity])

  /**
   * Expected answers:
   *   code 200 : TransactionResultEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param responseCode The response code. Available values are CONFIRM_TRANSACTION(12) or CANCEL_TRANSACTION(15).
   * @param checksum A checksum calculated at client side using CRC32 to check flow file content integrity. It must match with the value calculated at server side.
   * @param portId The output port id.
   * @param transactionId The transaction id.
   */
  def commitOutputPortTransaction(responseCode: Int, checksum: String, portId: String, transactionId: String): ApiRequestT[TransactionResultEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/data-transfer/output-ports/${portId}/transactions/${transactionId}?responseCode=$responseCode&checksum=$checksum")
      .contentType("application/json")
      .response(asJson[TransactionResultEntity])

  /**
   * Expected answers:
   *   code 200 : TransactionResultEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param portType The port type.
   * @param portId 
   */
  def createPortTransaction(portType: String, portId: String): ApiRequestT[TransactionResultEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/data-transfer/${portType}/${portId}/transactions")
      .contentType("application/json")
      .response(asJson[TransactionResultEntity])

  /**
   * Expected answers:
   *   code 200 : TransactionResultEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param portId 
   * @param transactionId 
   */
  def extendInputPortTransactionTTL(portId: String, transactionId: String): ApiRequestT[TransactionResultEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/data-transfer/input-ports/${portId}/transactions/${transactionId}")
      .contentType("application/json")
      .response(asJson[TransactionResultEntity])

  /**
   * Expected answers:
   *   code 200 : TransactionResultEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param portId 
   * @param transactionId 
   */
  def extendOutputPortTransactionTTL(portId: String, transactionId: String): ApiRequestT[TransactionResultEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/data-transfer/output-ports/${portId}/transactions/${transactionId}")
      .contentType("application/json")
      .response(asJson[TransactionResultEntity])

  /**
   * Expected answers:
   *   code 200 : String (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param portId The input port id.
   * @param transactionId 
   */
  def receiveFlowFiles(portId: String, transactionId: String): ApiRequestT[String] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/data-transfer/input-ports/${portId}/transactions/${transactionId}/flow-files")
      .contentType("application/json")
      .response(asJson[String])

  /**
   * Expected answers:
   *   code 200 : Any (There is no flow file to return.)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   *   code 503 :  (NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful)
   * 
   * @param portId The output port id.
   * @param transactionId 
   */
  def transferFlowFiles(portId: String, transactionId: String): ApiRequestT[Any] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/data-transfer/output-ports/${portId}/transactions/${transactionId}/flow-files")
      .contentType("application/json")
      .response(asJson[Any])

}

