/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{AboutEntity, ActionEntity, ActivateControllerServicesEntity, BannerEntity, BucketsEntity, BulletinBoardEntity, ClusteSummaryEntity, ClusterSearchResultsEntity, ComponentHistoryEntity, ConnectionStatisticsEntity, ConnectionStatusEntity, ControllerBulletinsEntity, ControllerServiceTypesEntity, ControllerServicesEntity, ControllerStatusEntity, CurrentUserEntity, FlowConfigurationEntity, HistoryEntity, ParameterContextsEntity, PortStatusEntity, PrioritizerTypesEntity, ProcessGroupFlowEntity, ProcessGroupStatusEntity, ProcessorStatusEntity, ProcessorTypesEntity, RegistryClientsEntity, RemoteProcessGroupStatusEntity, ReportingTaskTypesEntity, ReportingTasksEntity, ScheduleComponentsEntity, SearchResultsEntity, StatusHistoryEntity, TemplatesEntity, VersionedFlowSnapshotMetadataSetEntity, VersionedFlowsEntity}
import sttp.client._
import sttp.model.Method

object FlowApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new FlowApi(baseUrl)
}

class FlowApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
   * Expected answers:
   *   code 200 : ActivateControllerServicesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   * @param body The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.
   */
  def activateControllerServices(id: String, body: ActivateControllerServicesEntity): ApiRequestT[ActivateControllerServicesEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/flow/process-groups/${id}/controller-services")
      .contentType("application/json")
      .body(body)
      .response(asJson[ActivateControllerServicesEntity])

  /**
   * Expected answers:
   *   code 200 : String (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def generateClientId(): ApiRequestT[String] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/client-id")
      .contentType("application/json")
      .response(asJson[String])

  /**
   * Expected answers:
   *   code 200 : AboutEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getAboutInfo(): ApiRequestT[AboutEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/about")
      .contentType("application/json")
      .response(asJson[AboutEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ActionEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The action id.
   */
  def getAction(id: String): ApiRequestT[ActionEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/history/${id}")
      .contentType("application/json")
      .response(asJson[ActionEntity])

  /**
   * Expected answers:
   *   code 200 : BannerEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getBanners(): ApiRequestT[BannerEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/banners")
      .contentType("application/json")
      .response(asJson[BannerEntity])

  /**
   * Expected answers:
   *   code 200 : BucketsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The registry id.
   */
  def getBuckets(id: String): ApiRequestT[BucketsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/registries/${id}/buckets")
      .contentType("application/json")
      .response(asJson[BucketsEntity])

  /**
   * Expected answers:
   *   code 200 : BulletinBoardEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param after Includes bulletins with an id after this value.
   * @param sourceName Includes bulletins originating from this sources whose name match this regular expression.
   * @param message Includes bulletins whose message that match this regular expression.
   * @param sourceId Includes bulletins originating from this sources whose id match this regular expression.
   * @param groupId Includes bulletins originating from this sources whose group id match this regular expression.
   * @param limit The number of bulletins to limit the response to.
   */
  def getBulletinBoard(after: Option[String] = None, sourceName: Option[String] = None, message: Option[String] = None, sourceId: Option[String] = None, groupId: Option[String] = None, limit: Option[String] = None): ApiRequestT[BulletinBoardEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/bulletin-board?after=$after&sourceName=$sourceName&message=$message&sourceId=$sourceId&groupId=$groupId&limit=$limit")
      .contentType("application/json")
      .response(asJson[BulletinBoardEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerBulletinsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getBulletins(): ApiRequestT[ControllerBulletinsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/controller/bulletins")
      .contentType("application/json")
      .response(asJson[ControllerBulletinsEntity])

  /**
   * Expected answers:
   *   code 200 : ClusteSummaryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getClusterSummary(): ApiRequestT[ClusteSummaryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/cluster/summary")
      .contentType("application/json")
      .response(asJson[ClusteSummaryEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ComponentHistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param componentId The component id.
   */
  def getComponentHistory(componentId: String): ApiRequestT[ComponentHistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/history/components/${componentId}")
      .contentType("application/json")
      .response(asJson[ComponentHistoryEntity])

  /**
   * Expected answers:
   *   code 200 : ConnectionStatisticsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the statistics.
   */
  def getConnectionStatistics(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[ConnectionStatisticsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/connections/${id}/statistics?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[ConnectionStatisticsEntity])

  /**
   * Expected answers:
   *   code 200 : ConnectionStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getConnectionStatus(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[ConnectionStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/connections/${id}/status?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[ConnectionStatusEntity])

  /**
   * Expected answers:
   *   code 200 : StatusHistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The connection id.
   */
  def getConnectionStatusHistory(id: String): ApiRequestT[StatusHistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/connections/${id}/status/history")
      .contentType("application/json")
      .response(asJson[StatusHistoryEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ControllerServiceTypesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param serviceType If specified, will only return controller services that are compatible with this type of service.
   * @param serviceBundleGroup If serviceType specified, is the bundle group of the serviceType.
   * @param serviceBundleArtifact If serviceType specified, is the bundle artifact of the serviceType.
   * @param serviceBundleVersion If serviceType specified, is the bundle version of the serviceType.
   * @param bundleGroupFilter If specified, will only return types that are a member of this bundle group.
   * @param bundleArtifactFilter If specified, will only return types that are a member of this bundle artifact.
   * @param typeFilter If specified, will only return types whose fully qualified classname matches.
   */
  def getControllerServiceTypes(serviceType: Option[String] = None, serviceBundleGroup: Option[String] = None, serviceBundleArtifact: Option[String] = None, serviceBundleVersion: Option[String] = None, bundleGroupFilter: Option[String] = None, bundleArtifactFilter: Option[String] = None, typeFilter: Option[String] = None): ApiRequestT[ControllerServiceTypesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/controller-service-types?serviceType=$serviceType&serviceBundleGroup=$serviceBundleGroup&serviceBundleArtifact=$serviceBundleArtifact&serviceBundleVersion=$serviceBundleVersion&bundleGroupFilter=$bundleGroupFilter&bundleArtifactFilter=$bundleArtifactFilter&typeFilter=$typeFilter")
      .contentType("application/json")
      .response(asJson[ControllerServiceTypesEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServicesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getControllerServicesFromController(): ApiRequestT[ControllerServicesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/controller/controller-services")
      .contentType("application/json")
      .response(asJson[ControllerServicesEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerServicesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   * @param includeAncestorGroups Whether or not to include parent/ancestory process groups
   * @param includeDescendantGroups Whether or not to include descendant process groups
   */
  def getControllerServicesFromGroup(id: String, includeAncestorGroups: Option[Boolean] = None, includeDescendantGroups: Option[Boolean] = None): ApiRequestT[ControllerServicesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/process-groups/${id}/controller-services?includeAncestorGroups=$includeAncestorGroups&includeDescendantGroups=$includeDescendantGroups")
      .contentType("application/json")
      .response(asJson[ControllerServicesEntity])

  /**
   * Expected answers:
   *   code 200 : ControllerStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getControllerStatus(): ApiRequestT[ControllerStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/status")
      .contentType("application/json")
      .response(asJson[ControllerStatusEntity])

  /**
   * Expected answers:
   *   code 200 : CurrentUserEntity (successful operation)
   */
  def getCurrentUser(): ApiRequestT[CurrentUserEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/current-user")
      .contentType("application/json")
      .response(asJson[CurrentUserEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessGroupFlowEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   */
  def getFlow(id: String): ApiRequestT[ProcessGroupFlowEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/process-groups/${id}")
      .contentType("application/json")
      .response(asJson[ProcessGroupFlowEntity])

  /**
   * Expected answers:
   *   code 200 : FlowConfigurationEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getFlowConfig(): ApiRequestT[FlowConfigurationEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/config")
      .contentType("application/json")
      .response(asJson[FlowConfigurationEntity])

  /**
   * Expected answers:
   *   code 200 : VersionedFlowsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param registryId The registry id.
   * @param bucketId The bucket id.
   */
  def getFlows(registryId: String, bucketId: String): ApiRequestT[VersionedFlowsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/registries/${registryId}/buckets/${bucketId}/flows")
      .contentType("application/json")
      .response(asJson[VersionedFlowsEntity])

  /**
   * Expected answers:
   *   code 200 : PortStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The input port id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getInputPortStatus(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[PortStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/input-ports/${id}/status?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[PortStatusEntity])

  /**
   * Expected answers:
   *   code 200 : PortStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The output port id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getOutputPortStatus(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[PortStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/output-ports/${id}/status?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[PortStatusEntity])

  /**
   * Expected answers:
   *   code 200 : ParameterContextsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getParameterContexts(): ApiRequestT[ParameterContextsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/parameter-contexts")
      .contentType("application/json")
      .response(asJson[ParameterContextsEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : PrioritizerTypesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getPrioritizers(): ApiRequestT[PrioritizerTypesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/prioritizers")
      .contentType("application/json")
      .response(asJson[PrioritizerTypesEntity])

  /**
   * The status for a process group includes status for all descendent components. When invoked on the root group with recursive set to true, it will return the current status of every component in the flow.
   * 
   * Expected answers:
   *   code 200 : ProcessGroupStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   * @param recursive Whether all descendant groups and the status of their content will be included. Optional, defaults to false
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getProcessGroupStatus(id: String, recursive: Option[Boolean] = None, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[ProcessGroupStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/process-groups/${id}/status?recursive=$recursive&nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[ProcessGroupStatusEntity])

  /**
   * Expected answers:
   *   code 200 : StatusHistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   */
  def getProcessGroupStatusHistory(id: String): ApiRequestT[StatusHistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/process-groups/${id}/status/history")
      .contentType("application/json")
      .response(asJson[StatusHistoryEntity])

  /**
   * Expected answers:
   *   code 200 : ProcessorStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getProcessorStatus(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[ProcessorStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/processors/${id}/status?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[ProcessorStatusEntity])

  /**
   * Expected answers:
   *   code 200 : StatusHistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The processor id.
   */
  def getProcessorStatusHistory(id: String): ApiRequestT[StatusHistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/processors/${id}/status/history")
      .contentType("application/json")
      .response(asJson[StatusHistoryEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ProcessorTypesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param bundleGroupFilter If specified, will only return types that are a member of this bundle group.
   * @param bundleArtifactFilter If specified, will only return types that are a member of this bundle artifact.
   * @param `type` If specified, will only return types whose fully qualified classname matches.
   */
  def getProcessorTypes(bundleGroupFilter: Option[String] = None, bundleArtifactFilter: Option[String] = None, tpe: Option[String] = None): ApiRequestT[ProcessorTypesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/processor-types?bundleGroupFilter=$bundleGroupFilter&bundleArtifactFilter=$bundleArtifactFilter&type=$tpe")
      .contentType("application/json")
      .response(asJson[ProcessorTypesEntity])

  /**
   * Expected answers:
   *   code 200 : RegistryClientsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getRegistries(): ApiRequestT[RegistryClientsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/registries")
      .contentType("application/json")
      .response(asJson[RegistryClientsEntity])

  /**
   * Expected answers:
   *   code 200 : RemoteProcessGroupStatusEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The remote process group id.
   * @param nodewise Whether or not to include the breakdown per node. Optional, defaults to false
   * @param clusterNodeId The id of the node where to get the status.
   */
  def getRemoteProcessGroupStatus(id: String, nodewise: Option[Boolean] = None, clusterNodeId: Option[String] = None): ApiRequestT[RemoteProcessGroupStatusEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/remote-process-groups/${id}/status?nodewise=$nodewise&clusterNodeId=$clusterNodeId")
      .contentType("application/json")
      .response(asJson[RemoteProcessGroupStatusEntity])

  /**
   * Expected answers:
   *   code 200 : StatusHistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The remote process group id.
   */
  def getRemoteProcessGroupStatusHistory(id: String): ApiRequestT[StatusHistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/remote-process-groups/${id}/status/history")
      .contentType("application/json")
      .response(asJson[StatusHistoryEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ReportingTaskTypesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param bundleGroupFilter If specified, will only return types that are a member of this bundle group.
   * @param bundleArtifactFilter If specified, will only return types that are a member of this bundle artifact.
   * @param `type` If specified, will only return types whose fully qualified classname matches.
   */
  def getReportingTaskTypes(bundleGroupFilter: Option[String] = None, bundleArtifactFilter: Option[String] = None, tpe:Option[String] = None): ApiRequestT[ReportingTaskTypesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/reporting-task-types?bundleGroupFilter=$bundleGroupFilter&bundleArtifactFilter=$bundleArtifactFilter&type=$tpe")
      .contentType("application/json")
      .response(asJson[ReportingTaskTypesEntity])

  /**
   * Expected answers:
   *   code 200 : ReportingTasksEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getReportingTasks(): ApiRequestT[ReportingTasksEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/reporting-tasks")
      .contentType("application/json")
      .response(asJson[ReportingTasksEntity])

  /**
   * Expected answers:
   *   code 200 : TemplatesEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getTemplates(): ApiRequestT[TemplatesEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/templates")
      .contentType("application/json")
      .response(asJson[TemplatesEntity])

  /**
   * Expected answers:
   *   code 200 : VersionedFlowSnapshotMetadataSetEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param registryId The registry id.
   * @param bucketId The bucket id.
   * @param flowId The flow id.
   */
  def getVersions(registryId: String, bucketId: String, flowId: String): ApiRequestT[VersionedFlowSnapshotMetadataSetEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/registries/${registryId}/buckets/${registryId}/flows/${flowId}/versions")
      .contentType("application/json")
      .response(asJson[VersionedFlowSnapshotMetadataSetEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : HistoryEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param offset The offset into the result set.
   * @param count The number of actions to return.
   * @param sortColumn The field to sort on.
   * @param sortOrder The direction to sort.
   * @param startDate Include actions after this date.
   * @param endDate Include actions before this date.
   * @param userIdentity Include actions performed by this user.
   * @param sourceId Include actions on this component.
   */
  def queryHistory(offset: String, count: String, sortColumn: Option[String] = None, sortOrder: Option[String] = None, startDate: Option[String] = None, endDate: Option[String] = None, userIdentity: Option[String] = None, sourceId: Option[String] = None): ApiRequestT[HistoryEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/history?offset=$offset&count=$count&sortColumn=$sortColumn&sortOrder=$sortOrder&startDate=$startDate&endDate=$endDate&userIdentity=$userIdentity&sourceId=$sourceId")
      .contentType("application/json")
      .response(asJson[HistoryEntity])

  /**
   * Expected answers:
   *   code 200 : ScheduleComponentsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The process group id.
   * @param body The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.
   */
  def scheduleComponents(id: String, body: ScheduleComponentsEntity): ApiRequestT[ScheduleComponentsEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/flow/process-groups/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ScheduleComponentsEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : ClusterSearchResultsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param `q` Node address to search for.
   */
  def searchCluster(q: String): ApiRequestT[ClusterSearchResultsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/cluster/search-results?q=$q")
      .contentType("application/json")
      .response(asJson[ClusterSearchResultsEntity])

  /**
   * Only search results from authorized components will be returned.
   * 
   * Expected answers:
   *   code 200 : SearchResultsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param `q` 
   */
  def searchFlow(q: Option[String] = None): ApiRequestT[SearchResultsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/flow/search-results?q=$q")
      .contentType("application/json")
      .response(asJson[SearchResultsEntity])

}

