/**
  * NiFi Rest Api
  * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
  *
  * The version of the OpenAPI document: 1.11.4
  * Contact: dev@nifi.apache.org
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech
  * Do not edit the class manually.
  */
package it.agilelab.bigdata.nifi.client.api

import java.io.File

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model._
import org.json4s.JObject
import sttp.client._
import sttp.model.Method

object ProcessGroupsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) =
    new ProcessGroupsApi(baseUrl)
}

class ProcessGroupsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  import serializer._

  /**
    * Expected answers:
    *   code 200 : FlowEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The copy snippet request.
    */
  def copySnippet(id: String, body: CopySnippetRequestEntity): ApiRequestT[FlowEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/snippet-instance")
      .contentType("application/json")
      .body(body)
      .response(asJson[FlowEntity])

  /**
    * Expected answers:
    *   code 200 : ConnectionEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The connection configuration details.
    */
  def createConnection(id: String, body: ConnectionEntity): ApiRequestT[ConnectionEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/connections")
      .contentType("application/json")
      .body(body)
      .response(asJson[ConnectionEntity])

  /**
    * Expected answers:
    *   code 200 : ControllerServiceEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The controller service configuration details.
    */
  def createControllerService(id: String, body: ControllerServiceEntity): ApiRequestT[ControllerServiceEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/controller-services")
      .contentType("application/json")
      .body(body)
      .response(asJson[ControllerServiceEntity])

  /**
    * Expected answers:
    *   code 200 : FunnelEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The funnel configuration details.
    */
  def createFunnel(id: String, body: FunnelEntity): ApiRequestT[FunnelEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/funnels")
      .contentType("application/json")
      .body(body)
      .response(asJson[FunnelEntity])

  /**
    * Expected answers:
    *   code 200 : PortEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The input port configuration details.
    */
  def createInputPort(id: String, body: PortEntity): ApiRequestT[PortEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/input-ports")
      .contentType("application/json")
      .body(body)
      .response(asJson[PortEntity])

  /**
    * Expected answers:
    *   code 200 : LabelEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The label configuration details.
    */
  def createLabel(id: String, body: LabelEntity): ApiRequestT[LabelEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/labels")
      .contentType("application/json")
      .body(body)
      .response(asJson[LabelEntity])

  /**
    * Expected answers:
    *   code 200 : PortEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The output port configuration.
    */
  def createOutputPort(id: String, body: PortEntity): ApiRequestT[PortEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/output-ports")
      .contentType("application/json")
      .body(body)
      .response(asJson[PortEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessGroupEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The process group configuration details.
    */
  def createProcessGroup(id: String, body: ProcessGroupEntity): ApiRequestT[ProcessGroupEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/process-groups")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProcessGroupEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessorEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The processor configuration details.
    */
  def createProcessor(id: String, body: ProcessorEntity): ApiRequestT[ProcessorEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/processors")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProcessorEntity])

  /**
    * Expected answers:
    *   code 200 : RemoteProcessGroupEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The remote process group configuration details.
    */
  def createRemoteProcessGroup(id: String, body: RemoteProcessGroupEntity): ApiRequestT[RemoteProcessGroupEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/remote-process-groups")
      .contentType("application/json")
      .body(body)
      .response(asJson[RemoteProcessGroupEntity])

  /**
    * Expected answers:
    *   code 200 : TemplateEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The create template request.
    */
  def createTemplate(id: String, body: CreateTemplateRequestEntity): ApiRequestT[TemplateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/templates")
      .contentType("application/json")
      .body(body)
      .response(asJson[TemplateEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : VariableRegistryUpdateRequestEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param groupId The process group id.
    * @param updateId The ID of the Variable Registry Update Request
    * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
    */
  def deleteVariableRegistryUpdateRequest(
      groupId: String,
      updateId: String,
      disconnectedNodeAcknowledged: Option[Boolean] = None
  ): ApiRequestT[VariableRegistryUpdateRequestEntity] =
    basicRequest
      .method(
        Method.DELETE,
        uri"$baseUrl/process-groups/${groupId}/variable-registry/update-requests/${updateId}?disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged"
      )
      .contentType("application/json")
      .response(asJson[VariableRegistryUpdateRequestEntity])

  /**
    * Expected answers:
    *   code 200 : String (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def exportProcessGroup(id: String): ApiRequestT[JObject] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/download")
      .contentType("application/json")
      .response(asJson[JObject])

  /**
    * Expected answers:
    *   code 200 : ConnectionsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getConnections(id: String): ApiRequestT[ConnectionsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/connections")
      .contentType("application/json")
      .response(asJson[ConnectionsEntity])

  /**
    * Expected answers:
    *   code 200 : FunnelsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getFunnels(id: String): ApiRequestT[FunnelsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/funnels")
      .contentType("application/json")
      .response(asJson[FunnelsEntity])

  /**
    * Expected answers:
    *   code 200 : InputPortsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getInputPorts(id: String): ApiRequestT[InputPortsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/input-ports")
      .contentType("application/json")
      .response(asJson[InputPortsEntity])

  /**
    * Expected answers:
    *   code 200 : LabelsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getLabels(id: String): ApiRequestT[LabelsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/labels")
      .contentType("application/json")
      .response(asJson[LabelsEntity])

  /**
    * Expected answers:
    *   code 200 : FlowComparisonEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getLocalModifications(id: String): ApiRequestT[FlowComparisonEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/local-modifications")
      .contentType("application/json")
      .response(asJson[FlowComparisonEntity])

  /**
    * Expected answers:
    *   code 200 : OutputPortsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getOutputPorts(id: String): ApiRequestT[OutputPortsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/output-ports")
      .contentType("application/json")
      .response(asJson[OutputPortsEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessGroupEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getProcessGroup(id: String): ApiRequestT[ProcessGroupEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}")
      .contentType("application/json")
      .response(asJson[ProcessGroupEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessGroupsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getProcessGroups(id: String): ApiRequestT[ProcessGroupsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/process-groups")
      .contentType("application/json")
      .response(asJson[ProcessGroupsEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessorsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param includeDescendantGroups Whether or not to include processors from descendant process groups
    */
  def getProcessors(id: String, includeDescendantGroups: Option[Boolean] = None): ApiRequestT[ProcessorsEntity] =
    basicRequest
      .method(
        Method.GET,
        uri"$baseUrl/process-groups/${id}/processors?includeDescendantGroups=$includeDescendantGroups"
      )
      .contentType("application/json")
      .response(asJson[ProcessorsEntity])

  /**
    * Expected answers:
    *   code 200 : RemoteProcessGroupsEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def getRemoteProcessGroups(id: String): ApiRequestT[RemoteProcessGroupsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${id}/remote-process-groups")
      .contentType("application/json")
      .response(asJson[RemoteProcessGroupsEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : VariableRegistryEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param includeAncestorGroups Whether or not to include ancestor groups
    */
  def getVariableRegistry(
      id: String,
      includeAncestorGroups: Option[Boolean] = None
  ): ApiRequestT[VariableRegistryEntity] =
    basicRequest
      .method(
        Method.GET,
        uri"$baseUrl/process-groups/${id}/variable-registry?includeAncestorGroups=$includeAncestorGroups"
      )
      .contentType("application/json")
      .response(asJson[VariableRegistryEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : VariableRegistryUpdateRequestEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param groupId The process group id.
    * @param updateId The ID of the Variable Registry Update Request
    */
  def getVariableRegistryUpdateRequest(
      groupId: String,
      updateId: String
  ): ApiRequestT[VariableRegistryUpdateRequestEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/process-groups/${groupId}/variable-registry/update-requests/${updateId}")
      .contentType("application/json")
      .response(asJson[VariableRegistryUpdateRequestEntity])

  /**
    * Expected answers:
    *   code 200 : TemplateEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    */
  def importTemplate(id: String): ApiRequestT[TemplateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/templates/import")
      .contentType("application/json")
      .response(asJson[TemplateEntity])

  /**
    * Expected answers:
    *   code 200 : FlowEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The instantiate template request.
    */
  def instantiateTemplate(id: String, body: InstantiateTemplateRequestEntity): ApiRequestT[FlowEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/template-instance")
      .contentType("application/json")
      .body(body)
      .response(asJson[FlowEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessGroupEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param version The revision is used to verify the client is working with the latest version of the flow.
    * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
    * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
    */
  def removeProcessGroup(
      id: String,
      version: Option[String] = None,
      clientId: Option[String] = None,
      disconnectedNodeAcknowledged: Option[Boolean] = None
  ): ApiRequestT[ProcessGroupEntity] =
    basicRequest
      .method(
        Method.DELETE,
        uri"$baseUrl/process-groups/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged"
      )
      .contentType("application/json")
      .response(asJson[ProcessGroupEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : VariableRegistryUpdateRequestEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The variable registry configuration details.
    */
  def submitUpdateVariableRegistryRequest(
      id: String,
      body: VariableRegistryEntity
  ): ApiRequestT[VariableRegistryUpdateRequestEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/variable-registry/update-requests")
      .contentType("application/json")
      .body(body)
      .response(asJson[VariableRegistryUpdateRequestEntity])

  /**
    * Expected answers:
    *   code 200 : ProcessGroupEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The process group configuration details.
    */
  def updateProcessGroup(id: String, body: ProcessGroupEntity): ApiRequestT[ProcessGroupEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/process-groups/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[ProcessGroupEntity])

  /**
    * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
    *
    * Expected answers:
    *   code 200 : VariableRegistryEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 404 :  (The specified resource could not be found.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param body The variable registry configuration details.
    */
  def updateVariableRegistry(id: String, body: VariableRegistryEntity): ApiRequestT[VariableRegistryEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/process-groups/${id}/variable-registry")
      .contentType("application/json")
      .body(body)
      .response(asJson[VariableRegistryEntity])

  /**
    * Expected answers:
    *   code 200 : TemplateEntity (successful operation)
    *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
    *   code 401 :  (Client could not be authenticated.)
    *   code 403 :  (Client is not authorized to make this request.)
    *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
    *
    * @param id The process group id.
    * @param template The binary content of the template file being uploaded.
    */
  def uploadTemplate(id: String, template: File): ApiRequestT[TemplateEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/process-groups/${id}/templates/upload")
      .contentType("multipart/form-data")
      .body(
        Map(
          "template" -> template
        )
      )
      .response(asJson[TemplateEntity])

}
