/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.api

import it.agilelab.bigdata.nifi.client.core.SttpSerializer
import it.agilelab.bigdata.nifi.client.core.alias._
import it.agilelab.bigdata.nifi.client.model.{TenantsEntity, UserEntity, UserGroupEntity, UserGroupsEntity, UsersEntity}
import sttp.client._
import sttp.model.Method

object TenantsApi {

  def apply(baseUrl: String = "http://localhost/nifi-api")(implicit serializer: SttpSerializer) = new TenantsApi(baseUrl)
}

class TenantsApi(baseUrl: String)(implicit serializer: SttpSerializer) {

  
  import serializer._

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The user configuration details.
   */
  def createUser(body: UserEntity): ApiRequestT[UserEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/tenants/users")
      .contentType("application/json")
      .body(body)
      .response(asJson[UserEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserGroupEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param body The user group configuration details.
   */
  def createUserGroup(body: UserGroupEntity): ApiRequestT[UserGroupEntity] =
    basicRequest
      .method(Method.POST, uri"$baseUrl/tenants/user-groups")
      .contentType("application/json")
      .body(body)
      .response(asJson[UserGroupEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user id.
   */
  def getUser(id: String): ApiRequestT[UserEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/tenants/users/${id}")
      .contentType("application/json")
      .response(asJson[UserEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserGroupEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user group id.
   */
  def getUserGroup(id: String): ApiRequestT[UserGroupEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/tenants/user-groups/${id}")
      .contentType("application/json")
      .response(asJson[UserGroupEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserGroupsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getUserGroups(): ApiRequestT[UserGroupsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/tenants/user-groups")
      .contentType("application/json")
      .response(asJson[UserGroupsEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UsersEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   */
  def getUsers(): ApiRequestT[UsersEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/tenants/users")
      .contentType("application/json")
      .response(asJson[UsersEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def removeUser(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[UserEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/tenants/users/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[UserEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserGroupEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user group id.
   * @param version The revision is used to verify the client is working with the latest version of the flow.
   * @param clientId If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.
   * @param disconnectedNodeAcknowledged Acknowledges that this node is disconnected to allow for mutable requests to proceed.
   */
  def removeUserGroup(id: String, version: Option[String] = None, clientId: Option[String] = None, disconnectedNodeAcknowledged: Option[Boolean] = None): ApiRequestT[UserGroupEntity] =
    basicRequest
      .method(Method.DELETE, uri"$baseUrl/tenants/user-groups/${id}?version=$version&clientId=$clientId&disconnectedNodeAcknowledged=$disconnectedNodeAcknowledged")
      .contentType("application/json")
      .response(asJson[UserGroupEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : TenantsEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param `q` Identity to search for.
   */
  def searchTenants(q: String): ApiRequestT[TenantsEntity] =
    basicRequest
      .method(Method.GET, uri"$baseUrl/tenants/search-results?q=$q")
      .contentType("application/json")
      .response(asJson[TenantsEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user id.
   * @param body The user configuration details.
   */
  def updateUser(id: String, body: UserEntity): ApiRequestT[UserEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/tenants/users/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[UserEntity])

  /**
   * Note: This endpoint is subject to change as NiFi and it's REST API evolve.
   * 
   * Expected answers:
   *   code 200 : UserGroupEntity (successful operation)
   *   code 400 :  (NiFi was unable to complete the request because it was invalid. The request should not be retried without modification.)
   *   code 401 :  (Client could not be authenticated.)
   *   code 403 :  (Client is not authorized to make this request.)
   *   code 404 :  (The specified resource could not be found.)
   *   code 409 :  (The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.)
   * 
   * @param id The user group id.
   * @param body The user group configuration details.
   */
  def updateUserGroup(id: String, body: UserGroupEntity): ApiRequestT[UserGroupEntity] =
    basicRequest
      .method(Method.PUT, uri"$baseUrl/tenants/user-groups/${id}")
      .contentType("application/json")
      .body(body)
      .response(asJson[UserGroupEntity])

}

