/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class ConnectableDTO(
  /* The id of the connectable component. */
  id: String,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The type of component the connectable is. */
  `type`: ConnectableDTOEnums.`Type`,
  /* The id of the group that the connectable component resides in */
  groupId: String,
  /* The name of the connectable component */
  name: Option[String] = None,
  /* Reflects the current state of the connectable component. */
  running: Option[Boolean] = None,
  /* If the connectable component represents a remote port, indicates if the target is configured to transmit. */
  transmitting: Option[Boolean] = None,
  /* If the connectable component represents a remote port, indicates if the target exists. */
  exists: Option[Boolean] = None,
  /* The comments for the connectable component. */
  comments: Option[String] = None
) extends ApiModel

object ConnectableDTOEnums {

  type `Type` = `Type`.Value
  object `Type` extends Enumeration {
    val PROCESSOR = Value("PROCESSOR")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
  }

}

