/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class PortDTO(
  /* The id of the component. */
  id: Option[String] = None,
  /* The ID of the corresponding component that is under version control */
  versionedComponentId: Option[String] = None,
  /* The id of parent process group of this component if applicable. */
  parentGroupId: Option[String] = None,
  position: Option[PositionDTO] = None,
  /* The name of the port. */
  name: Option[String] = None,
  /* The comments for the port. */
  comments: Option[String] = None,
  /* The state of the port. */
  state: Option[PortDTOEnums.State] = None,
  /* The type of port. */
  `type`: Option[PortDTOEnums.`Type`] = None,
  /* Whether the port has incoming or output connections to a remote NiFi. This is only applicable when the port is allowed to be accessed remotely. */
  transmitting: Option[Boolean] = None,
  /* The number of tasks that should be concurrently scheduled for the port. */
  concurrentlySchedulableTaskCount: Option[Int] = None,
  /* The users that are allowed to access the port. */
  userAccessControl: Option[Set[String]] = None,
  /* The user groups that are allowed to access the port. */
  groupAccessControl: Option[Set[String]] = None,
  /* Whether this port can be accessed remotely via Site-to-Site protocol. */
  allowRemoteAccess: Option[Boolean] = None,
  /* Gets the validation errors from this port. These validation errors represent the problems with the port that must be resolved before it can be started. */
  validationErrors: Option[Seq[String]] = None
) extends ApiModel

object PortDTOEnums {

  type State = State.Value
  type `Type` = `Type`.Value
  object State extends Enumeration {
    val RUNNING = Value("RUNNING")
    val STOPPED = Value("STOPPED")
    val DISABLED = Value("DISABLED")
  }

  object `Type` extends Enumeration {
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
  }

}

