/**
 * NiFi Rest Api
 * The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.
 *
 * The version of the OpenAPI document: 1.11.4
 * Contact: dev@nifi.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package it.agilelab.bigdata.nifi.client.model

import it.agilelab.bigdata.nifi.client.core.ApiModel

case class VersionedProcessor(
  /* The component's unique identifier */
  identifier: Option[String] = None,
  /* The component's name */
  name: Option[String] = None,
  /* The user-supplied comments for the component */
  comments: Option[String] = None,
  position: Option[Position] = None,
  bundle: Option[Bundle] = None,
  /* Stylistic data for rendering in a UI */
  style: Option[Map[String, String]] = None,
  /* The type of Processor */
  `type`: Option[String] = None,
  /* The properties for the processor. Properties whose value is not set will only contain the property name. */
  properties: Option[Map[String, String]] = None,
  /* The property descriptors for the processor. */
  propertyDescriptors: Option[Map[String, VersionedPropertyDescriptor]] = None,
  /* The annotation data for the processor used to relay configuration between a custom UI and the procesosr. */
  annotationData: Option[String] = None,
  /* The frequency with which to schedule the processor. The format of the value will depend on th value of schedulingStrategy. */
  schedulingPeriod: Option[String] = None,
  /* Indcates whether the prcessor should be scheduled to run in event or timer driven mode. */
  schedulingStrategy: Option[String] = None,
  /* Indicates the node where the process will execute. */
  executionNode: Option[String] = None,
  /* The amout of time that is used when the process penalizes a flowfile. */
  penaltyDuration: Option[String] = None,
  /* The amount of time that must elapse before this processor is scheduled again after yielding. */
  yieldDuration: Option[String] = None,
  /* The level at which the processor will report bulletins. */
  bulletinLevel: Option[String] = None,
  /* The run duration for the processor in milliseconds. */
  runDurationMillis: Option[Long] = None,
  /* The number of tasks that should be concurrently schedule for the processor. If the processor doesn't allow parallol processing then any positive input will be ignored. */
  concurrentlySchedulableTaskCount: Option[Int] = None,
  /* The names of all relationships that cause a flow file to be terminated if the relationship is not connected elsewhere. This property differs from the 'isAutoTerminate' property of the RelationshipDTO in that the RelationshipDTO is meant to depict the current configuration, whereas this property can be set in a DTO when updating a Processor in order to change which Relationships should be auto-terminated. */
  autoTerminatedRelationships: Option[Set[String]] = None,
  /* The scheduled state of the component */
  scheduledState: Option[VersionedProcessorEnums.ScheduledState] = None,
  componentType: Option[VersionedProcessorEnums.ComponentType] = None,
  /* The ID of the Process Group that this component belongs to */
  groupIdentifier: Option[String] = None
) extends ApiModel

object VersionedProcessorEnums {

  type ScheduledState = ScheduledState.Value
  type ComponentType = ComponentType.Value
  object ScheduledState extends Enumeration {
    val ENABLED = Value("ENABLED")
    val DISABLED = Value("DISABLED")
  }

  object ComponentType extends Enumeration {
    val CONNECTION = Value("CONNECTION")
    val PROCESSOR = Value("PROCESSOR")
    val PROCESSGROUP = Value("PROCESS_GROUP")
    val REMOTEPROCESSGROUP = Value("REMOTE_PROCESS_GROUP")
    val INPUTPORT = Value("INPUT_PORT")
    val OUTPUTPORT = Value("OUTPUT_PORT")
    val REMOTEINPUTPORT = Value("REMOTE_INPUT_PORT")
    val REMOTEOUTPUTPORT = Value("REMOTE_OUTPUT_PORT")
    val FUNNEL = Value("FUNNEL")
    val LABEL = Value("LABEL")
    val CONTROLLERSERVICE = Value("CONTROLLER_SERVICE")
  }

}

