/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.http;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.http.HttpWriter$;
import it.agilelab.bigdata.wasp.core.utils.Utils$;
import it.agilelab.bigdata.wasp.models.HttpCompression;
import it.agilelab.bigdata.wasp.models.HttpCompression$;
import it.agilelab.bigdata.wasp.models.HttpModel;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-u!\u0002\r\u001a\u0011\u0003Qc!\u0002\u0017\u001a\u0011\u0003i\u0003\"B\u001c\u0002\t\u0003A\u0004\"B\u001d\u0002\t\u0003Q\u0004\"CA<\u0003\u0005\u0005I\u0011BA=\r\u0011a\u0013\u0004\u0001\u001f\t\u0011-+!\u0011!Q\u0001\n1C\u0001BW\u0003\u0003\u0002\u0003\u0006Ia\u0014\u0005\t7\u0016\u0011\t\u0011)A\u0005\u001f\"AA,\u0002B\u0001B\u0003%q\n\u0003\u0005^\u000b\t\u0005\t\u0015!\u0003P\u0011!qVA!A!\u0002\u0013y\u0006\u0002\u00032\u0006\u0005\u0003\u0005\u000b\u0011B(\t\u000b]*A\u0011A2\t\u000f-,!\u0019!C\u0005Y\"11/\u0002Q\u0001\n5D\u0001\u0002^\u0003\t\u0006\u0004%I!\u001e\u0005\f\u0003\u0003)\u0001\u0019!a\u0001\n\u0003\t\u0019\u0001C\u0006\u0002\u001a\u0015\u0001\r\u00111A\u0005\u0002\u0005m\u0001bCA\u0014\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u000bAq!!\u000b\u0006\t\u0003\nY\u0003C\u0004\u0002<\u0015!\t%!\u0010\t\u000f\u0005\rS\u0001\"\u0011\u0002F!9\u0011QL\u0003\u0005\n\u0005}\u0013A\u0003%uiB<&/\u001b;fe*\u0011!dG\u0001\u0005QR$\bO\u0003\u0002\u001d;\u00059\u0001\u000f\\;hS:\u001c(B\u0001\u0010 \u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0013%A\u0005d_:\u001cX/\\3sg*\u0011!eI\u0001\u0005o\u0006\u001c\bO\u0003\u0002%K\u00059!-[4eCR\f'B\u0001\u0014(\u0003!\tw-\u001b7fY\u0006\u0014'\"\u0001\u0015\u0002\u0005%$8\u0001\u0001\t\u0003W\u0005i\u0011!\u0007\u0002\u000b\u0011R$\bo\u0016:ji\u0016\u00148cA\u0001/iA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"aL\u001b\n\u0005Y\u0002$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001+\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Y\u00141NA;!\tYSa\u0005\u0002\u0006{A\u0019aH\u0012%\u000e\u0003}R!\u0001Q!\u0002\u0007M\fHN\u0003\u0002\u001f\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9uHA\u0007G_J,\u0017m\u00195Xe&$XM\u001d\t\u0003}%K!AS \u0003\u0007I{w/\u0001\tiK\u0006$WM]:GS\u0016dGMT1nKB\u0019q&T(\n\u00059\u0003$AB(qi&|g\u000e\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%Bj\u0011a\u0015\u0006\u0003)&\na\u0001\u0010:p_Rt\u0014B\u0001,1\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u0003\u0014aA;sY\u0006IQ.\u001a3jCRK\b/Z\u0001\u0007[\u0016$\bn\u001c3\u0002\u001d\r|W\u000e\u001d:fgNLwN\\*ue\u00069An\\4C_\u0012L\bCA\u0018a\u0013\t\t\u0007GA\u0004C_>dW-\u00198\u0002\u001d\t|G-_\"pYVlgNT1nKRA1\bZ3gO\"L'\u000eC\u0003L\u001b\u0001\u0007A\nC\u0003[\u001b\u0001\u0007q\nC\u0003\\\u001b\u0001\u0007q\nC\u0003]\u001b\u0001\u0007q\nC\u0003^\u001b\u0001\u0007q\nC\u0003_\u001b\u0001\u0007q\fC\u0003c\u001b\u0001\u0007q*\u0001\u0004m_\u001e<WM]\u000b\u0002[B\u0011a.]\u0007\u0002_*\u0011\u0001\u000fR\u0001\u0006g24GG[\u0005\u0003e>\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\fG>l\u0007O]3tg&|g.F\u0001w!\t9(0D\u0001y\u0015\tI\u0018%\u0001\u0004n_\u0012,Gn]\u0005\u0003wb\u0014q\u0002\u0013;ua\u000e{W\u000e\u001d:fgNLwN\u001c\u0015\u0003!u\u0004\"a\f@\n\u0005}\u0004$!\u0003;sC:\u001c\u0018.\u001a8u\u00031y7\u000e\u0013;ua\u000ec\u0017.\u001a8u+\t\t)\u0001\u0005\u0003\u0002\b\u0005UQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\r=\\\u0007\u000e\u001e;q\u0015\u0011\ty!!\u0005\u0002\u0011M\fX/\u0019:fkBT!!a\u0005\u0002\u0007\r|W.\u0003\u0003\u0002\u0018\u0005%!\u0001D(l\u0011R$\bo\u00117jK:$\u0018\u0001E8l\u0011R$\bo\u00117jK:$x\fJ3r)\u0011\ti\"a\t\u0011\u0007=\ny\"C\u0002\u0002\"A\u0012A!\u00168ji\"I\u0011Q\u0005\n\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014!D8l\u0011R$\bo\u00117jK:$\b%\u0001\u0003pa\u0016tG#B0\u0002.\u0005]\u0002bBA\u0018)\u0001\u0007\u0011\u0011G\u0001\fa\u0006\u0014H/\u001b;j_:LE\rE\u00020\u0003gI1!!\u000e1\u0005\u0011auN\\4\t\u000f\u0005eB\u00031\u0001\u00022\u00059Q\r]8dQ&#\u0017a\u00029s_\u000e,7o\u001d\u000b\u0005\u0003;\ty\u0004\u0003\u0004\u0002BU\u0001\r\u0001S\u0001\u0006m\u0006dW/Z\u0001\u0006G2|7/\u001a\u000b\u0005\u0003;\t9\u0005C\u0004\u0002JY\u0001\r!a\u0013\u0002\u0017\u0015\u0014(o\u001c:Pe:+H\u000e\u001c\t\u0005\u0003\u001b\n9F\u0004\u0003\u0002P\u0005Mcb\u0001*\u0002R%\t\u0011'C\u0002\u0002VA\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#!\u0003+ie><\u0018M\u00197f\u0015\r\t)\u0006M\u0001\u0005Y><'\t\u0006\u0003\u0002\u001e\u0005\u0005\u0004\u0002CA2/\u0011\u0005\r!!\u001a\u0002\u0003M\u0004BaLA4\u001f&\u0019\u0011\u0011\u000e\u0019\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u001c\u0004\u0001\u0004\ty'A\u0005iiR\u0004Xj\u001c3fYB\u0019q/!\u001d\n\u0007\u0005M\u0004PA\u0005IiR\u0004Xj\u001c3fY\")!m\u0001a\u0001\u001f\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\u000bAA[1wC&!\u0011\u0011RA@\u0005\u0019y%M[3di\u0002")
public class HttpWriter
extends ForeachWriter<Row> {
    private transient HttpCompression compression;
    private final Option<String> headersFieldName;
    private final String url;
    private final String mediaType;
    private final String method;
    private final String compressionStr;
    private final boolean logBody;
    private final String bodyColumnName;
    private final Logger logger;
    private OkHttpClient okHttpClient;
    private volatile transient boolean bitmap$trans$0;

    public static HttpWriter apply(HttpModel httpModel, String string) {
        return HttpWriter$.MODULE$.apply(httpModel, string);
    }

    private Logger logger() {
        return this.logger;
    }

    private HttpCompression compression$lzycompute() {
        HttpWriter httpWriter = this;
        synchronized (httpWriter) {
            if (!this.bitmap$trans$0) {
                this.compression = (HttpCompression)HttpCompression$.MODULE$.fromString().apply((Object)this.compressionStr);
                this.bitmap$trans$0 = true;
            }
        }
        return this.compression;
    }

    private HttpCompression compression() {
        if (!this.bitmap$trans$0) {
            return this.compression$lzycompute();
        }
        return this.compression;
    }

    public OkHttpClient okHttpClient() {
        return this.okHttpClient;
    }

    public void okHttpClient_$eq(OkHttpClient x$1) {
        this.okHttpClient = x$1;
    }

    public boolean open(long partitionId, long epochId) {
        this.okHttpClient_$eq(new OkHttpClient());
        return true;
    }

    public void process(Row value) {
        String string;
        Option header = this.headersFieldName.map((Function1 & Serializable & scala.Serializable)headerName -> Headers.of((Map)value.getJavaMap(value.fieldIndex(headerName))));
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        header.foreach((Function1 & Serializable & scala.Serializable)x$1 -> requestBuilder.headers(x$1));
        byte[] byteArray = (byte[])value.getAs(this.bodyColumnName);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)this.mediaType), (byte[])byteArray);
        this.logB((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("requestBody: ").append(new String(byteArray, StandardCharsets.UTF_8)).toString());
        Request.Builder builder = requestBuilder.method(this.method, requestBody);
        HttpCompression httpCompression = this.compression();
        if (HttpCompression.Disabled$.MODULE$.equals(httpCompression)) {
            string = "identity";
        } else if (HttpCompression.Gzip$.MODULE$.equals(httpCompression)) {
            string = "gzip";
        } else {
            if (HttpCompression.Snappy$.MODULE$.equals(httpCompression)) {
                throw new IllegalArgumentException("Unsupported compression format snappy");
            }
            if (HttpCompression.Lz4$.MODULE$.equals(httpCompression)) {
                throw new IllegalArgumentException("Unsupported compression format lz4");
            }
            throw new MatchError((Object)httpCompression);
        }
        builder.addHeader("Content-Encoding", string);
        Request request = requestBuilder.build();
        this.logB((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("request: ").append(request).toString());
        Response response = this.okHttpClient().newCall(request).execute();
        None$ responseBody = this.logBody ? (Option)Utils$.MODULE$.using((AutoCloseable)response.body(), (Function1 & Serializable & scala.Serializable)b -> new Some((Object)b.string())) : None$.MODULE$;
        responseBody.foreach((Function1 & Serializable & scala.Serializable)b -> {
            HttpWriter.$anonfun$process$6(this, response, b);
            return BoxedUnit.UNIT;
        });
        if (response.code() / 100 != 2) {
            None$ none$ = responseBody;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                String b2 = (String)some.value();
                throw new RuntimeException(new StringBuilder(40).append("Error during http call: ").append(response.toString()).append(", ResponseBody{").append(b2).append("}").toString());
            }
            if (None$.MODULE$.equals(none$)) {
                throw new RuntimeException(new StringBuilder(24).append("Error during http call: ").append(response.toString()).toString());
            }
            throw new MatchError((Object)none$);
        }
    }

    public void close(Throwable errorOrNull) {
    }

    private void logB(Function0<String> s) {
        if (this.logBody) {
            this.logger().info((String)s.apply());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$process$6(HttpWriter $this, Response response$1, String b) {
        $this.logger().info(new StringBuilder(35).append("Body of response: ").append(response$1).append(", ResponseBody{").append(b).append("}}").toString());
    }

    public HttpWriter(Option<String> headersFieldName, String url, String mediaType, String method, String compressionStr, boolean logBody, String bodyColumnName) {
        this.headersFieldName = headersFieldName;
        this.url = url;
        this.mediaType = mediaType;
        this.method = method;
        this.compressionStr = compressionStr;
        this.logBody = logBody;
        this.bodyColumnName = bodyColumnName;
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }
}

