/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.parallel.writers;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import it.agilelab.bigdata.wasp.aws.auth.v2.ConfigurationLoader;
import it.agilelab.bigdata.wasp.aws.auth.v2.CredentialsSerde;
import it.agilelab.bigdata.wasp.aws.auth.v2.ProviderConfiguration;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.parallel.catalog.entity.TemporaryCredentials;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.parallel.catalog.entity.WriteExecutionPlanResponseBody;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.parallel.utils.HadoopS3Utils$;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.parallel.writers.CredentialsConfigurator;
import it.agilelab.bigdata.wasp.core.logging.Logging;
import it.agilelab.bigdata.wasp.core.logging.WaspLogger;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ColdAreaCredentialsPersister$
implements CredentialsConfigurator,
Logging {
    public static ColdAreaCredentialsPersister$ MODULE$;
    private final WaspLogger logger;

    static {
        new ColdAreaCredentialsPersister$();
    }

    public WaspLogger logger() {
        return this.logger;
    }

    public void it$agilelab$bigdata$wasp$core$logging$Logging$_setter_$logger_$eq(WaspLogger x$1) {
        this.logger = x$1;
    }

    public void writeCredentials(WriteExecutionPlanResponseBody writeExecutionPlanResponseBody, Configuration configuration) {
        AWSSessionCredentials awsWriteCredentials = ((TemporaryCredentials)writeExecutionPlanResponseBody.temporaryCredentials().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Entity responded without a credentials field for a COLD case write");
        })).w().toAWSSessionCredentials();
        Path bucketTokenPath = this.computeBucketTokenPath(writeExecutionPlanResponseBody, configuration);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Cleaning old credentials");
        CredentialsSerde.cleanupOldCredentials((Configuration)configuration, (Path)bucketTokenPath);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Old credentials cleaned");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Writing credentials");
        CredentialsSerde.write((Configuration)configuration, (Path)bucketTokenPath, (AWSCredentials)awsWriteCredentials, (String)this.getFileName());
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Wrote credentials");
    }

    private String getFileName() {
        String maxLongAsString = Long.toString(Long.MAX_VALUE);
        long now = Instant.now().toEpochMilli();
        String paddedFileName = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(3).append("%0").append(maxLongAsString.length()).append("d").toString())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)now)}));
        return paddedFileName;
    }

    private Path computeBucketTokenPath(WriteExecutionPlanResponseBody writeExecutionPlanResponseBody, Configuration configuration) {
        URI uri = HadoopS3Utils$.MODULE$.useS3aScheme(new URI((String)writeExecutionPlanResponseBody.writeUri().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("ColdWriter needs to have a writeUri parameter");
        })));
        ProviderConfiguration conf = ConfigurationLoader.lookupConfig((URI)uri, (Configuration)configuration);
        String host = (String)Option$.MODULE$.apply((Object)conf.getBucket().getHost()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "file-bucket");
        return new Path(conf.getStoragePath(), host);
    }

    @Override
    public void configureCredentials(WriteExecutionPlanResponseBody writeExecutionPlanResponseBody, Configuration configuration) {
        this.writeCredentials(writeExecutionPlanResponseBody, configuration);
    }

    private ColdAreaCredentialsPersister$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

