/*
 * Decompiled with CFR 0.152.
 */
package it.agilelab.bigdata.wasp.consumers.spark.plugins.raw.tools;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.raw.tools.Partition;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.raw.tools.PartitionDiscoveryUtils$;
import it.agilelab.bigdata.wasp.consumers.spark.plugins.raw.tools.WhereCondition;
import it.agilelab.bigdata.wasp.models.RawModel;
import it.agilelab.bigdata.wasp.models.RawOptions;
import it.agilelab.bigdata.wasp.repository.core.bl.ConfigBL$;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.runtime.BoxesRunTime;

public final class FolderCompactionUtils$ {
    public static FolderCompactionUtils$ MODULE$;
    private final String INPUT_MODEL_CONF_KEY;
    private final String OUTPUT_MODEL_CONF_KEY;
    private final String PARTITIONS_CONF_KEY;
    private final String NUM_PARTITIONS_CONF_KEY;

    static {
        new FolderCompactionUtils$();
    }

    public String INPUT_MODEL_CONF_KEY() {
        return this.INPUT_MODEL_CONF_KEY;
    }

    public String OUTPUT_MODEL_CONF_KEY() {
        return this.OUTPUT_MODEL_CONF_KEY;
    }

    public String PARTITIONS_CONF_KEY() {
        return this.PARTITIONS_CONF_KEY;
    }

    public String NUM_PARTITIONS_CONF_KEY() {
        return this.NUM_PARTITIONS_CONF_KEY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<List<Partition>> generateCombinations(List<Tuple2<String, List<String>>> partitions) {
        List<Tuple2<String, List<String>>> list = partitions;
        if (Nil$.MODULE$.equals(list)) {
            return Nil$.MODULE$;
        }
        if (!(list instanceof .colon.colon)) throw new MatchError(list);
        .colon.colon colon2 = (.colon.colon)list;
        Tuple2 tuple2 = (Tuple2)colon2.head();
        List tail = colon2.tl$access$1();
        if (tuple2 == null) throw new MatchError(list);
        String colName = (String)tuple2._1();
        List colValues = (List)tuple2._2();
        return this.generateCombinationsForValues(colName, (List<String>)colValues, (List<Tuple2<String, List<String>>>)tail);
    }

    private List<List<Partition>> generateCombinationsForValues(String col, List<String> values, List<Tuple2<String, List<String>>> others) {
        return (List)values.flatMap((Function1 & Serializable & scala.Serializable)value -> MODULE$.generateCombinationsForValue(col, (String)value, others), List$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<List<Partition>> generateCombinationsForValue(String col, String value, List<Tuple2<String, List<String>>> others) {
        List<Tuple2<String, List<String>>> list = others;
        if (Nil$.MODULE$.equals(list)) {
            return new .colon.colon((Object)new .colon.colon((Object)new Partition(col, value), (List)Nil$.MODULE$), (List)Nil$.MODULE$);
        }
        if (!(list instanceof .colon.colon)) throw new MatchError(list);
        .colon.colon colon2 = (.colon.colon)list;
        Tuple2 tuple2 = (Tuple2)colon2.head();
        List tail = colon2.tl$access$1();
        if (tuple2 == null) throw new MatchError(list);
        String colName = (String)tuple2._1();
        List colValues = (List)tuple2._2();
        return (List)this.generateCombinationsForValues(colName, (List<String>)colValues, (List<Tuple2<String, List<String>>>)tail).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Partition partition = new Partition(col, value);
            return x$1.$colon$colon((Object)partition);
        }, List$.MODULE$.canBuildFrom());
    }

    public Map<String, List<String>> parsePartitions(Config conf) {
        Map map;
        if (!conf.hasPath(this.PARTITIONS_CONF_KEY())) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Set partitionsEntrySet = conf.getConfig(this.PARTITIONS_CONF_KEY()).entrySet();
            map = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitionsEntrySet).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                ConfigValue configValue = (ConfigValue)entry.getValue();
                if (!(configValue instanceof ConfigList)) {
                    throw new IllegalArgumentException("Wrong partition configuration format");
                }
                ConfigList configList = (ConfigList)configValue;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(configList.unwrapped()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString(), List$.MODULE$.canBuildFrom()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public RawModel parseModel(Config conf, String key) {
        RawModel rawModel;
        ConfigValueType configValueType = conf.getValue(key).valueType();
        if (ConfigValueType.OBJECT.equals(configValueType)) {
            rawModel = this.parseConfigModel(conf.getConfig(key));
        } else if (ConfigValueType.STRING.equals(configValueType)) {
            String str = conf.getString(key);
            rawModel = (RawModel)ConfigBL$.MODULE$.rawBL().getByName(str).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(28).append("Cannot find model with name ").append(str).toString());
            });
        } else {
            throw new IllegalArgumentException(new StringBuilder(45).append("Conf: ").append(conf.getValue(key)).append(" is neither a String or ").append("a configuration").toString());
        }
        return rawModel;
    }

    public RawModel parseConfigModel(Config conf) {
        String name = conf.getString("name");
        String uri = conf.getString("uri");
        String schema = conf.getString("schema");
        boolean timed = conf.getBoolean("timed");
        String saveMode = conf.getString("options.saveMode");
        String format = conf.getString("options.format");
        None$ partitionBy = conf.hasPath("options.partitionBy") ? new Some((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(conf.getStringList("options.partitionBy")).asScala()).toList()) : None$.MODULE$;
        None$ extraOptions = conf.hasPath("options.extraOptions") ? new Some((Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(conf.getConfig("options.extraOptions").entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), (Object)((ConfigValue)entry.getValue()).unwrapped().toString()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())) : None$.MODULE$;
        RawOptions options = new RawOptions(saveMode, format, (Option)extraOptions, (Option)partitionBy);
        return new RawModel(name, uri, timed, schema, options);
    }

    public List<WhereCondition> generateWhereConditions(Map<String, List<String>> partitions, RawModel inputModel, RawModel outputModel) {
        scala.collection.immutable.Set inputPartitionColumns = (scala.collection.immutable.Set)inputModel.options().partitionBy().map((Function1 & Serializable & scala.Serializable)x$4 -> ((TraversableOnce)x$4.filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)key)))).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set outputPartitionColumns = (scala.collection.immutable.Set)outputModel.options().partitionBy().map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)x$5.filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)key)))).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set commonColumns = (scala.collection.immutable.Set)inputPartitionColumns.intersect((GenSet)outputPartitionColumns);
        scala.collection.immutable.Set onlyInputColumns = (scala.collection.immutable.Set)inputPartitionColumns.diff((GenSet)outputPartitionColumns);
        List<List<Partition>> outputPartitionsCombinations = this.generateCombinations((List<Tuple2<String, List<String>>>)((TraversableOnce)partitions.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)commonColumns.contains(x._1())))).toList());
        List<List<Partition>> inputOnlyPartitionsCombinations = this.generateCombinations((List<Tuple2<String, List<String>>>)((TraversableOnce)partitions.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)onlyInputColumns.contains(x._1())))).toList());
        List<List<Partition>> list = outputPartitionsCombinations;
        Object object = Nil$.MODULE$.equals(list) ? new .colon.colon((Object)new Tuple2((Object)Nil$.MODULE$, inputOnlyPartitionsCombinations), (List)Nil$.MODULE$) : (List)outputPartitionsCombinations.map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)inputOnlyPartitionsCombinations), List$.MODULE$.canBuildFrom());
        List whereConditionsLists = object;
        return (List)whereConditionsLists.map((Function1 & Serializable & scala.Serializable)x -> new WhereCondition((List<Partition>)((List)x._1()), (List<List<Partition>>)((List)x._2())), List$.MODULE$.canBuildFrom());
    }

    public boolean filterWhereCondition(List<Path> files, WhereCondition whereCondition) {
        return files.exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)FolderCompactionUtils$.MODULE$.filterSingleQuery(whereCondition, file)));
    }

    public boolean filterSingleQuery(WhereCondition whereCondition, Path file) {
        String[] folders = file.toString().split("/");
        boolean firstAnd = this.filterPartitionsCombination(folders, whereCondition.outPartitionsCombination());
        List<List<Partition>> list = whereCondition.inPartitionsCombinations();
        boolean bl = Nil$.MODULE$.equals(list) ? true : BoxesRunTime.unboxToBoolean((Object)list.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)FolderCompactionUtils$.$anonfun$filterSingleQuery$1(folders, BoxesRunTime.unboxToBoolean((Object)x0$1), x1$1))));
        boolean secondAnd = bl;
        return firstAnd && secondAnd;
    }

    public boolean filterPartitionsCombination(String[] folders, List<Partition> combination) {
        return combination.forall((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)FolderCompactionUtils$.$anonfun$filterPartitionsCombination$1(folders, partition)));
    }

    public List<Path> discoverPartitionFiles(FileSystem fileSystem, Path basePath, Map<String, List<String>> partitions) {
        List partitionsCombinations = (List)this.generateCombinations((List<Tuple2<String, List<String>>>)partitions.toList()).map((Function1 & Serializable & scala.Serializable)x$7 -> (List)x$7.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toDirName(), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (List)PartitionDiscoveryUtils$.MODULE$.listFiles(fileSystem, basePath).filter((Function1 & Serializable & scala.Serializable)filePath -> BoxesRunTime.boxToBoolean((boolean)partitionsCombinations.exists((Function1 & Serializable & scala.Serializable)combinations -> BoxesRunTime.boxToBoolean((boolean)FolderCompactionUtils$.MODULE$.filterPath(filePath, (List<String>)combinations)))));
    }

    public boolean filterPath(Path path, List<String> combinations) {
        String[] folders = path.toString().split("/");
        return combinations.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)FolderCompactionUtils$.$anonfun$filterPath$1(folders, x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$filterSingleQuery$1(String[] folders$1, boolean x0$1, List x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean acc = tuple2._1$mcZ$sp();
        List combination = (List)tuple2._2();
        boolean bl = acc || MODULE$.filterPartitionsCombination(folders$1, (List<Partition>)combination);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterPartitionsCombination$1(String[] folders$2, Partition partition) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])folders$2)).contains((Object)partition.toDirName());
    }

    public static final /* synthetic */ boolean $anonfun$filterPath$1(String[] folders$3, String x$9) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])folders$3)).contains((Object)x$9);
    }

    private FolderCompactionUtils$() {
        MODULE$ = this;
        this.INPUT_MODEL_CONF_KEY = "inputModel";
        this.OUTPUT_MODEL_CONF_KEY = "outputModel";
        this.PARTITIONS_CONF_KEY = "partitions";
        this.NUM_PARTITIONS_CONF_KEY = "numPartitions";
    }
}

